/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Authorizer;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.authz.permission.PermissionResolver;
import org.apache.shiro.authz.permission.PermissionResolverAware;
import org.apache.shiro.authz.permission.RolePermissionResolver;
import org.apache.shiro.authz.permission.RolePermissionResolverAware;
import org.apache.shiro.authz.permission.WildcardPermissionResolver;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.Initializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthorizingRealm
extends AuthenticatingRealm
implements Authorizer,
Initializable,
PermissionResolverAware,
RolePermissionResolverAware {
    private static final Logger log = LoggerFactory.getLogger(AuthorizingRealm.class);
    private static final String DEFAULT_AUTHORIZATION_CACHE_SUFFIX = ".authorizationCache";
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger();
    private boolean authorizationCachingEnabled;
    private Cache<Object, AuthorizationInfo> authorizationCache;
    private String authorizationCacheName;
    private PermissionResolver permissionResolver;
    private RolePermissionResolver permissionRoleResolver;

    public AuthorizingRealm() {
        this(null, null);
    }

    public AuthorizingRealm(CacheManager cacheManager) {
        this(cacheManager, null);
    }

    public AuthorizingRealm(CredentialsMatcher matcher) {
        this(null, matcher);
    }

    public AuthorizingRealm(CacheManager cacheManager, CredentialsMatcher matcher) {
        if (cacheManager != null) {
            this.setCacheManager(cacheManager);
        }
        if (matcher != null) {
            this.setCredentialsMatcher(matcher);
        }
        this.authorizationCachingEnabled = true;
        this.permissionResolver = new WildcardPermissionResolver();
        int instanceNumber = INSTANCE_COUNT.getAndIncrement();
        this.authorizationCacheName = this.getClass().getName() + DEFAULT_AUTHORIZATION_CACHE_SUFFIX;
        if (instanceNumber > 0) {
            this.authorizationCacheName = this.authorizationCacheName + "." + instanceNumber;
        }
    }

    public void setName(String name) {
        super.setName(name);
        String authzCacheName = this.authorizationCacheName;
        if (authzCacheName != null && authzCacheName.startsWith(this.getClass().getName())) {
            this.authorizationCacheName = name + DEFAULT_AUTHORIZATION_CACHE_SUFFIX;
        }
    }

    public void setAuthorizationCache(Cache<Object, AuthorizationInfo> authorizationCache) {
        this.authorizationCache = authorizationCache;
    }

    public Cache<Object, AuthorizationInfo> getAuthorizationCache() {
        return this.authorizationCache;
    }

    public String getAuthorizationCacheName() {
        return this.authorizationCacheName;
    }

    public void setAuthorizationCacheName(String authorizationCacheName) {
        this.authorizationCacheName = authorizationCacheName;
    }

    public boolean isAuthorizationCachingEnabled() {
        return this.isCachingEnabled() && this.authorizationCachingEnabled;
    }

    public void setAuthorizationCachingEnabled(boolean authenticationCachingEnabled) {
        this.authorizationCachingEnabled = authenticationCachingEnabled;
        if (authenticationCachingEnabled) {
            this.setCachingEnabled(true);
        }
    }

    public PermissionResolver getPermissionResolver() {
        return this.permissionResolver;
    }

    public void setPermissionResolver(PermissionResolver permissionResolver) {
        if (permissionResolver == null) {
            throw new IllegalArgumentException("Null PermissionResolver is not allowed");
        }
        this.permissionResolver = permissionResolver;
    }

    public RolePermissionResolver getRolePermissionResolver() {
        return this.permissionRoleResolver;
    }

    public void setRolePermissionResolver(RolePermissionResolver permissionRoleResolver) {
        this.permissionRoleResolver = permissionRoleResolver;
    }

    protected void onInit() {
        super.onInit();
        this.getAvailableAuthorizationCache();
    }

    protected void afterCacheManagerSet() {
        super.afterCacheManagerSet();
        this.getAvailableAuthorizationCache();
    }

    private Cache<Object, AuthorizationInfo> getAuthorizationCacheLazy() {
        if (this.authorizationCache == null) {
            CacheManager cacheManager;
            if (log.isDebugEnabled()) {
                log.debug("No authorizationCache instance set.  Checking for a cacheManager...");
            }
            if ((cacheManager = this.getCacheManager()) != null) {
                String cacheName = this.getAuthorizationCacheName();
                if (log.isDebugEnabled()) {
                    log.debug("CacheManager [" + cacheManager + "] has been configured.  Building " + "authorization cache named [" + cacheName + "]");
                }
                this.authorizationCache = cacheManager.getCache(cacheName);
            } else if (log.isInfoEnabled()) {
                log.info("No cache or cacheManager properties have been set.  Authorization cache cannot be obtained.");
            }
        }
        return this.authorizationCache;
    }

    private Cache<Object, AuthorizationInfo> getAvailableAuthorizationCache() {
        Cache cache = this.getAuthorizationCache();
        if (cache == null && this.isAuthorizationCachingEnabled()) {
            cache = this.getAuthorizationCacheLazy();
        }
        return cache;
    }

    protected AuthorizationInfo getAuthorizationInfo(PrincipalCollection principals) {
        Object key;
        Cache cache;
        if (principals == null) {
            return null;
        }
        AuthorizationInfo info = null;
        if (log.isTraceEnabled()) {
            log.trace("Retrieving AuthorizationInfo for principals [" + principals + "]");
        }
        if ((cache = this.getAvailableAuthorizationCache()) != null) {
            if (log.isTraceEnabled()) {
                log.trace("Attempting to retrieve the AuthorizationInfo from cache.");
            }
            key = this.getAuthorizationCacheKey(principals);
            info = (AuthorizationInfo)cache.get(key);
            if (log.isTraceEnabled()) {
                if (info == null) {
                    log.trace("No AuthorizationInfo found in cache for principals [" + principals + "]");
                } else {
                    log.trace("AuthorizationInfo found in cache for principals [" + principals + "]");
                }
            }
        }
        if (info == null && (info = this.doGetAuthorizationInfo(principals)) != null && cache != null) {
            if (log.isTraceEnabled()) {
                log.trace("Caching authorization info for principals: [" + principals + "].");
            }
            key = this.getAuthorizationCacheKey(principals);
            cache.put(key, (Object)info);
        }
        return info;
    }

    protected Object getAuthorizationCacheKey(PrincipalCollection principals) {
        return principals;
    }

    protected void clearCachedAuthorizationInfo(PrincipalCollection principals) {
        if (principals == null) {
            return;
        }
        Cache cache = this.getAvailableAuthorizationCache();
        if (cache != null) {
            Object key = this.getAuthorizationCacheKey(principals);
            cache.remove(key);
        }
    }

    protected abstract AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection var1);

    private Collection<Permission> getPermissions(AuthorizationInfo info) {
        HashSet permissions = new HashSet();
        if (info != null) {
            Collection perms = info.getObjectPermissions();
            if (!CollectionUtils.isEmpty((Collection)perms)) {
                permissions.addAll(perms);
            }
            if (!CollectionUtils.isEmpty((Collection)(perms = this.resolvePermissions(info.getStringPermissions())))) {
                permissions.addAll(perms);
            }
            if (!CollectionUtils.isEmpty((Collection)(perms = this.resolveRolePermissions(info.getRoles())))) {
                permissions.addAll(perms);
            }
        }
        if (permissions.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(permissions);
    }

    private Collection<Permission> resolvePermissions(Collection<String> stringPerms) {
        Set<Permission> perms = Collections.emptySet();
        PermissionResolver resolver = this.getPermissionResolver();
        if (resolver != null && !CollectionUtils.isEmpty(stringPerms)) {
            perms = new LinkedHashSet<Permission>(stringPerms.size());
            for (String strPermission : stringPerms) {
                Permission permission = this.getPermissionResolver().resolvePermission(strPermission);
                perms.add(permission);
            }
        }
        return perms;
    }

    private Collection<Permission> resolveRolePermissions(Collection<String> roleNames) {
        Set<Permission> perms = Collections.emptySet();
        RolePermissionResolver resolver = this.getRolePermissionResolver();
        if (resolver != null && !CollectionUtils.isEmpty(roleNames)) {
            perms = new LinkedHashSet<Permission>(roleNames.size());
            for (String roleName : roleNames) {
                Collection resolved = resolver.resolvePermissionsInRole(roleName);
                if (CollectionUtils.isEmpty((Collection)resolved)) continue;
                perms.addAll(resolved);
            }
        }
        return perms;
    }

    public boolean isPermitted(PrincipalCollection principals, String permission) {
        Permission p = this.getPermissionResolver().resolvePermission(permission);
        return this.isPermitted(principals, p);
    }

    public boolean isPermitted(PrincipalCollection principals, Permission permission) {
        AuthorizationInfo info = this.getAuthorizationInfo(principals);
        return this.isPermitted(permission, info);
    }

    private boolean isPermitted(Permission permission, AuthorizationInfo info) {
        Collection perms = this.getPermissions(info);
        if (perms != null && !perms.isEmpty()) {
            for (Permission perm : perms) {
                if (!perm.implies(permission)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean[] isPermitted(PrincipalCollection subjectIdentifier, String ... permissions) {
        ArrayList<Permission> perms = new ArrayList<Permission>(permissions.length);
        for (String permString : permissions) {
            perms.add(this.getPermissionResolver().resolvePermission(permString));
        }
        return this.isPermitted(subjectIdentifier, perms);
    }

    public boolean[] isPermitted(PrincipalCollection principals, List<Permission> permissions) {
        AuthorizationInfo info = this.getAuthorizationInfo(principals);
        return this.isPermitted(permissions, info);
    }

    protected boolean[] isPermitted(List<Permission> permissions, AuthorizationInfo info) {
        boolean[] result;
        if (permissions != null && !permissions.isEmpty()) {
            int size = permissions.size();
            result = new boolean[size];
            int i = 0;
            for (Permission p : permissions) {
                result[i++] = this.isPermitted(p, info);
            }
        } else {
            result = new boolean[]{};
        }
        return result;
    }

    public boolean isPermittedAll(PrincipalCollection subjectIdentifier, String ... permissions) {
        if (permissions != null && permissions.length > 0) {
            ArrayList<Permission> perms = new ArrayList<Permission>(permissions.length);
            for (String permString : permissions) {
                perms.add(this.getPermissionResolver().resolvePermission(permString));
            }
            return this.isPermittedAll(subjectIdentifier, perms);
        }
        return false;
    }

    public boolean isPermittedAll(PrincipalCollection principal, Collection<Permission> permissions) {
        AuthorizationInfo info = this.getAuthorizationInfo(principal);
        return info != null && this.isPermittedAll(permissions, info);
    }

    protected boolean isPermittedAll(Collection<Permission> permissions, AuthorizationInfo info) {
        if (permissions != null && !permissions.isEmpty()) {
            for (Permission p : permissions) {
                if (this.isPermitted(p, info)) continue;
                return false;
            }
        }
        return true;
    }

    public void checkPermission(PrincipalCollection subjectIdentifier, String permission) throws AuthorizationException {
        Permission p = this.getPermissionResolver().resolvePermission(permission);
        this.checkPermission(subjectIdentifier, p);
    }

    public void checkPermission(PrincipalCollection principal, Permission permission) throws AuthorizationException {
        AuthorizationInfo info = this.getAuthorizationInfo(principal);
        this.checkPermission(permission, info);
    }

    protected void checkPermission(Permission permission, AuthorizationInfo info) {
        if (!this.isPermitted(permission, info)) {
            String msg = "User is not permitted [" + permission + "]";
            throw new UnauthorizedException(msg);
        }
    }

    public void checkPermissions(PrincipalCollection subjectIdentifier, String ... permissions) throws AuthorizationException {
        if (permissions != null) {
            for (String permString : permissions) {
                this.checkPermission(subjectIdentifier, permString);
            }
        }
    }

    public void checkPermissions(PrincipalCollection principal, Collection<Permission> permissions) throws AuthorizationException {
        AuthorizationInfo info = this.getAuthorizationInfo(principal);
        this.checkPermissions(permissions, info);
    }

    protected void checkPermissions(Collection<Permission> permissions, AuthorizationInfo info) {
        if (permissions != null && !permissions.isEmpty()) {
            for (Permission p : permissions) {
                this.checkPermission(p, info);
            }
        }
    }

    public boolean hasRole(PrincipalCollection principal, String roleIdentifier) {
        AuthorizationInfo info = this.getAuthorizationInfo(principal);
        return this.hasRole(roleIdentifier, info);
    }

    protected boolean hasRole(String roleIdentifier, AuthorizationInfo info) {
        return info != null && info.getRoles() != null && info.getRoles().contains(roleIdentifier);
    }

    public boolean[] hasRoles(PrincipalCollection principal, List<String> roleIdentifiers) {
        AuthorizationInfo info = this.getAuthorizationInfo(principal);
        boolean[] result = new boolean[roleIdentifiers != null ? roleIdentifiers.size() : 0];
        if (info != null) {
            result = this.hasRoles(roleIdentifiers, info);
        }
        return result;
    }

    protected boolean[] hasRoles(List<String> roleIdentifiers, AuthorizationInfo info) {
        boolean[] result;
        if (roleIdentifiers != null && !roleIdentifiers.isEmpty()) {
            int size = roleIdentifiers.size();
            result = new boolean[size];
            int i = 0;
            for (String roleName : roleIdentifiers) {
                result[i++] = this.hasRole(roleName, info);
            }
        } else {
            result = new boolean[]{};
        }
        return result;
    }

    public boolean hasAllRoles(PrincipalCollection principal, Collection<String> roleIdentifiers) {
        AuthorizationInfo info = this.getAuthorizationInfo(principal);
        return info != null && this.hasAllRoles(roleIdentifiers, info);
    }

    private boolean hasAllRoles(Collection<String> roleIdentifiers, AuthorizationInfo info) {
        if (roleIdentifiers != null && !roleIdentifiers.isEmpty()) {
            for (String roleName : roleIdentifiers) {
                if (this.hasRole(roleName, info)) continue;
                return false;
            }
        }
        return true;
    }

    public void checkRole(PrincipalCollection principal, String role) throws AuthorizationException {
        AuthorizationInfo info = this.getAuthorizationInfo(principal);
        this.checkRole(role, info);
    }

    protected void checkRole(String role, AuthorizationInfo info) {
        if (!this.hasRole(role, info)) {
            String msg = "User does not have role [" + role + "]";
            throw new UnauthorizedException(msg);
        }
    }

    public void checkRoles(PrincipalCollection principal, Collection<String> roles) throws AuthorizationException {
        AuthorizationInfo info = this.getAuthorizationInfo(principal);
        this.checkRoles(roles, info);
    }

    public void checkRoles(PrincipalCollection principal, String ... roles) throws AuthorizationException {
        this.checkRoles(principal, Arrays.asList(roles));
    }

    protected void checkRoles(Collection<String> roles, AuthorizationInfo info) {
        if (roles != null && !roles.isEmpty()) {
            for (String roleName : roles) {
                this.checkRole(roleName, info);
            }
        }
    }

    protected void doClearCache(PrincipalCollection principals) {
        super.doClearCache(principals);
        this.clearCachedAuthorizationInfo(principals);
    }
}

