/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.mgt;

import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSubjectDAO
implements SubjectDAO {
    private static final Logger log = LoggerFactory.getLogger(DefaultSubjectDAO.class);
    private SessionStorageEvaluator sessionStorageEvaluator = new DefaultSessionStorageEvaluator();

    protected boolean isSessionStorageEnabled(Subject subject) {
        return this.getSessionStorageEvaluator().isSessionStorageEnabled(subject);
    }

    public SessionStorageEvaluator getSessionStorageEvaluator() {
        return this.sessionStorageEvaluator;
    }

    public void setSessionStorageEvaluator(SessionStorageEvaluator sessionStorageEvaluator) {
        this.sessionStorageEvaluator = sessionStorageEvaluator;
    }

    public Subject save(Subject subject) {
        if (this.isSessionStorageEnabled(subject)) {
            this.saveToSession(subject);
        } else {
            log.trace("Session storage of subject state for Subject [{}] has been disabled: identity and authentication state are expected to be initialized on every request or invocation.", (Object)subject);
        }
        return subject;
    }

    protected void saveToSession(Subject subject) {
        this.mergePrincipals(subject);
        this.mergeAuthenticationState(subject);
    }

    protected void mergePrincipals(Subject subject) {
        PrincipalCollection currentPrincipals = subject.getPrincipals();
        Session session = subject.getSession(false);
        if (session == null) {
            if (!CollectionUtils.isEmpty((PrincipalCollection)currentPrincipals)) {
                session = subject.getSession();
                session.setAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY, (Object)currentPrincipals);
            }
        } else {
            PrincipalCollection existingPrincipals = (PrincipalCollection)session.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
            if (CollectionUtils.isEmpty((PrincipalCollection)currentPrincipals)) {
                if (!CollectionUtils.isEmpty((PrincipalCollection)existingPrincipals)) {
                    session.removeAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
                }
            } else if (!currentPrincipals.equals(existingPrincipals)) {
                session.setAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY, (Object)currentPrincipals);
            }
        }
    }

    protected void mergeAuthenticationState(Subject subject) {
        Session session = subject.getSession(false);
        if (session == null) {
            if (subject.isAuthenticated()) {
                session = subject.getSession();
                session.setAttribute((Object)DefaultSubjectContext.AUTHENTICATED_SESSION_KEY, (Object)Boolean.TRUE);
            }
        } else {
            Boolean existingAuthc = (Boolean)session.getAttribute((Object)DefaultSubjectContext.AUTHENTICATED_SESSION_KEY);
            if (subject.isAuthenticated()) {
                if (existingAuthc == null || !existingAuthc.booleanValue()) {
                    session.setAttribute((Object)DefaultSubjectContext.AUTHENTICATED_SESSION_KEY, (Object)Boolean.TRUE);
                }
            } else if (existingAuthc != null) {
                session.removeAttribute((Object)DefaultSubjectContext.AUTHENTICATED_SESSION_KEY);
            }
        }
    }

    protected void removeFromSession(Subject subject) {
        Session session = subject.getSession(false);
        if (session != null) {
            session.removeAttribute((Object)DefaultSubjectContext.AUTHENTICATED_SESSION_KEY);
            session.removeAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
        }
    }

    public void delete(Subject subject) {
        this.removeFromSession(subject);
    }
}

