/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.jndi;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.shiro.jndi.JndiCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiTemplate {
    private static final Logger log = LoggerFactory.getLogger(JndiTemplate.class);
    private Properties environment;

    public JndiTemplate() {
    }

    public JndiTemplate(Properties environment) {
        this.environment = environment;
    }

    public void setEnvironment(Properties environment) {
        this.environment = environment;
    }

    public Properties getEnvironment() {
        return this.environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(JndiCallback contextCallback) throws NamingException {
        Context ctx = this.createInitialContext();
        try {
            Object object = contextCallback.doInContext(ctx);
            return object;
        }
        finally {
            try {
                ctx.close();
            }
            catch (NamingException ex) {
                log.debug("Could not close JNDI InitialContext", (Throwable)ex);
            }
        }
    }

    protected Context createInitialContext() throws NamingException {
        Properties env = this.getEnvironment();
        Hashtable<String, String> icEnv = null;
        if (env != null) {
            icEnv = new Hashtable<String, String>(env.size());
            Enumeration<?> en = env.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                icEnv.put(key, env.getProperty(key));
            }
        }
        return new InitialContext(icEnv);
    }

    public Object lookup(String name) throws NamingException {
        log.debug("Looking up JNDI object with name '{}'", (Object)name);
        return this.execute((JndiCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Object lookup(String name, Class requiredType) throws NamingException {
        Object jndiObject = this.lookup(name);
        if (requiredType != null && !requiredType.isInstance(jndiObject)) {
            String msg = "Jndi object acquired under name '" + name + "' is of type [" + jndiObject.getClass().getName() + "] and not assignable to the required type [" + requiredType.getName() + "].";
            throw new NamingException(msg);
        }
        return jndiObject;
    }

    public void bind(String name, Object object) throws NamingException {
        log.debug("Binding JNDI object with name '{}'", (Object)name);
        this.execute((JndiCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void rebind(String name, Object object) throws NamingException {
        log.debug("Rebinding JNDI object with name '{}'", (Object)name);
        this.execute((JndiCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void unbind(String name) throws NamingException {
        log.debug("Unbinding JNDI object with name '{}'", (Object)name);
        this.execute((JndiCallback)new /* Unavailable Anonymous Inner Class!! */);
    }
}

