/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.config.Ini;
import org.apache.shiro.io.ResourceUtils;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Ini
implements Map<String, Section> {
    private static final transient Logger log = LoggerFactory.getLogger(Ini.class);
    public static final String DEFAULT_SECTION_NAME = "";
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final String COMMENT_POUND = "#";
    public static final String COMMENT_SEMICOLON = ";";
    public static final String SECTION_PREFIX = "[";
    public static final String SECTION_SUFFIX = "]";
    protected static final char ESCAPE_TOKEN = '\\';
    private final Map<String, Section> sections = new LinkedHashMap();

    public Ini() {
    }

    public Ini(Ini defaults) {
        this();
        if (defaults == null) {
            throw new NullPointerException("Defaults cannot be null.");
        }
        for (Section section : defaults.getSections()) {
            Section copy = new Section(section, null);
            this.sections.put(section.getName(), copy);
        }
    }

    @Override
    public boolean isEmpty() {
        Collection sections = this.sections.values();
        if (!sections.isEmpty()) {
            for (Section section : sections) {
                if (section.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public Set<String> getSectionNames() {
        return Collections.unmodifiableSet(this.sections.keySet());
    }

    public Collection<Section> getSections() {
        return Collections.unmodifiableCollection(this.sections.values());
    }

    public Section getSection(String sectionName) {
        String name = Ini.cleanName((String)sectionName);
        return (Section)this.sections.get(name);
    }

    public Section addSection(String sectionName) {
        String name = Ini.cleanName((String)sectionName);
        Section section = this.getSection(name);
        if (section == null) {
            section = new Section(name, null);
            this.sections.put(name, section);
        }
        return section;
    }

    public Section removeSection(String sectionName) {
        String name = Ini.cleanName((String)sectionName);
        return (Section)this.sections.remove(name);
    }

    private static String cleanName(String sectionName) {
        String name = StringUtils.clean((String)sectionName);
        if (name == null) {
            log.trace("Specified name was null or empty.  Defaulting to the default section (name = \"\")");
            name = "";
        }
        return name;
    }

    public void setSectionProperty(String sectionName, String propertyName, String propertyValue) {
        String name = Ini.cleanName((String)sectionName);
        Section section = this.getSection(name);
        if (section == null) {
            section = this.addSection(name);
        }
        section.put(propertyName, propertyValue);
    }

    public String getSectionProperty(String sectionName, String propertyName) {
        Section section = this.getSection(sectionName);
        return section != null ? section.get((Object)propertyName) : null;
    }

    public String getSectionProperty(String sectionName, String propertyName, String defaultValue) {
        String value = this.getSectionProperty(sectionName, propertyName);
        return value != null ? value : defaultValue;
    }

    public static Ini fromResourcePath(String resourcePath) throws ConfigurationException {
        if (!StringUtils.hasLength((String)resourcePath)) {
            throw new IllegalArgumentException("Resource Path argument cannot be null or empty.");
        }
        Ini ini = new Ini();
        ini.loadFromPath(resourcePath);
        return ini;
    }

    public void loadFromPath(String resourcePath) throws ConfigurationException {
        InputStream is;
        try {
            is = ResourceUtils.getInputStreamForPath((String)resourcePath);
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
        this.load(is);
    }

    public void load(String iniConfig) throws ConfigurationException {
        this.load(new Scanner(iniConfig));
    }

    public void load(InputStream is) throws ConfigurationException {
        InputStreamReader isr;
        if (is == null) {
            throw new NullPointerException("InputStream argument cannot be null.");
        }
        try {
            isr = new InputStreamReader(is, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigurationException((Throwable)e);
        }
        this.load((Reader)isr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Reader reader) {
        Scanner scanner = new Scanner(reader);
        try {
            this.load(scanner);
        }
        finally {
            try {
                scanner.close();
            }
            catch (Exception e) {
                log.debug("Unable to cleanly close the InputStream scanner.  Non-critical - ignoring.", (Throwable)e);
            }
        }
    }

    private void addSection(String name, StringBuilder content) {
        Section section;
        String contentString;
        String cleaned;
        if (content.length() > 0 && (cleaned = StringUtils.clean((String)(contentString = content.toString()))) != null && !(section = new Section(name, contentString, null)).isEmpty()) {
            this.sections.put(name, section);
        }
    }

    public void load(Scanner scanner) {
        String sectionName = "";
        StringBuilder sectionContent = new StringBuilder();
        while (scanner.hasNextLine()) {
            String rawLine = scanner.nextLine();
            String line = StringUtils.clean((String)rawLine);
            if (line == null || line.startsWith("#") || line.startsWith(";")) continue;
            String newSectionName = Ini.getSectionName((String)line);
            if (newSectionName != null) {
                this.addSection(sectionName, sectionContent);
                sectionContent = new StringBuilder();
                sectionName = newSectionName;
                if (!log.isDebugEnabled()) continue;
                log.debug("Parsing [" + sectionName + "]");
                continue;
            }
            sectionContent.append(rawLine).append("\n");
        }
        this.addSection(sectionName, sectionContent);
    }

    protected static boolean isSectionHeader(String line) {
        String s = StringUtils.clean((String)line);
        return s != null && s.startsWith("[") && s.endsWith("]");
    }

    protected static String getSectionName(String line) {
        String s = StringUtils.clean((String)line);
        if (Ini.isSectionHeader((String)s)) {
            return Ini.cleanName((String)s.substring(1, s.length() - 1));
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Ini) {
            Ini ini = (Ini)obj;
            return ((Object)this.sections).equals(ini.sections);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.sections).hashCode();
    }

    public String toString() {
        if (CollectionUtils.isEmpty((Map)this.sections)) {
            return "<empty INI>";
        }
        StringBuilder sb = new StringBuilder("sections=");
        int i = 0;
        for (Section section : this.sections.values()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(section.toString());
            ++i;
        }
        return sb.toString();
    }

    @Override
    public int size() {
        return this.sections.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.sections.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.sections.containsValue(value);
    }

    @Override
    public Section get(Object key) {
        return (Section)this.sections.get(key);
    }

    @Override
    public Section put(String key, Section value) {
        return this.sections.put(key, value);
    }

    @Override
    public Section remove(Object key) {
        return (Section)this.sections.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Section> m) {
        this.sections.putAll(m);
    }

    @Override
    public void clear() {
        this.sections.clear();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.sections.keySet());
    }

    @Override
    public Collection<Section> values() {
        return Collections.unmodifiableCollection(this.sections.values());
    }

    @Override
    public Set<Map.Entry<String, Section>> entrySet() {
        return Collections.unmodifiableSet(this.sections.entrySet());
    }

    static /* synthetic */ Logger access$300() {
        return log;
    }
}

