/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authz.aop;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.shiro.aop.MethodInvocation;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.aop.AuthenticatedAnnotationMethodInterceptor;
import org.apache.shiro.authz.aop.AuthorizingAnnotationMethodInterceptor;
import org.apache.shiro.authz.aop.AuthorizingMethodInterceptor;
import org.apache.shiro.authz.aop.GuestAnnotationMethodInterceptor;
import org.apache.shiro.authz.aop.PermissionAnnotationMethodInterceptor;
import org.apache.shiro.authz.aop.RoleAnnotationMethodInterceptor;
import org.apache.shiro.authz.aop.UserAnnotationMethodInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationsAuthorizingMethodInterceptor
extends AuthorizingMethodInterceptor {
    protected Collection<AuthorizingAnnotationMethodInterceptor> methodInterceptors = new ArrayList(5);

    public AnnotationsAuthorizingMethodInterceptor() {
        this.methodInterceptors.add(new RoleAnnotationMethodInterceptor());
        this.methodInterceptors.add(new PermissionAnnotationMethodInterceptor());
        this.methodInterceptors.add(new AuthenticatedAnnotationMethodInterceptor());
        this.methodInterceptors.add(new UserAnnotationMethodInterceptor());
        this.methodInterceptors.add(new GuestAnnotationMethodInterceptor());
    }

    public Collection<AuthorizingAnnotationMethodInterceptor> getMethodInterceptors() {
        return this.methodInterceptors;
    }

    public void setMethodInterceptors(Collection<AuthorizingAnnotationMethodInterceptor> methodInterceptors) {
        this.methodInterceptors = methodInterceptors;
    }

    protected void assertAuthorized(MethodInvocation methodInvocation) throws AuthorizationException {
        Collection aamis = this.getMethodInterceptors();
        if (aamis != null && !aamis.isEmpty()) {
            for (AuthorizingAnnotationMethodInterceptor aami : aamis) {
                if (!aami.supports(methodInvocation)) continue;
                aami.assertAuthorized(methodInvocation);
            }
        }
    }
}

