/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.beanutils.WeakFastHashMap;

class WeakFastHashMap
extends HashMap {
    private Map map = null;
    private boolean fast = false;

    public WeakFastHashMap() {
        this.map = this.createMap();
    }

    public WeakFastHashMap(int capacity) {
        this.map = this.createMap(capacity);
    }

    public WeakFastHashMap(int capacity, float factor) {
        this.map = this.createMap(capacity, factor);
    }

    public WeakFastHashMap(Map map) {
        this.map = this.createMap(map);
    }

    public boolean getFast() {
        return this.fast;
    }

    public void setFast(boolean fast) {
        this.fast = fast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        if (this.fast) {
            return this.map.get(key);
        }
        Map map = this.map;
        synchronized (map) {
            return this.map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        if (this.fast) {
            return this.map.size();
        }
        Map map = this.map;
        synchronized (map) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        if (this.fast) {
            return this.map.isEmpty();
        }
        Map map = this.map;
        synchronized (map) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        if (this.fast) {
            return this.map.containsKey(key);
        }
        Map map = this.map;
        synchronized (map) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        if (this.fast) {
            return this.map.containsValue(value);
        }
        Map map = this.map;
        synchronized (map) {
            return this.map.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        if (this.fast) {
            WeakFastHashMap weakFastHashMap = this;
            synchronized (weakFastHashMap) {
                Map temp = this.cloneMap(this.map);
                Object result = temp.put(key, value);
                this.map = temp;
                return result;
            }
        }
        Map map = this.map;
        synchronized (map) {
            return this.map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map in) {
        if (this.fast) {
            WeakFastHashMap weakFastHashMap = this;
            synchronized (weakFastHashMap) {
                Map temp = this.cloneMap(this.map);
                temp.putAll(in);
                this.map = temp;
            }
        }
        Map map = this.map;
        synchronized (map) {
            this.map.putAll(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        if (this.fast) {
            WeakFastHashMap weakFastHashMap = this;
            synchronized (weakFastHashMap) {
                Map temp = this.cloneMap(this.map);
                Object result = temp.remove(key);
                this.map = temp;
                return result;
            }
        }
        Map map = this.map;
        synchronized (map) {
            return this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.fast) {
            WeakFastHashMap weakFastHashMap = this;
            synchronized (weakFastHashMap) {
                this.map = this.createMap();
            }
        }
        Map map = this.map;
        synchronized (map) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map mo = (Map)o;
        if (this.fast) {
            if (mo.size() != this.map.size()) {
                return false;
            }
            Iterator i = this.map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                Object key = e.getKey();
                Object value = e.getValue();
                if (!(value == null ? mo.get(key) != null || !mo.containsKey(key) : !value.equals(mo.get(key)))) continue;
                return false;
            }
            return true;
        }
        Map map = this.map;
        synchronized (map) {
            if (mo.size() != this.map.size()) {
                return false;
            }
            Iterator i = this.map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                Object key = e.getKey();
                Object value = e.getValue();
                if (value == null) {
                    if (mo.get(key) == null && mo.containsKey(key)) continue;
                    return false;
                }
                if (value.equals(mo.get(key))) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        if (this.fast) {
            int h = 0;
            Iterator i = this.map.entrySet().iterator();
            while (i.hasNext()) {
                h += ((Object)i.next()).hashCode();
            }
            return h;
        }
        Map map = this.map;
        synchronized (map) {
            int h = 0;
            Iterator i = this.map.entrySet().iterator();
            while (i.hasNext()) {
                h += ((Object)i.next()).hashCode();
            }
            return h;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        WeakFastHashMap results = null;
        if (this.fast) {
            results = new WeakFastHashMap(this.map);
        } else {
            Map map = this.map;
            synchronized (map) {
                results = new WeakFastHashMap(this.map);
            }
        }
        results.setFast(this.getFast());
        return results;
    }

    public Set entrySet() {
        return new EntrySet(this, null);
    }

    public Set keySet() {
        return new KeySet(this, null);
    }

    public Collection values() {
        return new Values(this, null);
    }

    protected Map createMap() {
        return new WeakHashMap();
    }

    protected Map createMap(int capacity) {
        return new WeakHashMap(capacity);
    }

    protected Map createMap(int capacity, float factor) {
        return new WeakHashMap(capacity, factor);
    }

    protected Map createMap(Map map) {
        return new WeakHashMap(map);
    }

    protected Map cloneMap(Map map) {
        return this.createMap(map);
    }

    static /* synthetic */ boolean access$300(WeakFastHashMap x0) {
        return x0.fast;
    }

    static /* synthetic */ Map access$402(WeakFastHashMap x0, Map x1) {
        x0.map = x1;
        return x0.map;
    }

    static /* synthetic */ Map access$400(WeakFastHashMap x0) {
        return x0.map;
    }
}

