/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.MethodUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class MappedPropertyDescriptor
extends PropertyDescriptor {
    private Reference mappedPropertyTypeRef;
    private MappedMethodReference mappedReadMethodRef;
    private MappedMethodReference mappedWriteMethodRef;
    private static final Class[] STRING_CLASS_PARAMETER = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MappedPropertyDescriptor.class$((String)"java.lang.String")) : class$java$lang$String};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$commons$beanutils$MappedPropertyDescriptor;

    public MappedPropertyDescriptor(String propertyName, Class beanClass) throws IntrospectionException {
        super(propertyName, null, null);
        if (propertyName == null || propertyName.length() == 0) {
            throw new IntrospectionException("bad property name: " + propertyName + " on class: " + beanClass.getClass().getName());
        }
        this.setName(propertyName);
        String base = MappedPropertyDescriptor.capitalizePropertyName((String)propertyName);
        Method mappedReadMethod = null;
        Method mappedWriteMethod = null;
        try {
            try {
                mappedReadMethod = MappedPropertyDescriptor.getMethod((Class)beanClass, (String)("get" + base), (Class[])STRING_CLASS_PARAMETER);
            }
            catch (IntrospectionException e) {
                mappedReadMethod = MappedPropertyDescriptor.getMethod((Class)beanClass, (String)("is" + base), (Class[])STRING_CLASS_PARAMETER);
            }
            Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MappedPropertyDescriptor.class$((String)"java.lang.String")) : class$java$lang$String, mappedReadMethod.getReturnType()};
            mappedWriteMethod = MappedPropertyDescriptor.getMethod((Class)beanClass, (String)("set" + base), (Class[])params);
        }
        catch (IntrospectionException e) {
            // empty catch block
        }
        if (mappedReadMethod == null) {
            mappedWriteMethod = MappedPropertyDescriptor.getMethod((Class)beanClass, (String)("set" + base), (int)2);
        }
        if (mappedReadMethod == null && mappedWriteMethod == null) {
            throw new IntrospectionException("Property '" + propertyName + "' not found on " + beanClass.getName());
        }
        this.mappedReadMethodRef = new MappedMethodReference(mappedReadMethod);
        this.mappedWriteMethodRef = new MappedMethodReference(mappedWriteMethod);
        this.findMappedPropertyType();
    }

    public MappedPropertyDescriptor(String propertyName, Class beanClass, String mappedGetterName, String mappedSetterName) throws IntrospectionException {
        super(propertyName, null, null);
        if (propertyName == null || propertyName.length() == 0) {
            throw new IntrospectionException("bad property name: " + propertyName);
        }
        this.setName(propertyName);
        Method mappedReadMethod = null;
        Method mappedWriteMethod = null;
        mappedReadMethod = MappedPropertyDescriptor.getMethod((Class)beanClass, (String)mappedGetterName, (Class[])STRING_CLASS_PARAMETER);
        if (mappedReadMethod != null) {
            Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MappedPropertyDescriptor.class$((String)"java.lang.String")) : class$java$lang$String, mappedReadMethod.getReturnType()};
            mappedWriteMethod = MappedPropertyDescriptor.getMethod((Class)beanClass, (String)mappedSetterName, (Class[])params);
        } else {
            mappedWriteMethod = MappedPropertyDescriptor.getMethod((Class)beanClass, (String)mappedSetterName, (int)2);
        }
        this.mappedReadMethodRef = new MappedMethodReference(mappedReadMethod);
        this.mappedWriteMethodRef = new MappedMethodReference(mappedWriteMethod);
        this.findMappedPropertyType();
    }

    public MappedPropertyDescriptor(String propertyName, Method mappedGetter, Method mappedSetter) throws IntrospectionException {
        super(propertyName, mappedGetter, mappedSetter);
        if (propertyName == null || propertyName.length() == 0) {
            throw new IntrospectionException("bad property name: " + propertyName);
        }
        this.setName(propertyName);
        this.mappedReadMethodRef = new MappedMethodReference(mappedGetter);
        this.mappedWriteMethodRef = new MappedMethodReference(mappedSetter);
        this.findMappedPropertyType();
    }

    public Class getMappedPropertyType() {
        return (Class)this.mappedPropertyTypeRef.get();
    }

    public Method getMappedReadMethod() {
        return MappedMethodReference.access$000((MappedMethodReference)this.mappedReadMethodRef);
    }

    public void setMappedReadMethod(Method mappedGetter) throws IntrospectionException {
        this.mappedReadMethodRef = new MappedMethodReference(mappedGetter);
        this.findMappedPropertyType();
    }

    public Method getMappedWriteMethod() {
        return MappedMethodReference.access$000((MappedMethodReference)this.mappedWriteMethodRef);
    }

    public void setMappedWriteMethod(Method mappedSetter) throws IntrospectionException {
        this.mappedWriteMethodRef = new MappedMethodReference(mappedSetter);
        this.findMappedPropertyType();
    }

    private void findMappedPropertyType() throws IntrospectionException {
        Method mappedReadMethod = this.getMappedReadMethod();
        Method mappedWriteMethod = this.getMappedWriteMethod();
        Class<?> mappedPropertyType = null;
        if (mappedReadMethod != null) {
            if (mappedReadMethod.getParameterTypes().length != 1) {
                throw new IntrospectionException("bad mapped read method arg count");
            }
            mappedPropertyType = mappedReadMethod.getReturnType();
            if (mappedPropertyType == Void.TYPE) {
                throw new IntrospectionException("mapped read method " + mappedReadMethod.getName() + " returns void");
            }
        }
        if (mappedWriteMethod != null) {
            Class<?>[] params = mappedWriteMethod.getParameterTypes();
            if (params.length != 2) {
                throw new IntrospectionException("bad mapped write method arg count");
            }
            if (mappedPropertyType != null && mappedPropertyType != params[1]) {
                throw new IntrospectionException("type mismatch between mapped read and write methods");
            }
            mappedPropertyType = params[1];
        }
        this.mappedPropertyTypeRef = new SoftReference<Object>(mappedPropertyType);
    }

    private static String capitalizePropertyName(String s) {
        if (s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    private static Method internalGetMethod(Class initial, String methodName, int parameterCount) {
        for (Class clazz = initial; clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                int mods;
                Method method = methods[i];
                if (method == null || !Modifier.isPublic(mods = method.getModifiers()) || Modifier.isStatic(mods) || !method.getName().equals(methodName) || method.getParameterTypes().length != parameterCount) continue;
                return method;
            }
        }
        Class<?>[] interfaces = initial.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Method method = MappedPropertyDescriptor.internalGetMethod(interfaces[i], (String)methodName, (int)parameterCount);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static Method getMethod(Class clazz, String methodName, int parameterCount) throws IntrospectionException {
        if (methodName == null) {
            return null;
        }
        Method method = MappedPropertyDescriptor.internalGetMethod((Class)clazz, (String)methodName, (int)parameterCount);
        if (method != null) {
            return method;
        }
        throw new IntrospectionException("No method \"" + methodName + "\" with " + parameterCount + " parameter(s)");
    }

    private static Method getMethod(Class clazz, String methodName, Class[] parameterTypes) throws IntrospectionException {
        if (methodName == null) {
            return null;
        }
        Method method = MethodUtils.getMatchingAccessibleMethod((Class)clazz, (String)methodName, (Class[])parameterTypes);
        if (method != null) {
            return method;
        }
        int parameterCount = parameterTypes == null ? 0 : parameterTypes.length;
        throw new IntrospectionException("No method \"" + methodName + "\" with " + parameterCount + " parameter(s) of matching types.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ Class[] access$100() {
        return STRING_CLASS_PARAMETER;
    }
}

