/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.pool.impl;

import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.paging.UpfrontAllocatingPageSource;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.ehcache.store.offheap.OffHeapStoreFactory;
import net.sf.ehcache.store.offheap.configuration.OffHeapConfiguration;
import net.sf.ehcache.store.offheap.pool.OffHeapPool;
import net.sf.ehcache.store.offheap.pool.OffHeapPoolEvictor;
import net.sf.ehcache.store.offheap.pool.OffHeapPoolableStore;

public class OffHeapPoolImpl
implements OffHeapPool {
    private final OffHeapPoolEvictor evictor;
    private final Collection<OffHeapPoolableStore> caches = new CopyOnWriteArrayList<OffHeapPoolableStore>();
    private final OffHeapConfiguration config;
    private final PageSource source;

    public OffHeapPoolImpl(OffHeapConfiguration config, OffHeapPoolEvictor evictor) {
        this.config = config;
        this.evictor = evictor;
        this.source = new UpfrontAllocatingPageSource(OffHeapStoreFactory.getBufferSource(), config.getMaximumSize(), config.getMaximumChunkSize(), config.getMinimumChunkSize());
    }

    @Override
    public Collection<OffHeapPoolableStore> getOffHeapPoolableStores() {
        return this.caches;
    }

    @Override
    public void registerStore(OffHeapPoolableStore store) {
        this.caches.add(store);
    }

    @Override
    public PageSource getPageSource() {
        return this.source;
    }

    @Override
    public OffHeapConfiguration getPoolConfiguration() {
        return this.config;
    }

    @Override
    public OffHeapPoolEvictor getEvictor() {
        return this.evictor;
    }
}

