/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.pool.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.store.offheap.pool.OffHeapPoolEvictor;
import net.sf.ehcache.store.offheap.pool.OffHeapPoolableStore;
import net.sf.ehcache.store.offheap.pool.impl.CrossPoolEvictionException;

public class OffHeapPoolEvictorImpl
implements OffHeapPoolEvictor {
    private static final double ALPHA = 1.0;
    private static final int SAMPLE_SIZE = 5;

    @Override
    public boolean freeSpace(Collection<OffHeapPoolableStore> from, long bytes) {
        return this.freeSpace(from, bytes, null, 0);
    }

    @Override
    public boolean freeSpace(Collection<OffHeapPoolableStore> from, long bytes, OffHeapPoolableStore requestor, int excludedHash) {
        ArrayList<OffHeapPoolableStore> random = new ArrayList<OffHeapPoolableStore>(from);
        Collections.shuffle(random);
        for (int i = 0; i < random.size(); i += 5) {
            List<OffHeapPoolableStore> sorted = random.subList(i, Math.min(5 + i, random.size()));
            Collections.sort(sorted, new EvictionCostComparator(OffHeapPoolEvictorImpl.getDesiredUnloadedSize(sorted), sorted.size() + 1));
            for (OffHeapPoolableStore store : sorted) {
                if (!(store == requestor ? store.evictFromOffHeap(0, bytes, excludedHash) : store.evictFromOffHeap(0, bytes))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean freeSpace(OffHeapPoolableStore preferential, Collection<OffHeapPoolableStore> from, long bytes) {
        List<OffHeapPoolableStore> subset = new ArrayList<OffHeapPoolableStore>(from);
        Collections.shuffle(subset);
        subset = subset.subList(0, Math.min(5, subset.size()));
        long unloadedSize = OffHeapPoolEvictorImpl.getDesiredUnloadedSize(subset);
        float localCost = OffHeapPoolEvictorImpl.evictionCost(preferential, unloadedSize);
        float costThreshold = Float.isInfinite(localCost) ? localCost : localCost - 0.1f * Math.abs(localCost);
        for (OffHeapPoolableStore s : subset) {
            float remoteCost = OffHeapPoolEvictorImpl.evictionCost(s, unloadedSize);
            if (!(remoteCost < costThreshold)) continue;
            throw CrossPoolEvictionException.INSTANCE;
        }
        if (preferential.evictFromOffHeap(0, bytes)) {
            return true;
        }
        throw CrossPoolEvictionException.INSTANCE;
    }

    private static float evictionCost(OffHeapPoolableStore store, long unloadedSize) {
        float hitRate = store.getApproximateOffHeapHitRate();
        float missRate = store.getApproximateOffHeapMissRate();
        long countSize = store.getApproximateSize();
        float accessRate = hitRate + missRate;
        if (accessRate == 0.0f) {
            if (store.getApproximateAllocatedCapacityInBytes() > unloadedSize) {
                return Float.NEGATIVE_INFINITY;
            }
            return Float.POSITIVE_INFINITY;
        }
        if (hitRate == 0.0f) {
            return Float.POSITIVE_INFINITY;
        }
        float cost = hitRate / (float)countSize * OffHeapPoolEvictorImpl.hitDistributionFunction(hitRate / accessRate);
        if (Float.isNaN(cost)) {
            throw new AssertionError((Object)String.format("NaN Eviction Cost [hit:%f miss:%f size:%d]", Float.valueOf(hitRate), Float.valueOf(missRate), countSize));
        }
        return cost;
    }

    private static float hitDistributionFunction(float fillLevel) {
        return (float)Math.pow(fillLevel, -1.0);
    }

    private static long getDesiredUnloadedSize(Collection<OffHeapPoolableStore> from) {
        long unloadedSize = 0L;
        for (OffHeapPoolableStore s : from) {
            unloadedSize += s.getApproximateAllocatedCapacityInBytes();
        }
        return unloadedSize / (long)from.size();
    }

    private static final class EvictionCostComparator
    implements Comparator<OffHeapPoolableStore> {
        private final long unloadedSize;
        private final Map<OffHeapPoolableStore, Float> evictionCostCache;

        public EvictionCostComparator(long unloadedSize, int collectionSize) {
            this.unloadedSize = unloadedSize;
            this.evictionCostCache = new IdentityHashMap<OffHeapPoolableStore, Float>(collectionSize);
        }

        @Override
        public int compare(OffHeapPoolableStore o1, OffHeapPoolableStore o2) {
            Float f2;
            Float f1 = this.evictionCostCache.get(o1);
            if (f1 == null) {
                f1 = Float.valueOf(OffHeapPoolEvictorImpl.evictionCost(o1, this.unloadedSize));
                this.evictionCostCache.put(o1, f1);
            }
            if ((f2 = this.evictionCostCache.get(o2)) == null) {
                f2 = Float.valueOf(OffHeapPoolEvictorImpl.evictionCost(o2, this.unloadedSize));
                this.evictionCostCache.put(o2, f2);
            }
            return Float.compare(f1.floatValue(), f2.floatValue());
        }
    }
}

