/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.service.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.management.resource.CacheConfigEntity;
import net.sf.ehcache.management.resource.CacheEntity;
import net.sf.ehcache.management.resource.CacheManagerConfigEntity;
import net.sf.ehcache.management.resource.CacheManagerEntity;
import net.sf.ehcache.management.resource.CacheStatisticSampleEntity;
import net.sf.ehcache.management.sampled.CacheManagerSampler;
import net.sf.ehcache.management.sampled.ComprehensiveCacheSampler;
import net.sf.ehcache.management.service.CacheManagerService;
import net.sf.ehcache.management.service.CacheService;
import net.sf.ehcache.management.service.EntityResourceFactory;
import net.sf.ehcache.management.service.SamplerRepositoryService;
import net.sf.ehcache.management.service.impl.CacheConfigurationEntityBuilder;
import net.sf.ehcache.management.service.impl.CacheEntityBuilder;
import net.sf.ehcache.management.service.impl.CacheManagerConfigurationEntityBuilder;
import net.sf.ehcache.management.service.impl.CacheManagerEntityBuilder;
import net.sf.ehcache.management.service.impl.CacheStatisticSampleEntityBuilder;
import net.sf.ehcache.management.service.impl.DfltSamplerRepositoryService;
import org.terracotta.management.ServiceExecutionException;

public final class DfltSamplerRepositoryService
implements SamplerRepositoryService,
EntityResourceFactory,
CacheManagerService,
CacheService {
    private final Map<String, SamplerRepoEntry> cacheManagerSamplerRepo = new HashMap();
    private final ReadWriteLock cacheManagerSamplerRepoLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(CacheManager cacheManager) {
        String cmName = cacheManager.getName();
        this.cacheManagerSamplerRepoLock.writeLock().lock();
        try {
            if (!this.cacheManagerSamplerRepo.containsKey(cmName)) {
                SamplerRepoEntry entry = new SamplerRepoEntry(cacheManager);
                cacheManager.setCacheManagerEventListener((CacheManagerEventListener)entry);
                this.cacheManagerSamplerRepo.put(cmName, entry);
            }
        }
        finally {
            this.cacheManagerSamplerRepoLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(CacheManager cacheManager) {
        this.cacheManagerSamplerRepoLock.writeLock().lock();
        try {
            SamplerRepoEntry entry = (SamplerRepoEntry)this.cacheManagerSamplerRepo.remove(cacheManager.getName());
            entry.destroy();
        }
        finally {
            this.cacheManagerSamplerRepoLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRegistered() {
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            boolean bl = !this.cacheManagerSamplerRepo.isEmpty();
            return bl;
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CacheManagerEntity> createCacheManagerEntities(Set<String> cacheManagerNames, Set<String> attributes) {
        Collection entities;
        CacheManagerEntityBuilder builder = null;
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            if (cacheManagerNames == null) {
                for (SamplerRepoEntry entry : this.cacheManagerSamplerRepo.values()) {
                    builder = builder == null ? CacheManagerEntityBuilder.createWith((CacheManagerSampler)entry.getCacheManagerSampler()) : builder.add(entry.getCacheManagerSampler());
                }
            } else {
                for (String cmName : cacheManagerNames) {
                    SamplerRepoEntry entry = (SamplerRepoEntry)this.cacheManagerSamplerRepo.get(cmName);
                    if (entry == null) continue;
                    builder = builder == null ? CacheManagerEntityBuilder.createWith((CacheManagerSampler)entry.getCacheManagerSampler()) : builder.add(entry.getCacheManagerSampler());
                }
            }
            entities = builder == null ? new HashSet(0) : (attributes == null ? builder.build() : builder.add(attributes).build());
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CacheManagerConfigEntity> createCacheManagerConfigEntities(Set<String> cacheManagerNames) {
        HashSet<CacheManagerConfigEntity> entities;
        CacheManagerConfigurationEntityBuilder builder = null;
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            if (cacheManagerNames == null) {
                for (SamplerRepoEntry entry : this.cacheManagerSamplerRepo.values()) {
                    builder = builder == null ? CacheManagerConfigurationEntityBuilder.createWith((CacheManagerSampler)entry.getCacheManagerSampler()) : builder.add(entry.getCacheManagerSampler());
                }
            } else {
                for (String cmName : cacheManagerNames) {
                    SamplerRepoEntry entry = (SamplerRepoEntry)this.cacheManagerSamplerRepo.get(cmName);
                    if (entry == null) continue;
                    builder = builder == null ? CacheManagerConfigurationEntityBuilder.createWith((CacheManagerSampler)entry.getCacheManagerSampler()) : builder.add(entry.getCacheManagerSampler());
                }
            }
            entities = builder == null ? new HashSet<CacheManagerConfigEntity>(0) : builder.build();
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CacheEntity> createCacheEntities(Set<String> cacheManagerNames, Set<String> cacheNames, Set<String> attributes) {
        Collection entities;
        CacheEntityBuilder builder = null;
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            if (cacheManagerNames == null) {
                for (Map.Entry entry : this.cacheManagerSamplerRepo.entrySet()) {
                    for (ComprehensiveCacheSampler sampler : ((SamplerRepoEntry)entry.getValue()).getComprehensiveCacheSamplers(cacheNames)) {
                        builder = builder == null ? CacheEntityBuilder.createWith((ComprehensiveCacheSampler)sampler, (String)((String)entry.getKey())) : builder.add(sampler, (String)entry.getKey());
                    }
                }
            } else {
                for (String cmName : cacheManagerNames) {
                    SamplerRepoEntry entry = (SamplerRepoEntry)this.cacheManagerSamplerRepo.get(cmName);
                    if (entry == null) continue;
                    for (ComprehensiveCacheSampler sampler : entry.getComprehensiveCacheSamplers(cacheNames)) {
                        builder = builder == null ? CacheEntityBuilder.createWith((ComprehensiveCacheSampler)sampler, (String)cmName) : builder.add(sampler, cmName);
                    }
                }
            }
            entities = builder == null ? new HashSet(0) : (attributes == null ? builder.build() : builder.add(attributes).build());
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CacheConfigEntity> createCacheConfigEntities(Set<String> cacheManagerNames, Set<String> cacheNames) {
        HashSet<CacheConfigEntity> entities;
        CacheConfigurationEntityBuilder builder = null;
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            if (cacheManagerNames == null) {
                for (Map.Entry entry : this.cacheManagerSamplerRepo.entrySet()) {
                    for (ComprehensiveCacheSampler sampler : ((SamplerRepoEntry)entry.getValue()).getComprehensiveCacheSamplers(cacheNames)) {
                        builder = builder == null ? CacheConfigurationEntityBuilder.createWith((CacheManagerSampler)((SamplerRepoEntry)entry.getValue()).getCacheManagerSampler(), (String)sampler.getCacheName()) : builder.add(((SamplerRepoEntry)entry.getValue()).getCacheManagerSampler(), sampler.getCacheName());
                    }
                }
            } else {
                for (String cmName : cacheManagerNames) {
                    SamplerRepoEntry entry = (SamplerRepoEntry)this.cacheManagerSamplerRepo.get(cmName);
                    if (entry == null) continue;
                    for (ComprehensiveCacheSampler sampler : entry.getComprehensiveCacheSamplers(cacheNames)) {
                        builder = builder == null ? CacheConfigurationEntityBuilder.createWith((CacheManagerSampler)entry.getCacheManagerSampler(), (String)sampler.getCacheName()) : builder.add(entry.getCacheManagerSampler(), sampler.getCacheName());
                    }
                }
            }
            entities = builder == null ? new HashSet<CacheConfigEntity>(0) : builder.build();
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CacheStatisticSampleEntity> createCacheStatisticSampleEntity(Set<String> cacheManagerNames, Set<String> cacheNames, Set<String> sampleNames) {
        CacheStatisticSampleEntityBuilder builder = CacheStatisticSampleEntityBuilder.createWith(sampleNames);
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            if (cacheManagerNames == null) {
                for (Map.Entry entry : this.cacheManagerSamplerRepo.entrySet()) {
                    for (ComprehensiveCacheSampler sampler : ((SamplerRepoEntry)entry.getValue()).getComprehensiveCacheSamplers(cacheNames)) {
                        builder.add(sampler, (String)entry.getKey());
                    }
                }
            } else {
                for (String string : cacheManagerNames) {
                    SamplerRepoEntry entry = (SamplerRepoEntry)this.cacheManagerSamplerRepo.get(string);
                    if (entry == null) continue;
                    for (ComprehensiveCacheSampler sampler : entry.getComprehensiveCacheSamplers(cacheNames)) {
                        builder.add(sampler, string);
                    }
                }
            }
            Collection collection = builder.build();
            return collection;
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCacheStats(String cacheManagerName, String cacheName) {
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            SamplerRepoEntry entry = (SamplerRepoEntry)this.cacheManagerSamplerRepo.get(cacheManagerName);
            if (entry != null) {
                entry.clearStats(cacheName);
            }
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOrUpdateCache(String cacheManagerName, String cacheName, CacheEntity resource) throws ServiceExecutionException {
        block4: {
            this.cacheManagerSamplerRepoLock.readLock().lock();
            try {
                SamplerRepoEntry entry = (SamplerRepoEntry)this.cacheManagerSamplerRepo.get(cacheManagerName);
                if (entry != null) {
                    entry.updateCache(cacheName, resource);
                    break block4;
                }
                throw new UnsupportedOperationException("Create cache not implemented!");
            }
            finally {
                this.cacheManagerSamplerRepoLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(String cacheManagerName, String cacheName) {
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            SamplerRepoEntry entry = (SamplerRepoEntry)this.cacheManagerSamplerRepo.get(cacheManagerName);
            if (entry != null) {
                entry.clearCache(cacheName);
            }
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCacheManager(String cacheManagerName, CacheManagerEntity resource) throws ServiceExecutionException {
        this.cacheManagerSamplerRepoLock.writeLock().lock();
        try {
            SamplerRepoEntry entry = (SamplerRepoEntry)this.cacheManagerSamplerRepo.get(cacheManagerName);
            if (entry != null) {
                Object mblhsAttr;
                Object mbldsAttr;
                Object mblhAttr;
                CacheManagerSampler cms = entry.getCacheManagerSampler();
                Object mbldAttr = resource.getAttributes().get("MaxBytesLocalDisk");
                if (mbldAttr != null) {
                    cms.setMaxBytesLocalDisk(Long.parseLong(mbldAttr.toString()));
                }
                if ((mblhAttr = resource.getAttributes().get("MaxBytesLocalHeap")) != null) {
                    cms.setMaxBytesLocalDisk(Long.parseLong(mblhAttr.toString()));
                }
                if ((mbldsAttr = resource.getAttributes().get("MaxBytesLocalDiskAsString")) != null) {
                    cms.setMaxBytesLocalDiskAsString(mbldsAttr.toString());
                }
                if ((mblhsAttr = resource.getAttributes().get("MaxBytesLocalHeapAsString")) != null) {
                    cms.setMaxBytesLocalHeapAsString(mblhsAttr.toString());
                }
            }
        }
        finally {
            this.cacheManagerSamplerRepoLock.writeLock().unlock();
        }
    }
}

