/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage.portability;

import com.terracottatech.offheapstore.storage.portability.Portability;
import com.terracottatech.offheapstore.util.ByteBufferInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SerializablePortability
implements Portability<Serializable> {
    protected int nextStreamIndex = 0;
    protected final ConcurrentMap<Object, Object> lookup = new ConcurrentHashMap<Object, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer encode(Serializable object) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream oout = this.getObjectOutputStream(bout);
            try {
                oout.writeObject(object);
            }
            finally {
                oout.close();
            }
            return ByteBuffer.wrap(bout.toByteArray());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable decode(ByteBuffer buffer) {
        Serializable serializable;
        ObjectInputStream oin = this.getObjectInputStream(new ByteBufferInputStream(buffer));
        try {
            serializable = (Serializable)oin.readObject();
        }
        catch (Throwable throwable) {
            try {
                oin.close();
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        oin.close();
        return serializable;
    }

    public ObjectOutputStream getObjectOutputStream(OutputStream out) throws IOException {
        return new OOS(out);
    }

    public ObjectInputStream getObjectInputStream(InputStream input) throws IOException {
        return new OIS(input);
    }

    @Override
    public boolean equals(Object value, ByteBuffer readBuffer) {
        return value.equals(this.decode(readBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getOrAddMapping(ObjectStreamClass desc) throws IOException {
        SerializableDataKey probe = new SerializableDataKey(desc);
        Integer rep = (Integer)this.lookup.get(probe);
        if (rep == null) {
            ConcurrentMap<Object, Object> concurrentMap = this.lookup;
            synchronized (concurrentMap) {
                rep = (Integer)this.lookup.get(probe);
                if (rep == null) {
                    ObjectStreamClass existingOsc;
                    ObjectStreamClass disconnected = SerializablePortability.disconnect(desc);
                    SerializableDataKey key = new SerializableDataKey(disconnected);
                    if ((existingOsc = (ObjectStreamClass)this.lookup.putIfAbsent(rep = Integer.valueOf(this.nextStreamIndex++), disconnected)) != null) {
                        throw new AssertionError((Object)("Existing mapping for this index detected : " + rep + " => " + existingOsc.getName()));
                    }
                    Integer existingRep = (Integer)this.lookup.putIfAbsent(key, rep);
                    if (existingRep != null) {
                        throw new AssertionError((Object)("Existing mapping to this type detected : " + existingRep + " => " + disconnected.getName()));
                    }
                    this.addedMapping(rep, disconnected);
                }
            }
        }
        return rep;
    }

    protected void addedMapping(Integer rep, ObjectStreamClass disconnected) {
    }

    private static boolean equals(SerializableDataKey k1, SerializableDataKey k2) {
        if (k1.forClass() != null && k2.forClass() != null) {
            return k1.forClass() == k2.forClass();
        }
        if (SerializablePortability.equals(k1.getObjectStreamClass(), k2.getObjectStreamClass())) {
            if (k1.forClass() != null) {
                k2.setClass(k1.forClass());
            } else if (k2.forClass() != null) {
                k1.setClass(k2.forClass());
            }
            return true;
        }
        return false;
    }

    private static boolean equals(ObjectStreamClass osc1, ObjectStreamClass osc2) {
        if (osc1 == osc2) {
            return true;
        }
        if (osc1.getName().equals(osc2.getName()) && osc1.getSerialVersionUID() == osc2.getSerialVersionUID() && osc1.getFields().length == osc2.getFields().length) {
            try {
                return Arrays.equals(SerializablePortability.getSerializedForm(osc1), SerializablePortability.getSerializedForm(osc2));
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return false;
    }

    private static ObjectStreamClass disconnect(ObjectStreamClass desc) {
        try {
            ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(SerializablePortability.getSerializedForm(desc))){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
                    return null;
                }
            };
            return (ObjectStreamClass)oin.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getSerializedForm(ObjectStreamClass desc) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            try {
                oout.writeObject(desc);
            }
            finally {
                oout.close();
            }
        }
        finally {
            bout.close();
        }
        return bout.toByteArray();
    }

    protected static class SerializableDataKey {
        private final ObjectStreamClass osc;
        private final int hashCode;
        private transient WeakReference<Class<?>> klazz;

        public SerializableDataKey(ObjectStreamClass desc) throws IOException {
            this.klazz = new WeakReference(desc.forClass());
            this.hashCode = 3 * desc.getName().hashCode() ^ 7 * (int)(desc.getSerialVersionUID() >>> 32) ^ 11 * (int)desc.getSerialVersionUID();
            this.osc = desc;
        }

        public boolean equals(Object o) {
            if (o instanceof SerializableDataKey) {
                return SerializablePortability.equals(this, (SerializableDataKey)o);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public Class<?> forClass() {
            if (this.klazz == null) {
                return null;
            }
            return (Class)this.klazz.get();
        }

        public void setClass(Class<?> clazz) {
            this.klazz = new WeakReference(clazz);
        }

        public ObjectStreamClass getObjectStreamClass() {
            return this.osc;
        }
    }

    class OIS
    extends ObjectInputStream {
        public OIS(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            return (ObjectStreamClass)SerializablePortability.this.lookup.get(this.readInt());
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                if (tccl == null) {
                    return super.resolveClass(desc);
                }
                try {
                    return Class.forName(desc.getName(), false, tccl);
                }
                catch (ClassNotFoundException e) {
                    return super.resolveClass(desc);
                }
            }
            catch (SecurityException ex) {
                return super.resolveClass(desc);
            }
        }
    }

    class OOS
    extends ObjectOutputStream {
        public OOS(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
            this.writeInt(SerializablePortability.this.getOrAddMapping(desc));
        }
    }
}

