/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.schemagen;

import com.sun.xml.bind.Util;
import com.sun.xml.bind.api.CompositeStructure;
import com.sun.xml.bind.api.ErrorListener;
import com.sun.xml.bind.v2.model.core.Adapter;
import com.sun.xml.bind.v2.model.core.ArrayInfo;
import com.sun.xml.bind.v2.model.core.AttributePropertyInfo;
import com.sun.xml.bind.v2.model.core.ClassInfo;
import com.sun.xml.bind.v2.model.core.ElementInfo;
import com.sun.xml.bind.v2.model.core.ElementPropertyInfo;
import com.sun.xml.bind.v2.model.core.EnumLeafInfo;
import com.sun.xml.bind.v2.model.core.NonElement;
import com.sun.xml.bind.v2.model.core.NonElementRef;
import com.sun.xml.bind.v2.model.core.PropertyInfo;
import com.sun.xml.bind.v2.model.core.TypeInfoSet;
import com.sun.xml.bind.v2.model.core.TypeRef;
import com.sun.xml.bind.v2.model.core.WildcardMode;
import com.sun.xml.bind.v2.model.nav.Navigator;
import com.sun.xml.bind.v2.runtime.SwaRefAdapter;
import com.sun.xml.bind.v2.schemagen.FoolProofResolver;
import com.sun.xml.bind.v2.schemagen.MultiMap;
import com.sun.xml.bind.v2.schemagen.XmlSchemaGenerator;
import com.sun.xml.bind.v2.schemagen.episode.Bindings;
import com.sun.xml.bind.v2.util.CollisionCheckStack;
import com.sun.xml.bind.v2.util.StackRecorder;
import com.sun.xml.txw2.TXW;
import com.sun.xml.txw2.output.XmlSerializer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class XmlSchemaGenerator<T, C, F, M> {
    private static final Logger logger = Util.getClassLogger();
    private final Map<String, Namespace> namespaces = new TreeMap(NAMESPACE_COMPARATOR);
    private ErrorListener errorListener;
    private Navigator<T, C, F, M> navigator;
    private final TypeInfoSet<T, C, F, M> types;
    private final NonElement<T, C> stringType;
    private final NonElement<T, C> anyType;
    private final CollisionCheckStack<ClassInfo<T, C>> collisionChecker = new CollisionCheckStack();
    private static final Comparator<String> NAMESPACE_COMPARATOR = new /* Unavailable Anonymous Inner Class!! */;
    private static final String newline = "\n";

    public XmlSchemaGenerator(Navigator<T, C, F, M> navigator, TypeInfoSet<T, C, F, M> types) {
        this.navigator = navigator;
        this.types = types;
        this.stringType = types.getTypeInfo(navigator.ref(String.class));
        this.anyType = types.getAnyTypeInfo();
        for (ClassInfo ci : types.beans().values()) {
            this.add(ci);
        }
        for (ElementInfo ei1 : types.getElementMappings(null).values()) {
            this.add(ei1);
        }
        for (EnumLeafInfo ei : types.enums().values()) {
            this.add(ei);
        }
        for (ArrayInfo a : types.arrays().values()) {
            this.add(a);
        }
    }

    private Namespace getNamespace(String uri) {
        Namespace n = (Namespace)this.namespaces.get(uri);
        if (n == null) {
            n = new Namespace(this, uri);
            this.namespaces.put(uri, n);
        }
        return n;
    }

    public void add(ClassInfo<T, C> clazz) {
        QName tn;
        assert (clazz != null);
        String nsUri = null;
        if (clazz.getClazz() == this.navigator.asDecl(CompositeStructure.class)) {
            return;
        }
        if (clazz.isElement()) {
            nsUri = clazz.getElementName().getNamespaceURI();
            Namespace ns = this.getNamespace(nsUri);
            Namespace.access$000((Namespace)ns).add(clazz);
            Namespace.access$100((Namespace)ns, (QName)clazz.getTypeName());
            this.add(clazz.getElementName(), false, clazz);
        }
        if ((tn = clazz.getTypeName()) != null) {
            nsUri = tn.getNamespaceURI();
        } else if (nsUri == null) {
            return;
        }
        Namespace n = this.getNamespace(nsUri);
        Namespace.access$000((Namespace)n).add(clazz);
        for (PropertyInfo p : clazz.getProperties()) {
            AttributePropertyInfo ap;
            String aUri;
            Namespace.access$200((Namespace)n, (PropertyInfo)p);
            if (p instanceof AttributePropertyInfo && (aUri = (ap = (AttributePropertyInfo)p).getXmlName().getNamespaceURI()).length() > 0) {
                this.getNamespace(aUri).addGlobalAttribute(ap);
                Namespace.access$100((Namespace)n, (QName)ap.getXmlName());
            }
            if (p instanceof ElementPropertyInfo) {
                ElementPropertyInfo ep = (ElementPropertyInfo)p;
                for (TypeRef tref : ep.getTypes()) {
                    String eUri = tref.getTagName().getNamespaceURI();
                    if (eUri.length() <= 0 || eUri.equals(n.uri)) continue;
                    this.getNamespace(eUri).addGlobalElement(tref);
                    Namespace.access$100((Namespace)n, (QName)tref.getTagName());
                }
            }
            if (!this.generateSwaRefAdapter(p)) continue;
            Namespace.access$302((Namespace)n, (boolean)true);
        }
        ClassInfo bc = clazz.getBaseClass();
        if (bc != null) {
            this.add(bc);
            Namespace.access$100((Namespace)n, (QName)bc.getTypeName());
        }
    }

    public void add(ElementInfo<T, C> elem) {
        assert (elem != null);
        boolean nillable = false;
        QName name = elem.getElementName();
        Namespace n = this.getNamespace(name.getNamespaceURI());
        ElementInfo ei = elem.getScope() != null ? this.types.getElementInfo(elem.getScope().getClazz(), name) : this.types.getElementInfo(null, name);
        XmlElement xmlElem = (XmlElement)ei.getProperty().readAnnotation(XmlElement.class);
        nillable = xmlElem == null ? false : xmlElem.nillable();
        MultiMap multiMap = Namespace.access$400((Namespace)n);
        String string = name.getLocalPart();
        Namespace namespace = n;
        namespace.getClass();
        multiMap.put((Comparable)((Object)string), (Object)new Namespace.ElementWithType(namespace, nillable, elem.getContentType()));
        Namespace.access$200((Namespace)n, (PropertyInfo)elem.getProperty());
    }

    public void add(EnumLeafInfo<T, C> envm) {
        QName typeName;
        assert (envm != null);
        String nsUri = null;
        if (envm.isElement()) {
            nsUri = envm.getElementName().getNamespaceURI();
            Namespace ns = this.getNamespace(nsUri);
            Namespace.access$500((Namespace)ns).add(envm);
            Namespace.access$100((Namespace)ns, (QName)envm.getTypeName());
            this.add(envm.getElementName(), false, envm);
        }
        if ((typeName = envm.getTypeName()) != null) {
            nsUri = typeName.getNamespaceURI();
        } else if (nsUri == null) {
            return;
        }
        Namespace n = this.getNamespace(nsUri);
        Namespace.access$500((Namespace)n).add(envm);
        Namespace.access$100((Namespace)n, (QName)envm.getBaseType().getTypeName());
    }

    public void add(ArrayInfo<T, C> a) {
        assert (a != null);
        String namespaceURI = a.getTypeName().getNamespaceURI();
        Namespace n = this.getNamespace(namespaceURI);
        Namespace.access$600((Namespace)n).add(a);
        Namespace.access$100((Namespace)n, (QName)a.getItemType().getTypeName());
    }

    public void add(QName tagName, boolean isNillable, NonElement<T, C> type) {
        if (type != null && type.getType() == this.navigator.ref(CompositeStructure.class)) {
            return;
        }
        Namespace n = this.getNamespace(tagName.getNamespaceURI());
        MultiMap multiMap = Namespace.access$400((Namespace)n);
        String string = tagName.getLocalPart();
        Namespace namespace = n;
        namespace.getClass();
        multiMap.put((Comparable)((Object)string), (Object)new Namespace.ElementWithType(namespace, isNillable, type));
        if (type != null) {
            Namespace.access$100((Namespace)n, (QName)type.getTypeName());
        }
    }

    public void writeEpisodeFile(XmlSerializer out) {
        Bindings root = (Bindings)TXW.create(Bindings.class, (XmlSerializer)out);
        if (this.namespaces.containsKey("")) {
            root._namespace("http://java.sun.com/xml/ns/jaxb", "jaxb");
        }
        root.version("2.1");
        for (Map.Entry e : this.namespaces.entrySet()) {
            Bindings child;
            String prefix;
            Bindings group = root.bindings();
            String tns = (String)e.getKey();
            if (!tns.equals("")) {
                group._namespace(tns, "tns");
                prefix = "tns:";
            } else {
                prefix = "";
            }
            group.scd("x-schema::" + (tns.equals("") ? "" : "tns"));
            group.schemaBindings().map(false);
            for (ClassInfo ci : Namespace.access$000((Namespace)((Namespace)e.getValue()))) {
                if (ci.getTypeName() == null) continue;
                if (ci.getTypeName().getNamespaceURI().equals(tns)) {
                    child = group.bindings();
                    child.scd('~' + prefix + ci.getTypeName().getLocalPart());
                    child.klass().ref(ci.getName());
                }
                if (!ci.isElement() || !ci.getElementName().getNamespaceURI().equals(tns)) continue;
                child = group.bindings();
                child.scd(prefix + ci.getElementName().getLocalPart());
                child.klass().ref(ci.getName());
            }
            for (EnumLeafInfo en : Namespace.access$500((Namespace)((Namespace)e.getValue()))) {
                if (en.getTypeName() == null) continue;
                child = group.bindings();
                child.scd('~' + prefix + en.getTypeName().getLocalPart());
                child.klass().ref(this.navigator.getClassName(en.getClazz()));
            }
            group.commit(true);
        }
        root.commit();
    }

    public void write(SchemaOutputResolver resolver, ErrorListener errorListener) throws IOException {
        if (resolver == null) {
            throw new IllegalArgumentException();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Wrigin XML Schema for " + this.toString(), (Throwable)new StackRecorder());
        }
        resolver = new FoolProofResolver(resolver);
        this.errorListener = errorListener;
        Map schemaLocations = this.types.getSchemaLocations();
        HashMap<Namespace, Result> out = new HashMap<Namespace, Result>();
        HashMap<Namespace, String> systemIds = new HashMap<Namespace, String>();
        this.namespaces.remove("http://www.w3.org/2001/XMLSchema");
        for (Namespace namespace : this.namespaces.values()) {
            String schemaLocation = (String)schemaLocations.get(namespace.uri);
            if (schemaLocation != null) {
                systemIds.put(namespace, schemaLocation);
                continue;
            }
            Result output = resolver.createOutput(namespace.uri, "schema" + (out.size() + 1) + ".xsd");
            if (output == null) continue;
            out.put(namespace, output);
            systemIds.put(namespace, output.getSystemId());
        }
        for (Map.Entry entry : out.entrySet()) {
            Result result = (Result)entry.getValue();
            Namespace.access$700((Namespace)((Namespace)entry.getKey()), (Result)result, systemIds);
            if (!(result instanceof StreamResult)) continue;
            OutputStream outputStream = ((StreamResult)result).getOutputStream();
            if (outputStream != null) {
                outputStream.close();
                continue;
            }
            Writer writer = ((StreamResult)result).getWriter();
            if (writer == null) continue;
            writer.close();
        }
    }

    private boolean generateSwaRefAdapter(NonElementRef<T, C> typeRef) {
        return this.generateSwaRefAdapter(typeRef.getSource());
    }

    private boolean generateSwaRefAdapter(PropertyInfo<T, C> prop) {
        Adapter adapter = prop.getAdapter();
        if (adapter == null) {
            return false;
        }
        Object o = this.navigator.asDecl(SwaRefAdapter.class);
        if (o == null) {
            return false;
        }
        return o.equals(adapter.adapterType);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Namespace ns : this.namespaces.values()) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(ns.uri).append('=').append(ns);
        }
        return super.toString() + '[' + buf + ']';
    }

    private static String getProcessContentsModeName(WildcardMode wc) {
        switch (2.$SwitchMap$com$sun$xml$bind$v2$model$core$WildcardMode[wc.ordinal()]) {
            case 1: 
            case 2: {
                return wc.name().toLowerCase();
            }
            case 3: {
                return null;
            }
        }
        throw new IllegalStateException();
    }

    protected static String relativize(String uri, String baseUri) {
        try {
            assert (uri != null);
            if (baseUri == null) {
                return uri;
            }
            URI theUri = new URI(com.sun.xml.bind.v2.schemagen.Util.escapeURI((String)uri));
            URI theBaseUri = new URI(com.sun.xml.bind.v2.schemagen.Util.escapeURI((String)baseUri));
            if (theUri.isOpaque() || theBaseUri.isOpaque()) {
                return uri;
            }
            if (!com.sun.xml.bind.v2.schemagen.Util.equalsIgnoreCase((String)theUri.getScheme(), (String)theBaseUri.getScheme()) || !com.sun.xml.bind.v2.schemagen.Util.equal((String)theUri.getAuthority(), (String)theBaseUri.getAuthority())) {
                return uri;
            }
            String uriPath = theUri.getPath();
            String basePath = theBaseUri.getPath();
            if (!basePath.endsWith("/")) {
                basePath = com.sun.xml.bind.v2.schemagen.Util.normalizeUriPath((String)basePath);
            }
            if (uriPath.equals(basePath)) {
                return ".";
            }
            String relPath = XmlSchemaGenerator.calculateRelativePath((String)uriPath, (String)basePath, (boolean)XmlSchemaGenerator.fixNull((String)theUri.getScheme()).equals("file"));
            if (relPath == null) {
                return uri;
            }
            StringBuffer relUri = new StringBuffer();
            relUri.append(relPath);
            if (theUri.getQuery() != null) {
                relUri.append('?').append(theUri.getQuery());
            }
            if (theUri.getFragment() != null) {
                relUri.append('#').append(theUri.getFragment());
            }
            return relUri.toString();
        }
        catch (URISyntaxException e) {
            throw new InternalError("Error escaping one of these uris:\n\t" + uri + "\n\t" + baseUri);
        }
    }

    private static String fixNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private static String calculateRelativePath(String uri, String base, boolean fileUrl) {
        boolean onWindows;
        boolean bl = onWindows = File.pathSeparatorChar == ';';
        if (base == null) {
            return null;
        }
        if (fileUrl && onWindows && XmlSchemaGenerator.startsWithIgnoreCase((String)uri, (String)base) || uri.startsWith(base)) {
            return uri.substring(base.length());
        }
        return "../" + XmlSchemaGenerator.calculateRelativePath((String)uri, (String)com.sun.xml.bind.v2.schemagen.Util.getParentUriPath((String)base), (boolean)fileUrl);
    }

    private static boolean startsWithIgnoreCase(String s, String t) {
        return s.toUpperCase().startsWith(t.toUpperCase());
    }

    static /* synthetic */ NonElement access$800(XmlSchemaGenerator x0) {
        return x0.anyType;
    }

    static /* synthetic */ Map access$900(XmlSchemaGenerator x0) {
        return x0.namespaces;
    }

    static /* synthetic */ Namespace access$1000(XmlSchemaGenerator x0, String x1) {
        return x0.getNamespace(x1);
    }

    static /* synthetic */ TypeInfoSet access$1100(XmlSchemaGenerator x0) {
        return x0.types;
    }

    static /* synthetic */ NonElement access$1200(XmlSchemaGenerator x0) {
        return x0.stringType;
    }

    static /* synthetic */ Logger access$1300() {
        return logger;
    }

    static /* synthetic */ boolean access$1400(XmlSchemaGenerator x0, NonElementRef x1) {
        return x0.generateSwaRefAdapter(x1);
    }

    static /* synthetic */ CollisionCheckStack access$1500(XmlSchemaGenerator x0) {
        return x0.collisionChecker;
    }

    static /* synthetic */ ErrorListener access$1600(XmlSchemaGenerator x0) {
        return x0.errorListener;
    }

    static /* synthetic */ String access$2100(WildcardMode x0) {
        return XmlSchemaGenerator.getProcessContentsModeName((WildcardMode)x0);
    }
}

