/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.property;

import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.v2.model.core.PropertyKind;
import com.sun.xml.bind.v2.model.runtime.RuntimeElementPropertyInfo;
import com.sun.xml.bind.v2.model.runtime.RuntimePropertyInfo;
import com.sun.xml.bind.v2.model.runtime.RuntimeTypeInfo;
import com.sun.xml.bind.v2.model.runtime.RuntimeTypeRef;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.bind.v2.runtime.Name;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.property.PropertyImpl;
import com.sun.xml.bind.v2.runtime.property.TagAndType;
import com.sun.xml.bind.v2.runtime.property.UnmarshallerChain;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.bind.v2.runtime.unmarshaller.ChildLoader;
import com.sun.xml.bind.v2.runtime.unmarshaller.DefaultValueLoaderDecorator;
import com.sun.xml.bind.v2.runtime.unmarshaller.Loader;
import com.sun.xml.bind.v2.runtime.unmarshaller.Receiver;
import com.sun.xml.bind.v2.runtime.unmarshaller.XsiNilLoader;
import com.sun.xml.bind.v2.util.QNameMap;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SingleElementNodeProperty<BeanT, ValueT>
extends PropertyImpl<BeanT> {
    private final Accessor<BeanT, ValueT> acc;
    private final boolean nillable;
    private final QName[] acceptedElements;
    private final Map<Class, TagAndType> typeNames = new HashMap();
    private RuntimeElementPropertyInfo prop;
    private final Name nullTagName;

    public SingleElementNodeProperty(JAXBContextImpl context, RuntimeElementPropertyInfo prop) {
        super(context, (RuntimePropertyInfo)prop);
        this.acc = prop.getAccessor().optimize(context);
        this.prop = prop;
        QName nt = null;
        boolean nil = false;
        this.acceptedElements = new QName[prop.getTypes().size()];
        for (int i = 0; i < this.acceptedElements.length; ++i) {
            this.acceptedElements[i] = ((RuntimeTypeRef)prop.getTypes().get(i)).getTagName();
        }
        for (RuntimeTypeRef e : prop.getTypes()) {
            JaxBeanInfo beanInfo = context.getOrCreate((RuntimeTypeInfo)e.getTarget());
            if (nt == null) {
                nt = e.getTagName();
            }
            this.typeNames.put(beanInfo.jaxbType, new TagAndType(context.nameBuilder.createElementName(e.getTagName()), beanInfo));
            nil |= e.isNillable();
        }
        this.nullTagName = context.nameBuilder.createElementName(nt);
        this.nillable = nil;
    }

    public void wrapUp() {
        super.wrapUp();
        this.prop = null;
    }

    public void reset(BeanT bean) throws AccessorException {
        this.acc.set(bean, null);
    }

    public String getIdValue(BeanT beanT) {
        return null;
    }

    public void serializeBody(BeanT o, XMLSerializer w, Object outerPeer) throws SAXException, AccessorException, IOException, XMLStreamException {
        Object v = this.acc.get(o);
        if (v != null) {
            boolean addNilDecl;
            Class<?> vtype = v.getClass();
            TagAndType tt = (TagAndType)this.typeNames.get(vtype);
            if (tt == null) {
                for (Map.Entry e : this.typeNames.entrySet()) {
                    if (!((Class)e.getKey()).isAssignableFrom(vtype)) continue;
                    tt = (TagAndType)e.getValue();
                    break;
                }
            }
            boolean bl = addNilDecl = o instanceof JAXBElement && ((JAXBElement)o).isNil();
            if (tt == null) {
                w.startElement(((TagAndType)this.typeNames.values().iterator().next()).tagName, null);
                w.childAsXsiType(v, this.fieldName, w.grammar.getBeanInfo(Object.class), addNilDecl && this.nillable);
            } else {
                w.startElement(tt.tagName, null);
                w.childAsXsiType(v, this.fieldName, tt.beanInfo, addNilDecl && this.nillable);
            }
            w.endElement();
        } else if (this.nillable) {
            w.startElement(this.nullTagName, null);
            w.writeXsiNilTrue();
            w.endElement();
        }
    }

    public void buildChildElementUnmarshallers(UnmarshallerChain chain, QNameMap<ChildLoader> handlers) {
        JAXBContextImpl context = chain.context;
        for (RuntimeTypeRef e : this.prop.getTypes()) {
            JaxBeanInfo bi = context.getOrCreate((RuntimeTypeInfo)e.getTarget());
            Loader l = bi.getLoader(context, !Modifier.isFinal(bi.jaxbType.getModifiers()));
            if (e.getDefaultValue() != null) {
                l = new DefaultValueLoaderDecorator(l, e.getDefaultValue());
            }
            if (this.nillable || chain.context.allNillable) {
                l = new XsiNilLoader.Single(l, this.acc);
            }
            handlers.put(e.getTagName(), (Object)new ChildLoader(l, (Receiver)this.acc));
        }
    }

    public PropertyKind getKind() {
        return PropertyKind.ELEMENT;
    }

    public Accessor getElementPropertyAccessor(String nsUri, String localName) {
        for (QName n : this.acceptedElements) {
            if (!n.getNamespaceURI().equals(nsUri) || !n.getLocalPart().equals(localName)) continue;
            return this.acc;
        }
        return null;
    }
}

