/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.output;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import com.sun.xml.bind.v2.runtime.NamespaceContext2;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.output.NamespaceContextImpl;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class NamespaceContextImpl
implements NamespaceContext2 {
    private final XMLSerializer owner;
    private String[] prefixes = new String[4];
    private String[] nsUris = new String[4];
    private int size;
    private Element current;
    private final Element top;
    private NamespacePrefixMapper prefixMapper = defaultNamespacePrefixMapper;
    public boolean collectionMode;
    private static final NamespacePrefixMapper defaultNamespacePrefixMapper = new /* Unavailable Anonymous Inner Class!! */;

    public NamespaceContextImpl(XMLSerializer owner) {
        this.owner = owner;
        this.current = this.top = new Element(this, this, null, null);
        this.put("http://www.w3.org/XML/1998/namespace", "xml");
    }

    public void setPrefixMapper(NamespacePrefixMapper mapper) {
        if (mapper == null) {
            mapper = defaultNamespacePrefixMapper;
        }
        this.prefixMapper = mapper;
    }

    public NamespacePrefixMapper getPrefixMapper() {
        return this.prefixMapper;
    }

    public void reset() {
        this.current = this.top;
        this.size = 1;
        this.collectionMode = false;
    }

    public int declareNsUri(String uri, String preferedPrefix, boolean requirePrefix) {
        preferedPrefix = this.prefixMapper.getPreferredPrefix(uri, preferedPrefix, requirePrefix);
        if (uri.length() == 0) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.nsUris[i].length() == 0) {
                    return i;
                }
                if (this.prefixes[i].length() != 0) continue;
                assert (Element.access$100((Element)this.current) == -1 && Element.access$200((Element)this.current) == -1);
                String oldUri = this.nsUris[i];
                String[] knownURIs = this.owner.nameList.namespaceURIs;
                if (Element.access$300((Element)this.current) <= i) {
                    this.nsUris[i] = "";
                    int subst = this.put(oldUri, null);
                    for (int j = knownURIs.length - 1; j >= 0; --j) {
                        if (!knownURIs[j].equals(oldUri)) continue;
                        this.owner.knownUri2prefixIndexMap[j] = subst;
                        break;
                    }
                    if (Element.access$400((Element)this.current) != null) {
                        this.current.setTagName(subst, Element.access$400((Element)this.current), this.current.getOuterPeer());
                    }
                    return i;
                }
                for (int j = knownURIs.length - 1; j >= 0; --j) {
                    if (!knownURIs[j].equals(oldUri)) continue;
                    Element.access$102((Element)this.current, (int)i);
                    Element.access$202((Element)this.current, (int)j);
                    this.owner.knownUri2prefixIndexMap[j] = this.size;
                    break;
                }
                if (Element.access$400((Element)this.current) != null) {
                    this.current.setTagName(this.size, Element.access$400((Element)this.current), this.current.getOuterPeer());
                }
                this.put(this.nsUris[i], null);
                return this.put("", "");
            }
            return this.put("", "");
        }
        for (int i = this.size - 1; i >= 0; --i) {
            String p = this.prefixes[i];
            if (this.nsUris[i].equals(uri) && (!requirePrefix || p.length() > 0)) {
                return i;
            }
            if (!p.equals(preferedPrefix)) continue;
            preferedPrefix = null;
        }
        if (preferedPrefix == null && requirePrefix) {
            preferedPrefix = this.makeUniquePrefix();
        }
        return this.put(uri, preferedPrefix);
    }

    public int force(@NotNull String uri, @NotNull String prefix) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.prefixes[i].equals(prefix)) continue;
            if (!this.nsUris[i].equals(uri)) break;
            return i;
        }
        return this.put(uri, prefix);
    }

    public int put(@NotNull String uri, @Nullable String prefix) {
        if (this.size == this.nsUris.length) {
            String[] u = new String[this.nsUris.length * 2];
            String[] p = new String[this.prefixes.length * 2];
            System.arraycopy(this.nsUris, 0, u, 0, this.nsUris.length);
            System.arraycopy(this.prefixes, 0, p, 0, this.prefixes.length);
            this.nsUris = u;
            this.prefixes = p;
        }
        if (prefix == null) {
            prefix = this.size == 1 ? "" : this.makeUniquePrefix();
        }
        this.nsUris[this.size] = uri;
        this.prefixes[this.size] = prefix;
        return this.size++;
    }

    private String makeUniquePrefix() {
        String prefix = new StringBuilder(5).append("ns").append(this.size).toString();
        while (this.getNamespaceURI(prefix) != null) {
            prefix = prefix + '_';
        }
        return prefix;
    }

    public Element getCurrent() {
        return this.current;
    }

    public int getPrefixIndex(String uri) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.nsUris[i].equals(uri)) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    public String getPrefix(int prefixIndex) {
        return this.prefixes[prefixIndex];
    }

    public String getNamespaceURI(int prefixIndex) {
        return this.nsUris[prefixIndex];
    }

    public String getNamespaceURI(String prefix) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.prefixes[i].equals(prefix)) continue;
            return this.nsUris[i];
        }
        return null;
    }

    public String getPrefix(String uri) {
        if (this.collectionMode) {
            return this.declareNamespace(uri, null, false);
        }
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.nsUris[i].equals(uri)) continue;
            return this.prefixes[i];
        }
        return null;
    }

    public Iterator<String> getPrefixes(String uri) {
        String prefix = this.getPrefix(uri);
        if (prefix == null) {
            return Collections.emptySet().iterator();
        }
        return Collections.singleton(uri).iterator();
    }

    public String declareNamespace(String namespaceUri, String preferedPrefix, boolean requirePrefix) {
        int idx = this.declareNsUri(namespaceUri, preferedPrefix, requirePrefix);
        return this.getPrefix(idx);
    }

    public int count() {
        return this.size;
    }

    static /* synthetic */ XMLSerializer access$500(NamespaceContextImpl x0) {
        return x0.owner;
    }

    static /* synthetic */ int access$602(NamespaceContextImpl x0, int x1) {
        x0.size = x1;
        return x0.size;
    }

    static /* synthetic */ Element access$702(NamespaceContextImpl x0, Element x1) {
        x0.current = x1;
        return x0.current;
    }

    static /* synthetic */ int access$600(NamespaceContextImpl x0) {
        return x0.size;
    }

    static /* synthetic */ String[] access$800(NamespaceContextImpl x0) {
        return x0.prefixes;
    }

    static /* synthetic */ String[] access$900(NamespaceContextImpl x0) {
        return x0.nsUris;
    }
}

