/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.inject;

import com.sun.jersey.spi.inject.Errors;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Errors {
    private final ArrayList<ErrorMessage> messages = new ArrayList(0);
    private int mark = -1;
    private int stack = 0;
    private boolean fieldReporting = true;
    private static final Logger LOGGER = Logger.getLogger(Errors.class.getName());
    private static ThreadLocal<Errors> errors = new ThreadLocal();

    private void _mark() {
        this.mark = this.messages.size();
    }

    private void _unmark() {
        this.mark = -1;
    }

    private void _reset() {
        if (this.mark >= 0 && this.mark < this.messages.size()) {
            this.messages.subList(this.mark, this.messages.size()).clear();
            this._unmark();
        }
    }

    private void preProcess() {
        ++this.stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postProcess(boolean throwException) {
        --this.stack;
        this.fieldReporting = true;
        if (this.stack == 0) {
            try {
                if (!this.messages.isEmpty()) {
                    Errors.processErrorMessages((boolean)throwException, (List)this.messages);
                }
            }
            finally {
                errors.remove();
            }
        }
    }

    private static void processErrorMessages(boolean throwException, List<ErrorMessage> messages) {
        StringBuilder sb = new StringBuilder();
        boolean isFatal = false;
        for (ErrorMessage em : messages) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("  ");
            if (em.isFatal) {
                sb.append("SEVERE: ");
            } else {
                sb.append("WARNING: ");
            }
            isFatal |= em.isFatal;
            sb.append(em.message);
        }
        String message = sb.toString();
        if (isFatal) {
            LOGGER.severe("The following errors and warnings have been detected with resource and/or provider classes:\n" + message);
            if (throwException) {
                throw new ErrorMessagesException(new ArrayList<ErrorMessage>(messages), null);
            }
        } else {
            LOGGER.warning("The following warnings have been detected with resource and/or provider classes:\n" + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T processWithErrors(Closure<T> c) {
        Object object;
        Errors e = (Errors)errors.get();
        if (e == null) {
            e = new Errors();
            errors.set(e);
        }
        e.preProcess();
        RuntimeException caught = null;
        try {
            object = c.f();
            e.postProcess(caught == null);
        }
        catch (RuntimeException re) {
            try {
                caught = re;
                e.postProcess(caught == null);
            }
            catch (Throwable throwable) {
                e.postProcess(caught == null);
                throw throwable;
            }
        }
        return (T)object;
        throw caught;
    }

    private static Errors getInstance() {
        Errors e = (Errors)errors.get();
        if (e == null) {
            throw new IllegalStateException("There is no error processing in scope");
        }
        if (e.stack == 0) {
            errors.remove();
            throw new IllegalStateException("There is no error processing in scope");
        }
        return e;
    }

    public static void mark() {
        Errors.getInstance()._mark();
    }

    public static void unmark() {
        Errors.getInstance()._unmark();
    }

    public static void reset() {
        Errors.getInstance()._reset();
    }

    public static void error(String message) {
        Errors.error((String)message, (boolean)true);
    }

    public static void error(String message, boolean isFatal) {
        ErrorMessage em = new ErrorMessage(message, isFatal, null);
        Errors.getInstance().messages.add(em);
    }

    public int numberOfErrors() {
        return Errors.getInstance().messages.size();
    }

    public static void innerClass(Class c) {
        Errors.error((String)("The inner class " + c.getName() + " is not a static inner class and cannot be instantiated."));
    }

    public static void nonPublicClass(Class c) {
        Errors.error((String)("The class " + c.getName() + " is a not a public class and cannot be instantiated."));
    }

    public static void nonPublicConstructor(Class c) {
        Errors.error((String)("The class " + c.getName() + " does not have a public constructor and cannot be instantiated."));
    }

    public static void abstractClass(Class c) {
        Errors.error((String)("The class " + c.getName() + " is an abstract class and cannot be instantiated."));
    }

    public static void interfaceClass(Class c) {
        Errors.error((String)("The class " + c.getName() + " is an interface and cannot be instantiated."));
    }

    public static void missingDependency(Constructor ctor, int i) {
        Errors.error((String)("Missing dependency for constructor " + ctor + " at parameter index " + i));
    }

    public static void setReportMissingDependentFieldOrMethod(boolean fieldReporting) {
        Errors.getInstance().fieldReporting = fieldReporting;
    }

    public static boolean getReportMissingDependentFieldOrMethod() {
        return Errors.getInstance().fieldReporting;
    }

    public static void missingDependency(Field f) {
        if (Errors.getReportMissingDependentFieldOrMethod()) {
            Errors.error((String)("Missing dependency for field: " + f.toGenericString()));
        }
    }

    public static void missingDependency(Method m, int i) {
        if (Errors.getReportMissingDependentFieldOrMethod()) {
            Errors.error((String)("Missing dependency for method " + m + " at parameter at index " + i));
        }
    }
}

