/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.container.servlet;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.container.MappableContainerException;
import com.sun.jersey.api.core.ApplicationAdapter;
import com.sun.jersey.api.core.ClasspathResourceConfig;
import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.core.TraceInformation;
import com.sun.jersey.api.core.servlet.WebAppResourceConfig;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.core.header.InBoundHeaders;
import com.sun.jersey.core.header.MediaTypes;
import com.sun.jersey.core.reflection.ReflectionHelper;
import com.sun.jersey.core.util.ReaderWriter;
import com.sun.jersey.server.impl.InitialContextHelper;
import com.sun.jersey.server.impl.ThreadLocalInvoker;
import com.sun.jersey.server.impl.application.DeferredResourceConfig;
import com.sun.jersey.server.impl.cdi.CDIComponentProviderFactoryInitializer;
import com.sun.jersey.server.impl.container.servlet.JSPTemplateProcessor;
import com.sun.jersey.server.impl.ejb.EJBComponentProviderFactoryInitilizer;
import com.sun.jersey.server.impl.managedbeans.ManagedBeanComponentProviderFactoryInitilizer;
import com.sun.jersey.server.impl.monitoring.GlassFishMonitoringInitializer;
import com.sun.jersey.server.probes.UriRuleProbeProvider;
import com.sun.jersey.spi.container.ContainerListener;
import com.sun.jersey.spi.container.ContainerNotifier;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.ReloadListener;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.WebApplicationFactory;
import com.sun.jersey.spi.container.servlet.WebComponent;
import com.sun.jersey.spi.container.servlet.WebConfig;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.SecurityContext;

public class WebComponent
implements ContainerListener {
    public static final String APPLICATION_CONFIG_CLASS = "javax.ws.rs.Application";
    public static final String RESOURCE_CONFIG_CLASS = "com.sun.jersey.config.property.resourceConfigClass";
    public static final String JSP_TEMPLATES_BASE_PATH = "com.sun.jersey.config.property.JSPTemplatesBasePath";
    private static final Logger LOGGER = Logger.getLogger(WebComponent.class.getName());
    private final ThreadLocalInvoker<HttpServletRequest> requestInvoker = new ThreadLocalInvoker();
    private final ThreadLocalInvoker<HttpServletResponse> responseInvoker = new ThreadLocalInvoker();
    private WebConfig config;
    private ResourceConfig resourceConfig;
    private boolean useSetStatusOn404 = false;
    private WebApplication application;

    public WebComponent() {
    }

    public WebComponent(Application app) {
        if (app == null) {
            throw new IllegalArgumentException();
        }
        this.resourceConfig = app instanceof ResourceConfig ? (ResourceConfig)app : new ApplicationAdapter(app);
    }

    public WebConfig getWebConfig() {
        return this.config;
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public void init(WebConfig webConfig) throws ServletException {
        this.config = webConfig;
        if (this.resourceConfig == null) {
            this.resourceConfig = this.createResourceConfig(this.config);
        }
        if (this.config.getConfigType() == WebConfig.ConfigType.FilterConfig && this.resourceConfig.getFeature("com.sun.jersey.config.feature.FilterForwardOn404")) {
            this.useSetStatusOn404 = true;
        }
        this.load();
        Object o = this.resourceConfig.getProperties().get("com.sun.jersey.spi.container.ContainerNotifier");
        if (o instanceof List) {
            List list = (List)o;
            for (Object elem : list) {
                if (!(elem instanceof ContainerNotifier)) continue;
                ContainerNotifier crf = (ContainerNotifier)elem;
                crf.addListener((ContainerListener)this);
            }
        } else if (o instanceof ContainerNotifier) {
            ContainerNotifier crf = (ContainerNotifier)o;
            crf.addListener((ContainerListener)this);
        }
    }

    public void destroy() {
        if (this.application != null) {
            this.application.destroy();
        }
    }

    public int service(URI baseUri, URI requestUri, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebApplication _application = this.application;
        ContainerRequest cRequest = this.createRequest(_application, request, baseUri, requestUri);
        cRequest.setSecurityContext((SecurityContext)new /* Unavailable Anonymous Inner Class!! */);
        this.filterFormParameters(request, cRequest);
        try {
            UriRuleProbeProvider.requestStart((URI)requestUri);
            this.requestInvoker.set((Object)request);
            this.responseInvoker.set((Object)response);
            Writer w = new Writer(this.useSetStatusOn404, response);
            _application.handleRequest(cRequest, (ContainerResponseWriter)w);
            int n = w.cResponse.getStatus();
            return n;
        }
        catch (MappableContainerException ex) {
            this.traceOnException(cRequest, response);
            throw new ServletException(ex.getCause());
        }
        catch (ContainerException ex) {
            this.traceOnException(cRequest, response);
            throw new ServletException((Throwable)ex);
        }
        catch (RuntimeException ex) {
            this.traceOnException(cRequest, response);
            throw ex;
        }
        finally {
            UriRuleProbeProvider.requestEnd();
            this.requestInvoker.set(null);
            this.responseInvoker.set(null);
        }
    }

    protected ContainerRequest createRequest(WebApplication app, HttpServletRequest request, URI baseUri, URI requestUri) throws IOException {
        return new ContainerRequest(app, request.getMethod(), baseUri, requestUri, this.getHeaders(request), (InputStream)request.getInputStream());
    }

    private void traceOnException(ContainerRequest cRequest, HttpServletResponse response) {
        if (cRequest.isTracingEnabled()) {
            TraceInformation ti = (TraceInformation)cRequest.getProperties().get(TraceInformation.class.getName());
            ti.addTraceHeaders((TraceInformation.TraceHeaderListener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected WebApplication create() {
        return WebApplicationFactory.createWebApplication();
    }

    protected void configure(WebConfig wc, ResourceConfig rc, WebApplication wa) {
        this.configureJndiResources(rc);
        rc.getSingletons().add(new ContextInjectableProvider(HttpServletRequest.class, (Object)((HttpServletRequest)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{HttpServletRequest.class}, (InvocationHandler)this.requestInvoker))));
        rc.getSingletons().add(new ContextInjectableProvider(HttpServletResponse.class, (Object)((HttpServletResponse)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{HttpServletResponse.class}, (InvocationHandler)this.responseInvoker))));
        3 requestThreadLocal = new /* Unavailable Anonymous Inner Class!! */;
        rc.getSingletons().add(new ContextInjectableProvider(requestThreadLocal.getType(), requestThreadLocal.getEntity()));
        4 responseThreadLocal = new /* Unavailable Anonymous Inner Class!! */;
        rc.getSingletons().add(new ContextInjectableProvider(responseThreadLocal.getType(), responseThreadLocal.getEntity()));
        rc.getSingletons().add(new ContextInjectableProvider(ServletContext.class, (Object)wc.getServletContext()));
        rc.getSingletons().add(new ContextInjectableProvider(WebConfig.class, (Object)wc));
        rc.getClasses().add(JSPTemplateProcessor.class);
        EJBComponentProviderFactoryInitilizer.initialize((ResourceConfig)rc);
        CDIComponentProviderFactoryInitializer.initialize((WebConfig)wc, (ResourceConfig)rc, (WebApplication)wa);
        ManagedBeanComponentProviderFactoryInitilizer.initialize((ResourceConfig)rc);
        GlassFishMonitoringInitializer.initialize();
    }

    protected void initiate(ResourceConfig rc, WebApplication wa) {
        wa.initiate(rc);
    }

    public void load() {
        WebApplication _application = this.create();
        this.configure(this.config, this.resourceConfig, _application);
        this.initiate(this.resourceConfig, _application);
        this.application = _application;
    }

    protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, WebConfig wc) throws ServletException {
        return this.getWebAppResourceConfig(props, wc);
    }

    public void onReload() {
        WebApplication oldApplication = this.application;
        WebApplication newApplication = this.create();
        this.initiate(this.resourceConfig, newApplication);
        this.application = newApplication;
        if (this.resourceConfig instanceof ReloadListener) {
            ((ReloadListener)this.resourceConfig).onReload();
        }
        oldApplication.destroy();
    }

    ResourceConfig getWebAppResourceConfig(Map<String, Object> props, WebConfig webConfig) throws ServletException {
        return new WebAppResourceConfig(props, webConfig.getServletContext());
    }

    private ResourceConfig createResourceConfig(WebConfig webConfig) throws ServletException {
        Map props = this.getInitParams(webConfig);
        ResourceConfig rc = this.createResourceConfig(webConfig, props);
        rc.setPropertiesAndFeatures(props);
        return rc;
    }

    private ResourceConfig createResourceConfig(WebConfig webConfig, Map<String, Object> props) throws ServletException {
        String resourceConfigClassName = webConfig.getInitParameter(RESOURCE_CONFIG_CLASS);
        if (resourceConfigClassName == null) {
            resourceConfigClassName = webConfig.getInitParameter(APPLICATION_CONFIG_CLASS);
        }
        if (resourceConfigClassName == null) {
            String packages = webConfig.getInitParameter("com.sun.jersey.config.property.packages");
            if (packages != null) {
                props.put("com.sun.jersey.config.property.packages", packages);
                return new PackagesResourceConfig(props);
            }
            ResourceConfig defaultConfig = webConfig.getDefaultResourceConfig(props);
            if (defaultConfig != null) {
                return defaultConfig;
            }
            return this.getDefaultResourceConfig(props, webConfig);
        }
        try {
            Class resourceConfigClass = ReflectionHelper.classForNameWithException((String)resourceConfigClassName);
            if (resourceConfigClass == ClasspathResourceConfig.class) {
                String[] paths = this.getPaths(webConfig.getInitParameter("com.sun.jersey.config.property.classpath"));
                props.put("com.sun.jersey.config.property.classpath", paths);
                return new ClasspathResourceConfig(props);
            }
            if (ResourceConfig.class.isAssignableFrom(resourceConfigClass)) {
                try {
                    Constructor constructor = resourceConfigClass.getConstructor(Map.class);
                    if (ClasspathResourceConfig.class.isAssignableFrom(resourceConfigClass)) {
                        String[] paths = this.getPaths(webConfig.getInitParameter("com.sun.jersey.config.property.classpath"));
                        props.put("com.sun.jersey.config.property.classpath", paths);
                    }
                    return (ResourceConfig)constructor.newInstance(props);
                }
                catch (NoSuchMethodException ex) {
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
                return new DeferredResourceConfig(resourceConfigClass.asSubclass(ResourceConfig.class));
            }
            if (Application.class.isAssignableFrom(resourceConfigClass)) {
                return new DeferredResourceConfig(resourceConfigClass.asSubclass(Application.class));
            }
            String message = "Resource configuration class, " + resourceConfigClassName + ", is not a super class of " + Application.class;
            throw new ServletException(message);
        }
        catch (ClassNotFoundException e) {
            String message = "Resource configuration class, " + resourceConfigClassName + ", could not be loaded";
            throw new ServletException(message, (Throwable)e);
        }
    }

    private Map<String, Object> getInitParams(WebConfig webConfig) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Enumeration names = webConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            props.put(name, webConfig.getInitParameter(name));
        }
        return props;
    }

    private String[] getPaths(String classpath) throws ServletException {
        ServletContext context = this.config.getServletContext();
        if (classpath == null) {
            String[] paths = new String[]{context.getRealPath("/WEB-INF/lib"), context.getRealPath("/WEB-INF/classes")};
            if (paths[0] == null && paths[1] == null) {
                String message = "The default deployment configuration that scans for classes in /WEB-INF/lib and /WEB-INF/classes is not supported for the application server.Try using the package scanning configuration, see the JavaDoc for " + PackagesResourceConfig.class.getName() + " and the property " + "com.sun.jersey.config.property.packages" + ".";
                throw new ServletException(message);
            }
            return paths;
        }
        String[] virtualPaths = classpath.split(";");
        ArrayList<String> resourcePaths = new ArrayList<String>();
        for (String virtualPath : virtualPaths) {
            String path;
            if ((virtualPath = virtualPath.trim()).length() == 0 || (path = context.getRealPath(virtualPath)) == null) continue;
            resourcePaths.add(path);
        }
        if (resourcePaths.isEmpty()) {
            String message = "None of the declared classpath locations, " + classpath + ", could be resolved. " + "This could be because the default deployment configuration that scans for " + "classes in classpath locations is not supported. " + "Try using the package scanning configuration, see the JavaDoc for " + PackagesResourceConfig.class.getName() + " and the property " + "com.sun.jersey.config.property.packages" + ".";
            throw new ServletException(message);
        }
        return resourcePaths.toArray(new String[resourcePaths.size()]);
    }

    private void configureJndiResources(ResourceConfig rc) {
        InitialContext x = InitialContextHelper.getInitialContext();
        if (x != null) {
            Iterator i = rc.getClasses().iterator();
            while (i.hasNext()) {
                Class c = (Class)i.next();
                if (!c.isInterface()) continue;
                try {
                    Object o = x.lookup(c.getName());
                    if (o == null) continue;
                    i.remove();
                    rc.getSingletons().add(o);
                    LOGGER.log(Level.INFO, "An instance of the class " + c.getName() + " is found by JNDI look up using the class name as the JNDI name. " + "The instance will be registered as a singleton.");
                }
                catch (NamingException ex) {
                    LOGGER.log(Level.CONFIG, "JNDI lookup failed for Jersey application resource " + c.getName(), ex);
                }
            }
        }
    }

    private void filterFormParameters(HttpServletRequest hsr, ContainerRequest cr) throws IOException {
        if (cr.getMethod().equals("POST") && MediaTypes.typeEquals((MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE, (MediaType)cr.getMediaType()) && !this.isEntityPresent(cr)) {
            Form f = new Form();
            Enumeration e = hsr.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String[] values = hsr.getParameterValues(name);
                f.put((Object)name, Arrays.asList(values));
            }
            if (!f.isEmpty()) {
                cr.getProperties().put("com.sun.jersey.api.representation.form", f);
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "A servlet POST request, to the URI " + cr.getRequestUri() + ", " + "contains form parameters in " + "the request body but the request body has been consumed " + "by the servlet or a servlet filter accessing the request " + "parameters. Only resource methods using @FormParam " + "will work as expected. Resource methods consuming the " + "request body by other means will not work as expected.");
                }
            }
        }
    }

    private boolean isEntityPresent(ContainerRequest cr) throws IOException {
        InputStream in = cr.getEntityInputStream();
        if (!in.markSupported()) {
            in = new BufferedInputStream(in, ReaderWriter.BUFFER_SIZE);
            cr.setEntityInputStream(in);
        }
        in.mark(1);
        if (in.read() == -1) {
            return false;
        }
        in.reset();
        return true;
    }

    private InBoundHeaders getHeaders(HttpServletRequest request) {
        InBoundHeaders rh = new InBoundHeaders();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            LinkedList valueList = new LinkedList();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                valueList.add(values.nextElement());
            }
            rh.put((Object)name, valueList);
        }
        return rh;
    }
}

