/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.uri.rules;

import com.sun.jersey.api.Responses;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.api.core.HttpResponseContext;
import com.sun.jersey.core.header.MediaTypes;
import com.sun.jersey.core.reflection.ReflectionHelper;
import com.sun.jersey.server.impl.model.method.ResourceMethod;
import com.sun.jersey.server.impl.template.ViewResourceMethod;
import com.sun.jersey.server.impl.uri.rules.HttpMethodRule;
import com.sun.jersey.server.probes.UriRuleProbeProvider;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.monitoring.DispatchingListener;
import com.sun.jersey.spi.uri.rules.UriRule;
import com.sun.jersey.spi.uri.rules.UriRuleContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;

/*
 * Exception performing whole class analysis ignored.
 */
public final class HttpMethodRule
implements UriRule {
    public static final String CONTENT_TYPE_PROPERTY = "com.sun.jersey.server.impl.uri.rules.HttpMethodRule.Content-Type";
    private final Map<String, ResourceMethodListPair> map = new HashMap();
    private final String allow;
    private final boolean isSubResource;
    private final DispatchingListener dispatchingListener;

    public HttpMethodRule(Map<String, List<ResourceMethod>> methods, DispatchingListener dispatchingListener) {
        this(methods, false, dispatchingListener);
    }

    public HttpMethodRule(Map<String, List<ResourceMethod>> methods, boolean isSubResource, DispatchingListener dispatchingListener) {
        for (Map.Entry<String, List<ResourceMethod>> e : methods.entrySet()) {
            this.map.put(e.getKey(), new ResourceMethodListPair(e.getValue()));
        }
        this.isSubResource = isSubResource;
        this.allow = this.getAllow(methods);
        this.dispatchingListener = dispatchingListener;
    }

    private String getAllow(Map<String, List<ResourceMethod>> methods) {
        StringBuilder s = new StringBuilder();
        for (String method : methods.keySet()) {
            if (s.length() > 0) {
                s.append(",");
            }
            s.append(method);
        }
        return s.toString();
    }

    public boolean accept(CharSequence path, Object resource, UriRuleContext context) {
        UriRuleProbeProvider.ruleAccept((String)HttpMethodRule.class.getSimpleName(), (CharSequence)path, (Object)resource);
        if (path.length() > 0) {
            return false;
        }
        HttpRequestContext request = context.getRequest();
        if (request.getMethod().equals("com.sun.jersey.MATCH_RESOURCE")) {
            return true;
        }
        if (context.isTracingEnabled()) {
            String currentPath = (String)context.getUriInfo().getMatchedURIs().get(0);
            if (this.isSubResource) {
                String prevPath = (String)context.getUriInfo().getMatchedURIs().get(1);
                context.trace(String.format("accept sub-resource methods: \"%s\" : \"%s\", %s -> %s", prevPath, currentPath.substring(prevPath.length()), context.getRequest().getMethod(), ReflectionHelper.objectToString((Object)resource)));
            } else {
                context.trace(String.format("accept resource methods: \"%s\", %s -> %s", currentPath, context.getRequest().getMethod(), ReflectionHelper.objectToString((Object)resource)));
            }
        }
        HttpResponseContext response = context.getResponse();
        ResourceMethodListPair methods = (ResourceMethodListPair)this.map.get(request.getMethod());
        if (methods == null) {
            response.setResponse(Responses.methodNotAllowed().header("Allow", (Object)this.allow).build());
            return false;
        }
        List accept = HttpMethodRule.getSpecificAcceptableMediaTypes((List)request.getAcceptableMediaTypes(), (List)methods.priorityMediaTypes);
        Matcher m = new Matcher(null);
        MatchStatus s = Matcher.access$100((Matcher)m, (ResourceMethodListPair)methods, (MediaType)request.getMediaType(), (List)accept);
        if (s == MatchStatus.MATCH) {
            ResourceMethod method = Matcher.access$200((Matcher)m);
            if (method instanceof ViewResourceMethod) {
                if (!Matcher.access$300((Matcher)m).isWildcardType() && !Matcher.access$300((Matcher)m).isWildcardSubtype()) {
                    response.getHttpHeaders().putSingle((Object)"Content-Type", (Object)Matcher.access$300((Matcher)m));
                }
                return false;
            }
            if (this.isSubResource) {
                context.pushResource(resource);
                context.pushMatch(method.getTemplate(), method.getTemplate().getTemplateVariables());
            }
            if (context.isTracingEnabled()) {
                if (this.isSubResource) {
                    context.trace(String.format("matched sub-resource method: @Path(\"%s\") %s", method.getTemplate(), method.getDispatcher()));
                } else {
                    context.trace(String.format("matched resource method: %s", method.getDispatcher()));
                }
            }
            context.pushContainerResponseFilters(method.getResponseFilters());
            if (!method.getRequestFilters().isEmpty()) {
                ContainerRequest containerRequest = context.getContainerRequest();
                for (ContainerRequestFilter f : method.getRequestFilters()) {
                    containerRequest = f.filter(containerRequest);
                    context.setContainerRequest(containerRequest);
                }
            }
            context.pushMethod(method.getAbstractResourceMethod());
            try {
                this.dispatchingListener.onResourceMethod(Thread.currentThread().getId(), method.getAbstractResourceMethod());
                method.getDispatcher().dispatch(resource, (HttpContext)context);
            }
            catch (RuntimeException e) {
                if (Matcher.access$200((Matcher)m).isProducesDeclared() && !Matcher.access$300((Matcher)m).isWildcardType() && !Matcher.access$300((Matcher)m).isWildcardSubtype()) {
                    context.getProperties().put("com.sun.jersey.server.impl.uri.rules.HttpMethodRule.Content-Type", Matcher.access$300((Matcher)m));
                }
                throw e;
            }
            Object contentType = response.getHttpHeaders().getFirst((Object)"Content-Type");
            if (contentType == null && Matcher.access$200((Matcher)m).isProducesDeclared() && !Matcher.access$300((Matcher)m).isWildcardType() && !Matcher.access$300((Matcher)m).isWildcardSubtype()) {
                response.getHttpHeaders().putSingle((Object)"Content-Type", (Object)Matcher.access$300((Matcher)m));
            }
            return true;
        }
        if (s == MatchStatus.NO_MATCH_FOR_CONSUME) {
            response.setResponse(Responses.unsupportedMediaType().build());
            return false;
        }
        if (s == MatchStatus.NO_MATCH_FOR_PRODUCE) {
            response.setResponse(Responses.notAcceptable().build());
            return false;
        }
        return true;
    }

    public static List<MediaType> getSpecificAcceptableMediaTypes(List<MediaType> acceptableMediaType, List<? extends MediaType> priorityMediaTypes) {
        if (priorityMediaTypes != null) {
            for (MediaType mediaType : priorityMediaTypes) {
                for (MediaType amt : acceptableMediaType) {
                    if (!amt.isCompatible(mediaType)) continue;
                    return Collections.singletonList(MediaTypes.mostSpecific((MediaType)amt, (MediaType)mediaType));
                }
            }
        }
        return acceptableMediaType;
    }
}

