/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.cdi;

import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.server.impl.cdi.CDIExtension;
import com.sun.jersey.server.impl.cdi.Utils;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.WebApplicationListener;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.ManagedBean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;

public class CDIComponentProviderFactory
implements IoCComponentProviderFactory,
WebApplicationListener {
    private static final Logger LOGGER = Logger.getLogger(CDIComponentProviderFactory.class.getName());
    private final BeanManager beanManager;
    private final CDIExtension extension;
    private final Map<Class<? extends Annotation>, ComponentScope> scopeMap = this.createScopeMap();

    public CDIComponentProviderFactory(Object bm, ResourceConfig rc, WebApplication wa) {
        this.beanManager = (BeanManager)bm;
        this.extension = CDIExtension.lookupExtensionInBeanManager ? (CDIExtension)Utils.getInstance((BeanManager)this.beanManager, CDIExtension.class) : CDIExtension.getInitializedExtension();
        this.extension.setWebApplication(wa);
        this.extension.setResourceConfig(rc);
    }

    public void onWebApplicationReady() {
        this.extension.lateInitialize();
    }

    public IoCComponentProvider getComponentProvider(Class<?> c) {
        return this.getComponentProvider(null, c);
    }

    public IoCComponentProvider getComponentProvider(ComponentContext cc, Class<?> c) {
        Bean b = Utils.getBean((BeanManager)this.beanManager, c);
        if (b == null) {
            return null;
        }
        Class s = b.getScope();
        ComponentScope cs = this.getComponentScope(b);
        if (s == Dependent.class) {
            if (!c.isAnnotationPresent(ManagedBean.class)) {
                return null;
            }
            LOGGER.fine("Binding the CDI managed bean " + c.getName() + " in scope " + s.getName() + " to CDIComponentProviderFactory");
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        LOGGER.fine("Binding the CDI managed bean " + c.getName() + " in scope " + s.getName() + " to CDIComponentProviderFactory in scope " + cs);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private ComponentScope getComponentScope(Bean<?> b) {
        ComponentScope cs = (ComponentScope)this.scopeMap.get(b.getScope());
        return cs != null ? cs : ComponentScope.Undefined;
    }

    private Map<Class<? extends Annotation>, ComponentScope> createScopeMap() {
        HashMap<Class<Dependent>, ComponentScope> m = new HashMap<Class<Dependent>, ComponentScope>();
        m.put(ApplicationScoped.class, ComponentScope.Singleton);
        m.put(RequestScoped.class, ComponentScope.PerRequest);
        m.put(Dependent.class, ComponentScope.PerRequest);
        return Collections.unmodifiableMap(m);
    }

    static /* synthetic */ BeanManager access$000(CDIComponentProviderFactory x0) {
        return x0.beanManager;
    }
}

