/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.osgi;

import com.sun.jersey.core.osgi.Activator;
import com.sun.jersey.core.osgi.OsgiLocator;
import com.sun.jersey.core.spi.scanning.PackageNamesScanner;
import com.sun.jersey.core.spi.scanning.uri.UriSchemeScanner;
import com.sun.jersey.spi.service.ServiceFinder;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    private static final Logger LOGGER = Logger.getLogger(Activator.class.getName());
    private BundleContext bundleContext;
    private ConcurrentMap<Long, Map<String, Callable<List<Class>>>> factories = new ConcurrentHashMap();

    public synchronized void start(BundleContext bundleContext) throws Exception {
        LOGGER.log(Level.FINE, "Activating Jersey core bundle...");
        this.bundleContext = bundleContext;
        this.setOSGiPackageScannerResourceProvider();
        this.registerBundleSchemeScanner();
        this.setOSGiServiceFinderIteratorProvider();
        bundleContext.addBundleListener((BundleListener)this);
        this.registerExistingBundles();
        LOGGER.log(Level.FINE, "Jersey core bundle activated");
    }

    private void registerExistingBundles() {
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle.getState() != 4 && bundle.getState() != 8 && bundle.getState() != 32 && bundle.getState() != 16) continue;
            this.register(bundle);
        }
    }

    private void setOSGiPackageScannerResourceProvider() {
        PackageNamesScanner.setResourcesProvider((PackageNamesScanner.ResourcesProvider)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setOSGiServiceFinderIteratorProvider() {
        ServiceFinder.setIteratorProvider((ServiceFinder.ServiceIteratorProvider)new OsgiServiceFinder(null));
    }

    private void registerBundleSchemeScanner() {
        OsgiLocator.register((String)UriSchemeScanner.class.getName(), (Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public synchronized void stop(BundleContext bundleContext) throws Exception {
        LOGGER.log(Level.FINE, "Deactivating Jersey core bundle...");
        bundleContext.removeBundleListener((BundleListener)this);
        while (!this.factories.isEmpty()) {
            this.unregister(((Long)this.factories.keySet().iterator().next()).longValue());
        }
        LOGGER.log(Level.FINE, "Jersey core bundle deactivated");
        this.bundleContext = null;
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 32) {
            this.register(event.getBundle());
        } else if (event.getType() == 64 || event.getType() == 16) {
            this.unregister(event.getBundle().getBundleId());
        }
    }

    protected void register(Bundle bundle) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "checking bundle " + bundle.getBundleId());
        }
        HashMap<String, BundleFactoryLoader> map = (HashMap<String, BundleFactoryLoader>)this.factories.get(bundle.getBundleId());
        Enumeration e = bundle.findEntries("META-INF/services/", "*", false);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL u = (URL)e.nextElement();
                String url = u.toString();
                if (url.endsWith("/")) continue;
                String factoryId = url.substring(url.lastIndexOf("/") + 1);
                if (map == null) {
                    map = new HashMap<String, BundleFactoryLoader>();
                    this.factories.put(bundle.getBundleId(), map);
                }
                map.put(factoryId, new BundleFactoryLoader(this, factoryId, u, bundle));
            }
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "registering service for key " + (String)entry.getKey() + "with value " + entry.getValue());
                }
                OsgiLocator.register((String)((String)entry.getKey()), (Callable)((Callable)entry.getValue()));
            }
        }
    }

    protected void unregister(long bundleId) {
        Map map = (Map)this.factories.remove(bundleId);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "unregistering service for key " + (String)entry.getKey() + "with value " + entry.getValue());
                }
                OsgiLocator.unregister((String)((String)entry.getKey()), (Callable)((Callable)entry.getValue()));
            }
        }
    }

    static /* synthetic */ BundleContext access$000(Activator x0) {
        return x0.bundleContext;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }
}

