/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.uri;

import com.sun.jersey.api.uri.UriPattern;
import com.sun.jersey.api.uri.UriTemplateParser;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class UriPattern {
    public static final UriPattern EMPTY = new UriPattern();
    private final String regex;
    private final Pattern regexPattern;
    private final int[] groupIndexes;
    private static final EmptyStringMatchResult EMPTY_STRING_MATCH_RESULT = new EmptyStringMatchResult(null);

    protected UriPattern() {
        this.regex = "";
        this.regexPattern = null;
        this.groupIndexes = null;
    }

    public UriPattern(String regex) {
        this(regex, UriTemplateParser.EMPTY_INT_ARRAY);
    }

    public UriPattern(String regex, int[] groupIndexes) {
        this(UriPattern.compile((String)regex), groupIndexes);
    }

    private static Pattern compile(String regex) {
        return regex == null || regex.length() == 0 ? null : Pattern.compile(regex);
    }

    public UriPattern(Pattern regexPattern) {
        this(regexPattern, UriTemplateParser.EMPTY_INT_ARRAY);
    }

    public UriPattern(Pattern regexPattern, int[] groupIndexes) {
        if (regexPattern == null) {
            throw new IllegalArgumentException();
        }
        this.regex = regexPattern.toString();
        this.regexPattern = regexPattern;
        this.groupIndexes = groupIndexes;
    }

    public final String getRegex() {
        return this.regex;
    }

    public final int[] getGroupIndexes() {
        return this.groupIndexes;
    }

    public final MatchResult match(CharSequence uri) {
        if (uri == null || uri.length() == 0) {
            return this.regexPattern == null ? EMPTY_STRING_MATCH_RESULT : null;
        }
        if (this.regexPattern == null) {
            return null;
        }
        Matcher m = this.regexPattern.matcher(uri);
        if (!m.matches()) {
            return null;
        }
        return this.groupIndexes.length > 0 ? new GroupIndexMatchResult(this, (MatchResult)m) : m;
    }

    public final boolean match(CharSequence uri, List<String> groupValues) {
        if (groupValues == null) {
            throw new IllegalArgumentException();
        }
        if (uri == null || uri.length() == 0) {
            return this.regexPattern == null;
        }
        if (this.regexPattern == null) {
            return false;
        }
        Matcher m = this.regexPattern.matcher(uri);
        if (!m.matches()) {
            return false;
        }
        groupValues.clear();
        if (this.groupIndexes.length > 0) {
            for (int i = 0; i < this.groupIndexes.length - 1; ++i) {
                groupValues.add(m.group(this.groupIndexes[i]));
            }
        } else {
            for (int i = 1; i <= m.groupCount(); ++i) {
                groupValues.add(m.group(i));
            }
        }
        return true;
    }

    public final boolean match(CharSequence uri, List<String> groupNames, Map<String, String> groupValues) {
        if (groupValues == null) {
            throw new IllegalArgumentException();
        }
        if (uri == null || uri.length() == 0) {
            return this.regexPattern == null;
        }
        if (this.regexPattern == null) {
            return false;
        }
        Matcher m = this.regexPattern.matcher(uri);
        if (!m.matches()) {
            return false;
        }
        groupValues.clear();
        for (int i = 0; i < groupNames.size(); ++i) {
            String name = groupNames.get(i);
            String currentValue = m.group(this.groupIndexes.length > 0 ? this.groupIndexes[i] : i + 1);
            String previousValue = groupValues.get(name);
            if (previousValue != null && !previousValue.equals(currentValue)) {
                return false;
            }
            groupValues.put(name, currentValue);
        }
        return true;
    }

    public final int hashCode() {
        return this.regex.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UriPattern that = (UriPattern)obj;
        return this.regex == that.regex || this.regex != null && this.regex.equals(that.regex);
    }

    public final String toString() {
        return this.regex;
    }

    static /* synthetic */ int[] access$100(UriPattern x0) {
        return x0.groupIndexes;
    }
}

