/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client;

import com.sun.jersey.api.client.AsyncUniformInterface;
import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.RequestBuilder;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.async.AsyncClientHandler;
import com.sun.jersey.api.client.async.FutureListener;
import com.sun.jersey.api.client.async.ITypeListener;
import com.sun.jersey.api.client.filter.Filterable;
import com.sun.jersey.client.impl.ClientRequestImpl;
import com.sun.jersey.client.impl.CopyOnWriteHashMap;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;

public class AsyncWebResource
extends Filterable
implements AsyncClientHandler,
RequestBuilder<Builder>,
AsyncUniformInterface {
    private static final Logger LOGGER = Logger.getLogger(AsyncWebResource.class.getName());
    private final ExecutorService executorService;
    private final URI u;
    private CopyOnWriteHashMap<String, Object> properties;

    protected AsyncWebResource(Client c, CopyOnWriteHashMap<String, Object> properties, URI u) {
        super((ClientHandler)c);
        this.executorService = c.getExecutorService();
        this.u = u;
        this.properties = properties.clone();
    }

    protected AsyncWebResource(AsyncWebResource that, UriBuilder ub) {
        super((Filterable)that);
        this.executorService = that.executorService;
        this.u = ub.build(new Object[0]);
    }

    public URI getURI() {
        return this.u;
    }

    @Deprecated
    public UriBuilder getBuilder() {
        return UriBuilder.fromUri((URI)this.u);
    }

    public UriBuilder getUriBuilder() {
        return UriBuilder.fromUri((URI)this.u);
    }

    public Builder getRequestBuilder() {
        return new Builder(this, null);
    }

    public String toString() {
        return this.u.toString();
    }

    public int hashCode() {
        return this.u.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AsyncWebResource) {
            AsyncWebResource that = (AsyncWebResource)obj;
            return that.u.equals(this.u);
        }
        return false;
    }

    public Future<ClientResponse> head() {
        return this.handle(ClientResponse.class, (ClientRequest)new ClientRequestImpl(this.getURI(), "HEAD"));
    }

    public Future<ClientResponse> head(ITypeListener<ClientResponse> l) {
        return this.handle(l, (ClientRequest)new ClientRequestImpl(this.getURI(), "HEAD"));
    }

    public <T> Future<T> options(Class<T> c) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "OPTIONS"));
    }

    public <T> Future<T> options(GenericType<T> gt) {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "OPTIONS"));
    }

    public <T> Future<T> options(ITypeListener<T> l) {
        return this.handle(l, (ClientRequest)new ClientRequestImpl(this.getURI(), "OPTIONS"));
    }

    public <T> Future<T> get(Class<T> c) throws UniformInterfaceException {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "GET"));
    }

    public <T> Future<T> get(GenericType<T> gt) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "GET"));
    }

    public <T> Future<T> get(ITypeListener<T> l) {
        return this.handle(l, (ClientRequest)new ClientRequestImpl(this.getURI(), "GET"));
    }

    public Future<?> put() throws UniformInterfaceException {
        return this.voidHandle((ClientRequest)new ClientRequestImpl(this.getURI(), "PUT", null));
    }

    public Future<?> put(Object requestEntity) throws UniformInterfaceException {
        return this.voidHandle((ClientRequest)new ClientRequestImpl(this.getURI(), "PUT", requestEntity));
    }

    public <T> Future<T> put(Class<T> c) throws UniformInterfaceException {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT"));
    }

    public <T> Future<T> put(GenericType<T> gt) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT"));
    }

    public <T> Future<T> put(ITypeListener<T> l) {
        return this.handle(l, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT"));
    }

    public <T> Future<T> put(Class<T> c, Object requestEntity) throws UniformInterfaceException {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT", requestEntity));
    }

    public <T> Future<T> put(GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT", requestEntity));
    }

    public <T> Future<T> put(ITypeListener<T> l, Object requestEntity) {
        return this.handle(l, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT", requestEntity));
    }

    public Future<?> post() throws UniformInterfaceException {
        return this.voidHandle((ClientRequest)new ClientRequestImpl(this.getURI(), "POST"));
    }

    public Future<?> post(Object requestEntity) throws UniformInterfaceException {
        return this.voidHandle((ClientRequest)new ClientRequestImpl(this.getURI(), "POST", requestEntity));
    }

    public <T> Future<T> post(Class<T> c) throws UniformInterfaceException {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST"));
    }

    public <T> Future<T> post(GenericType<T> gt) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST"));
    }

    public <T> Future<T> post(ITypeListener<T> l) {
        return this.handle(l, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST"));
    }

    public <T> Future<T> post(Class<T> c, Object requestEntity) throws UniformInterfaceException {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST", requestEntity));
    }

    public <T> Future<T> post(GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST", requestEntity));
    }

    public <T> Future<T> post(ITypeListener<T> l, Object requestEntity) {
        return this.handle(l, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST", requestEntity));
    }

    public Future<?> delete() throws UniformInterfaceException {
        return this.voidHandle((ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE"));
    }

    public Future<?> delete(Object requestEntity) throws UniformInterfaceException {
        return this.voidHandle((ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE", requestEntity));
    }

    public <T> Future<T> delete(Class<T> c) throws UniformInterfaceException {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE"));
    }

    public <T> Future<T> delete(GenericType<T> gt) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE"));
    }

    public <T> Future<T> delete(ITypeListener<T> l) {
        return this.handle(l, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE"));
    }

    public <T> Future<T> delete(Class<T> c, Object requestEntity) throws UniformInterfaceException {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE", requestEntity));
    }

    public <T> Future<T> delete(GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE", requestEntity));
    }

    public <T> Future<T> delete(ITypeListener<T> l, Object requestEntity) {
        return this.handle(l, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE", requestEntity));
    }

    public Future<?> method(String method) throws UniformInterfaceException {
        return this.voidHandle((ClientRequest)new ClientRequestImpl(this.getURI(), method));
    }

    public Future<?> method(String method, Object requestEntity) throws UniformInterfaceException {
        return this.voidHandle((ClientRequest)new ClientRequestImpl(this.getURI(), method, requestEntity));
    }

    public <T> Future<T> method(String method, Class<T> c) throws UniformInterfaceException {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), method));
    }

    public <T> Future<T> method(String method, GenericType<T> gt) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), method));
    }

    public <T> Future<T> method(String method, ITypeListener<T> l) {
        return this.handle(l, (ClientRequest)new ClientRequestImpl(this.getURI(), method));
    }

    public <T> Future<T> method(String method, Class<T> c, Object requestEntity) throws UniformInterfaceException {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), method, requestEntity));
    }

    public <T> Future<T> method(String method, GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), method, requestEntity));
    }

    public <T> Future<T> method(String method, ITypeListener<T> l, Object requestEntity) {
        return this.handle(l, (ClientRequest)new ClientRequestImpl(this.getURI(), method, requestEntity));
    }

    public Builder entity(Object entity) {
        return (Builder)this.getRequestBuilder().entity(entity);
    }

    public Builder entity(Object entity, MediaType type) {
        return (Builder)this.getRequestBuilder().entity(entity, type);
    }

    public Builder entity(Object entity, String type) {
        return (Builder)this.getRequestBuilder().entity(entity, type);
    }

    public Builder type(MediaType type) {
        return (Builder)this.getRequestBuilder().type(type);
    }

    public Builder type(String type) {
        return (Builder)this.getRequestBuilder().type(type);
    }

    public Builder accept(MediaType ... types) {
        return (Builder)this.getRequestBuilder().accept(types);
    }

    public Builder accept(String ... types) {
        return (Builder)this.getRequestBuilder().accept(types);
    }

    public Builder acceptLanguage(Locale ... locales) {
        return (Builder)this.getRequestBuilder().acceptLanguage(locales);
    }

    public Builder acceptLanguage(String ... locales) {
        return (Builder)this.getRequestBuilder().acceptLanguage(locales);
    }

    public Builder cookie(Cookie cookie) {
        return (Builder)this.getRequestBuilder().cookie(cookie);
    }

    public Builder header(String name, Object value) {
        return (Builder)this.getRequestBuilder().header(name, value);
    }

    public AsyncWebResource path(String path) {
        return new AsyncWebResource(this, this.getUriBuilder().path(path));
    }

    public AsyncWebResource uri(URI uri) {
        String query;
        UriBuilder b = this.getUriBuilder();
        String path = uri.getRawPath();
        if (path != null && path.length() > 0) {
            if (path.startsWith("/")) {
                b.replacePath(path);
            } else {
                b.path(path);
            }
        }
        if ((query = uri.getRawQuery()) != null && query.length() > 0) {
            b.replaceQuery(query);
        }
        return new AsyncWebResource(this, b);
    }

    public AsyncWebResource queryParam(String key, String value) {
        UriBuilder b = this.getUriBuilder();
        b.queryParam(key, new Object[]{value});
        return new AsyncWebResource(this, b);
    }

    public AsyncWebResource queryParams(MultivaluedMap<String, String> params) {
        UriBuilder b = this.getUriBuilder();
        for (Map.Entry e : params.entrySet()) {
            for (String value : (List)e.getValue()) {
                b.queryParam((String)e.getKey(), new Object[]{value});
            }
        }
        return new AsyncWebResource(this, b);
    }

    public void setProperty(String property, Object value) {
        this.getProperties().put(property, value);
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new CopyOnWriteHashMap();
        }
        return this.properties;
    }

    private void setProperties(ClientRequest ro) {
        if (this.properties != null) {
            ro.setProperties((Map)this.properties);
        }
    }

    private <T> Future<T> handle(Class<T> c, ClientRequest request) {
        this.setProperties(request);
        1 ftw = new /* Unavailable Anonymous Inner Class!! */;
        ftw.setCancelableFuture(this.handle(request, (FutureListener)ftw));
        return ftw;
    }

    private <T> Future<T> handle(GenericType<T> gt, ClientRequest request) {
        this.setProperties(request);
        2 ftw = new /* Unavailable Anonymous Inner Class!! */;
        ftw.setCancelableFuture(this.handle(request, (FutureListener)ftw));
        return ftw;
    }

    private <T> Future<T> handle(ITypeListener<T> l, ClientRequest request) {
        this.setProperties(request);
        3 ftw = new /* Unavailable Anonymous Inner Class!! */;
        ftw.setCancelableFuture(this.handle(request, (FutureListener)ftw));
        return ftw;
    }

    private Future<?> voidHandle(ClientRequest request) {
        this.setProperties(request);
        4 ftw = new /* Unavailable Anonymous Inner Class!! */;
        ftw.setCancelableFuture(this.handle(request, (FutureListener)ftw));
        return ftw;
    }

    public Future<ClientResponse> handle(ClientRequest request, FutureListener<ClientResponse> l) {
        this.setProperties(request);
        5 c = new /* Unavailable Anonymous Inner Class!! */;
        6 ft = new /* Unavailable Anonymous Inner Class!! */;
        this.executorService.submit((Runnable)ft);
        return ft;
    }

    static /* synthetic */ URI access$100(AsyncWebResource x0) {
        return x0.u;
    }

    static /* synthetic */ Future access$200(AsyncWebResource x0, Class x1, ClientRequest x2) {
        return x0.handle(x1, x2);
    }

    static /* synthetic */ Future access$300(AsyncWebResource x0, ITypeListener x1, ClientRequest x2) {
        return x0.handle(x1, x2);
    }

    static /* synthetic */ Future access$400(AsyncWebResource x0, GenericType x1, ClientRequest x2) {
        return x0.handle(x1, x2);
    }

    static /* synthetic */ Future access$500(AsyncWebResource x0, ClientRequest x1) {
        return x0.voidHandle(x1);
    }

    static /* synthetic */ Logger access$600() {
        return LOGGER;
    }
}

