/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client;

import com.sun.jersey.api.client.AsyncViewResource;
import com.sun.jersey.api.client.AsyncViewUniformInterface;
import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.RequestBuilder;
import com.sun.jersey.api.client.async.AsyncClientHandler;
import com.sun.jersey.api.client.async.FutureListener;
import com.sun.jersey.api.client.filter.Filterable;
import com.sun.jersey.client.impl.ClientRequestImpl;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;

public class AsyncViewResource
extends Filterable
implements RequestBuilder<Builder>,
AsyncViewUniformInterface,
AsyncClientHandler {
    private static final Logger LOGGER = Logger.getLogger(AsyncWebResource.class.getName());
    private final Client client;
    private final ExecutorService executorService;
    private final URI u;

    protected AsyncViewResource(Client c, URI u) {
        super((ClientHandler)c);
        this.client = c;
        this.executorService = c.getExecutorService();
        this.u = u;
    }

    protected AsyncViewResource(AsyncViewResource that, UriBuilder ub) {
        super((Filterable)that);
        this.client = that.client;
        this.executorService = that.executorService;
        this.u = ub.build(new Object[0]);
    }

    public URI getURI() {
        return this.u;
    }

    public UriBuilder getUriBuilder() {
        return UriBuilder.fromUri((URI)this.u);
    }

    public Builder getRequestBuilder() {
        return new Builder(this, null);
    }

    public String toString() {
        return this.u.toString();
    }

    public int hashCode() {
        return this.u.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AsyncViewResource) {
            AsyncViewResource that = (AsyncViewResource)obj;
            return that.u.equals(this.u);
        }
        return false;
    }

    public <T> Future<T> head(Class<T> c) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "HEAD"));
    }

    public <T> Future<T> head(T t) {
        return this.handle(t, (ClientRequest)new ClientRequestImpl(this.getURI(), "HEAD"));
    }

    public <T> Future<T> options(Class<T> c) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "OPTIONS"));
    }

    public <T> Future<T> options(T t) {
        return this.handle(t, (ClientRequest)new ClientRequestImpl(this.getURI(), "OPTIONS"));
    }

    public <T> Future<T> get(Class<T> c) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "GET"));
    }

    public <T> Future<T> get(T t) {
        return this.handle(t, (ClientRequest)new ClientRequestImpl(this.getURI(), "GET"));
    }

    public <T> Future<T> put(Class<T> c) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT"));
    }

    public <T> Future<T> put(T t) {
        return this.handle(t, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT"));
    }

    public <T> Future<T> put(Class<T> c, Object requestEntity) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT", requestEntity));
    }

    public <T> Future<T> put(T t, Object requestEntity) {
        return this.handle(t, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT", requestEntity));
    }

    public <T> Future<T> post(Class<T> c) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST"));
    }

    public <T> Future<T> post(T t) {
        return this.handle(t, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST"));
    }

    public <T> Future<T> post(Class<T> c, Object requestEntity) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST", requestEntity));
    }

    public <T> Future<T> post(T t, Object requestEntity) {
        return this.handle(t, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST", requestEntity));
    }

    public <T> Future<T> delete(Class<T> c) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE"));
    }

    public <T> Future<T> delete(T t) {
        return this.handle(t, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE"));
    }

    public <T> Future<T> delete(Class<T> c, Object requestEntity) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE", requestEntity));
    }

    public <T> Future<T> delete(T t, Object requestEntity) {
        return this.handle(t, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE", requestEntity));
    }

    public <T> Future<T> method(String method, Class<T> c) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), method));
    }

    public <T> Future<T> method(String method, T t) {
        return this.handle(t, (ClientRequest)new ClientRequestImpl(this.getURI(), method));
    }

    public <T> Future<T> method(String method, Class<T> c, Object requestEntity) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), method, requestEntity));
    }

    public <T> Future<T> method(String method, T t, Object requestEntity) {
        return this.handle(t, (ClientRequest)new ClientRequestImpl(this.getURI(), method, requestEntity));
    }

    public Builder entity(Object entity) {
        return (Builder)this.getRequestBuilder().entity(entity);
    }

    public Builder entity(Object entity, MediaType type) {
        return (Builder)this.getRequestBuilder().entity(entity, type);
    }

    public Builder entity(Object entity, String type) {
        return (Builder)this.getRequestBuilder().entity(entity, type);
    }

    public Builder type(MediaType type) {
        return (Builder)this.getRequestBuilder().type(type);
    }

    public Builder type(String type) {
        return (Builder)this.getRequestBuilder().type(type);
    }

    public Builder accept(MediaType ... types) {
        return (Builder)this.getRequestBuilder().accept(types);
    }

    public Builder accept(String ... types) {
        return (Builder)this.getRequestBuilder().accept(types);
    }

    public Builder acceptLanguage(Locale ... locales) {
        return (Builder)this.getRequestBuilder().acceptLanguage(locales);
    }

    public Builder acceptLanguage(String ... locales) {
        return (Builder)this.getRequestBuilder().acceptLanguage(locales);
    }

    public Builder cookie(Cookie cookie) {
        return (Builder)this.getRequestBuilder().cookie(cookie);
    }

    public Builder header(String name, Object value) {
        return (Builder)this.getRequestBuilder().header(name, value);
    }

    public AsyncViewResource path(String path) {
        return new AsyncViewResource(this, this.getUriBuilder().path(path));
    }

    public AsyncViewResource uri(URI uri) {
        String query;
        UriBuilder b = this.getUriBuilder();
        String path = uri.getRawPath();
        if (path != null && path.length() > 0) {
            if (path.startsWith("/")) {
                b.replacePath(path);
            } else {
                b.path(path);
            }
        }
        if ((query = uri.getRawQuery()) != null && query.length() > 0) {
            b.replaceQuery(query);
        }
        return new AsyncViewResource(this, b);
    }

    public AsyncViewResource queryParam(String key, String value) {
        UriBuilder b = this.getUriBuilder();
        b.queryParam(key, new Object[]{value});
        return new AsyncViewResource(this, b);
    }

    public AsyncViewResource queryParams(MultivaluedMap<String, String> params) {
        UriBuilder b = this.getUriBuilder();
        for (Map.Entry e : params.entrySet()) {
            for (String value : (List)e.getValue()) {
                b.queryParam((String)e.getKey(), new Object[]{value});
            }
        }
        return new AsyncViewResource(this, b);
    }

    private <T> Future<T> handle(Class<T> c, ClientRequest ro) {
        return this.client.getViewProxy(c).asyncView(c, ro, (AsyncClientHandler)this);
    }

    private <T> Future<T> handle(T t, ClientRequest ro) {
        return this.client.getViewProxy(t.getClass()).asyncView(t, ro, (AsyncClientHandler)this);
    }

    public Future<ClientResponse> handle(ClientRequest request, FutureListener<ClientResponse> l) {
        1 c = new /* Unavailable Anonymous Inner Class!! */;
        2 ft = new /* Unavailable Anonymous Inner Class!! */;
        this.executorService.submit((Runnable)ft);
        return ft;
    }

    static /* synthetic */ URI access$100(AsyncViewResource x0) {
        return x0.u;
    }

    static /* synthetic */ Future access$200(AsyncViewResource x0, Class x1, ClientRequest x2) {
        return x0.handle(x1, x2);
    }

    static /* synthetic */ Future access$300(AsyncViewResource x0, Object x1, ClientRequest x2) {
        return x0.handle(x1, x2);
    }

    static /* synthetic */ Logger access$400() {
        return LOGGER;
    }
}

