/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api;

import com.sun.jersey.api.JResponse;
import com.sun.jersey.api.JResponseAsResponse;
import com.sun.jersey.core.header.OutBoundHeaders;
import com.sun.jersey.core.spi.factory.ResponseImpl;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;

/*
 * Exception performing whole class analysis ignored.
 */
public class JResponse<E> {
    private final Response.StatusType statusType;
    private final E entity;
    private final OutBoundHeaders headers;

    public JResponse(Response.StatusType statusType, OutBoundHeaders headers, E entity) {
        this.statusType = statusType;
        this.entity = entity;
        this.headers = headers;
    }

    public JResponse(int status, OutBoundHeaders headers, E entity) {
        this(ResponseImpl.toStatusType((int)status), headers, entity);
    }

    public JResponse(JResponse<E> that) {
        this(that.statusType, that.headers != null ? new OutBoundHeaders(that.headers) : null, that.entity);
    }

    protected JResponse(AJResponseBuilder<E, ?> b) {
        this.statusType = b.getStatusType();
        this.entity = b.getEntity();
        this.headers = b.getMetadata();
    }

    public JResponseAsResponse toResponse() {
        return new JResponseAsResponse(this);
    }

    public JResponseAsResponse toResponse(Type type) {
        return new JResponseAsResponse(this, type);
    }

    public Response.StatusType getStatusType() {
        return this.statusType;
    }

    public int getStatus() {
        return this.statusType.getStatusCode();
    }

    public OutBoundHeaders getMetadata() {
        return this.headers;
    }

    public E getEntity() {
        return (E)this.entity;
    }

    public Type getType() {
        return JResponse.getSuperclassTypeParameter(this.getClass());
    }

    private static Type getSuperclassTypeParameter(Class<?> subclass) {
        Type superclass = subclass.getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) {
            return Object.class;
        }
        ParameterizedType parameterized = (ParameterizedType)superclass;
        return parameterized.getActualTypeArguments()[0];
    }

    public static <E> JResponseBuilder<E> fromResponse(Response response) {
        JResponseBuilder b = JResponse.status((int)response.getStatus());
        b.entity(response.getEntity());
        for (String headerName : response.getMetadata().keySet()) {
            List headerValues = (List)response.getMetadata().get((Object)headerName);
            for (Object headerValue : headerValues) {
                b.header(headerName, headerValue);
            }
        }
        return b;
    }

    public static <E> JResponseBuilder<E> fromResponse(JResponse<E> response) {
        JResponseBuilder b = JResponse.status((int)response.getStatus());
        b.entity(response.getEntity());
        for (String headerName : response.getMetadata().keySet()) {
            List headerValues = (List)response.getMetadata().get((Object)headerName);
            for (Object headerValue : headerValues) {
                b.header(headerName, headerValue);
            }
        }
        return b;
    }

    public static <E> JResponseBuilder<E> status(Response.StatusType status) {
        JResponseBuilder b = new JResponseBuilder();
        b.status(status);
        return b;
    }

    public static <E> JResponseBuilder<E> status(Response.Status status) {
        return JResponse.status((Response.StatusType)status);
    }

    public static <E> JResponseBuilder<E> status(int status) {
        JResponseBuilder b = new JResponseBuilder();
        b.status(status);
        return b;
    }

    public static <E> JResponseBuilder<E> ok() {
        JResponseBuilder b = JResponse.status((Response.Status)Response.Status.OK);
        return b;
    }

    public static <E> JResponseBuilder<E> ok(E entity) {
        JResponseBuilder b = JResponse.ok();
        b.entity(entity);
        return b;
    }

    public static <E> JResponseBuilder<E> ok(E entity, MediaType type) {
        JResponseBuilder b = JResponse.ok();
        b.entity(entity);
        b.type(type);
        return b;
    }

    public static <E> JResponseBuilder<E> ok(E entity, String type) {
        JResponseBuilder b = JResponse.ok();
        b.entity(entity);
        b.type(type);
        return b;
    }

    public static <E> JResponseBuilder<E> ok(E entity, Variant variant) {
        JResponseBuilder b = JResponse.ok();
        b.entity(entity);
        b.variant(variant);
        return b;
    }

    public static <E> JResponseBuilder<E> serverError() {
        JResponseBuilder b = JResponse.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        return b;
    }

    public static <E> JResponseBuilder<E> created(URI location) {
        JResponseBuilder b = (JResponseBuilder)JResponse.status((Response.Status)Response.Status.CREATED).location(location);
        return b;
    }

    public static <E> JResponseBuilder<E> noContent() {
        JResponseBuilder b = JResponse.status((Response.Status)Response.Status.NO_CONTENT);
        return b;
    }

    public static <E> JResponseBuilder<E> notModified() {
        JResponseBuilder b = JResponse.status((Response.Status)Response.Status.NOT_MODIFIED);
        return b;
    }

    public static <E> JResponseBuilder<E> notModified(EntityTag tag) {
        JResponseBuilder b = JResponse.notModified();
        b.tag(tag);
        return b;
    }

    public static <E> JResponseBuilder<E> notModified(String tag) {
        JResponseBuilder b = JResponse.notModified();
        b.tag(tag);
        return b;
    }

    public static <E> JResponseBuilder<E> seeOther(URI location) {
        JResponseBuilder b = (JResponseBuilder)JResponse.status((Response.Status)Response.Status.SEE_OTHER).location(location);
        return b;
    }

    public static <E> JResponseBuilder<E> temporaryRedirect(URI location) {
        JResponseBuilder b = (JResponseBuilder)JResponse.status((Response.Status)Response.Status.TEMPORARY_REDIRECT).location(location);
        return b;
    }

    public static <E> JResponseBuilder<E> notAcceptable(List<Variant> variants) {
        JResponseBuilder b = (JResponseBuilder)JResponse.status((Response.Status)Response.Status.NOT_ACCEPTABLE).variants(variants);
        return b;
    }
}

