/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.cluster.CacheCluster;
import net.sf.ehcache.config.DynamicSearchListener;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.search.attribute.DynamicAttributesExtractor;
import net.sf.ehcache.search.impl.AggregateOnlyResult;
import net.sf.ehcache.search.impl.BaseResult;
import net.sf.ehcache.search.impl.ResultsImpl;
import net.sf.ehcache.store.StoreQuery;
import org.terracotta.modules.ehcache.ToolkitInstanceFactory;
import org.terracotta.modules.ehcache.search.ClusteredResultsList;
import org.terracotta.modules.ehcache.search.QueryInterpreter;
import org.terracotta.modules.ehcache.store.AttributeExtractorManager;
import org.terracotta.modules.ehcache.store.ClusteredStore;
import org.terracotta.toolkit.ToolkitFeatureType;
import org.terracotta.toolkit.feature.SearchFeature;
import org.terracotta.toolkit.search.SearchQueryResultSet;
import org.terracotta.toolkit.search.attribute.ToolkitAttributeExtractor;

public class EnterpriseClusteredStore
extends ClusteredStore
implements DynamicSearchListener {
    private final AttributeExtractorManager xtorBridge;
    private final Lock lock;

    public EnterpriseClusteredStore(ToolkitInstanceFactory toolkitInstanceFactory, Ehcache cache, CacheCluster topology) {
        super(toolkitInstanceFactory, cache, topology);
        this.lock = toolkitInstanceFactory.getOrCreateStoreLock(cache);
        cache.getCacheConfiguration().addDynamicSearchListener(this);
        this.xtorBridge = new AttributeExtractorManager(cache, toolkitInstanceFactory, this.valueModeHandler);
    }

    @Override
    public Set<Attribute> getSearchAttributes() {
        return this.xtorBridge.getSearchAttributes();
    }

    @Override
    public <T> Attribute<T> getSearchAttribute(String attributeName) {
        Attribute attr = new Attribute(attributeName);
        return this.getSearchAttributes().contains(attr) ? attr : null;
    }

    @Override
    public Results executeQuery(StoreQuery query) {
        List<Result> res;
        QueryInterpreter interpreter = new QueryInterpreter(this.backend.createQueryBuilder());
        interpreter.process(query);
        final SearchQueryResultSet queryResults = interpreter.executeQuery();
        List aggregatorResults = queryResults.getAggregatorResults();
        if (queryResults.anyCriteriaMatched() && queryResults.getResults().isEmpty() && !aggregatorResults.isEmpty()) {
            res = Collections.singletonList(new AggregateOnlyResult(query));
            ((BaseResult)res.get(0)).setAggregateResults(aggregatorResults);
        } else {
            res = new ClusteredResultsList(queryResults.getResults(), query, this.valueModeHandler);
        }
        return new ResultsImpl((List<? extends Result>)res, query.requestsKeys(), query.requestsValues(), !query.requestedAttributes().isEmpty(), queryResults.anyCriteriaMatched() && !query.getAggregatorInstances().isEmpty(), new Runnable(){

            @Override
            public void run() {
                queryResults.close();
            }
        });
    }

    @Override
    public boolean isSearchable() {
        return !this.xtorBridge.getSearchAttributes().isEmpty() || this.xtorBridge.getDynamicAttrExtractor() != null;
    }

    @Override
    public void setAttributeExtractors(Map<String, AttributeExtractor> requestedExtractors) {
        SearchFeature searchFeature;
        if (!(requestedExtractors.isEmpty() || (searchFeature = (SearchFeature)this.toolkitInstanceFactory.getToolkit().getFeature(ToolkitFeatureType.SEARCH)) != null && searchFeature.isEnabled())) {
            throw new UnsupportedOperationException("Search capability is not enabled. Please verify you have correct license");
        }
        this.lock.lock();
        try {
            this.xtorBridge.setupExtractors(requestedExtractors);
            this.backend.setAttributeExtractor((ToolkitAttributeExtractor)this.xtorBridge);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void extractorChanged(DynamicAttributesExtractor oldValue, DynamicAttributesExtractor newValue) {
        this.xtorBridge.setDynamicAttrExtractor(newValue);
    }
}

