/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;

public class Util {
    private static final int DEL = 127;
    private static final char ESCAPE = '%';
    private static final Set<Character> ILLEGALS = new HashSet<Character>();
    private static final MessageDigestProvider provider;

    static boolean shouldUpgrade(File rootDir, String cacheName) throws IOException {
        File cacheDir = new File(rootDir, Util.escapeString(cacheName));
        return Util.shouldUpgrade(cacheDir);
    }

    static boolean shouldUpgrade(File cacheDir) throws IOException {
        if (!cacheDir.exists()) {
            return false;
        }
        File hashFile = new File(cacheDir, "__terracotta_adjusted_cache_name");
        if (!hashFile.exists()) {
            return true;
        }
        String hash = Util.sanitizeCacheName(Util.loadContent(hashFile));
        return !hash.equals(cacheDir.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String loadContent(File f) throws IOException {
        FileInputStream in = null;
        try {
            int read;
            in = new FileInputStream(f);
            StringBuilder sb = new StringBuilder();
            byte[] buf = new byte[2];
            while ((read = in.read(buf)) != -1) {
                if (read != 2) {
                    throw new IOException("read " + read + " bytes");
                }
                char c = (char)(buf[0] << 8 | buf[1] & 0xFF);
                sb.append(c);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void storeContent(File f, String content) throws IOException {
        FileOutputStream out = null;
        try {
            byte[] byteRepr;
            out = new FileOutputStream(f);
            for (byte b : byteRepr = Util.getBytes(content)) {
                out.write(b);
            }
            out.flush();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static void upgradeCache(File rootDir, String cacheName, String adjustedString, String hashString) throws IOException {
        File cacheDir = new File(rootDir, Util.escapeString(cacheName));
        Util.upgradeCache(rootDir, cacheDir, adjustedString, hashString);
    }

    static void upgradeCache(File rootDir, File cacheDir, String adjustedName, String hashString) throws IOException {
        Util.storeContent(new File(cacheDir, "__terracotta_adjusted_cache_name"), adjustedName);
        boolean status = cacheDir.renameTo(new File(rootDir, hashString));
        if (!status) {
            throw new IllegalStateException("Upgrading cache failed at rename stage");
        }
    }

    private static String getCollisionFreeCacheName(File rootDir, String cacheName) throws IOException {
        String hashString = Util.sanitizeCacheName(cacheName);
        boolean collisionOccurred = Util.checkForCollision(rootDir, hashString, cacheName);
        String adjustedName = cacheName;
        int i = 0;
        while (collisionOccurred) {
            adjustedName = adjustedName + i++;
            hashString = Util.sanitizeCacheName(adjustedName);
            collisionOccurred = Util.checkForCollision(rootDir, hashString, cacheName);
        }
        return adjustedName;
    }

    static boolean checkForCollision(File rootDir, String hashString, String originalName) throws IOException {
        File cacheDir = new File(rootDir, hashString);
        if (!cacheDir.exists()) {
            return false;
        }
        String name = Util.loadCacheName(cacheDir);
        return !originalName.equals(name);
    }

    private static String loadCacheName(File cacheDir) throws IOException {
        return Util.loadContent(new File(cacheDir, "__terracotta_cache_name.txt"));
    }

    static File getOrCreateCacheGroupDir(File rootDir, String cacheName, boolean existing) throws IOException {
        String adjustedName = Util.getCollisionFreeCacheName(rootDir, cacheName);
        String hashString = Util.sanitizeCacheName(adjustedName);
        File cacheDir = new File(rootDir, hashString);
        if (existing) {
            boolean shouldUpgrade = Util.shouldUpgrade(rootDir, cacheName);
            if (shouldUpgrade) {
                Util.upgradeCache(rootDir, cacheName, adjustedName, hashString);
            }
        } else {
            Util.ensureDirectory(cacheDir);
            Util.storeContent(new File(cacheDir, "__terracotta_adjusted_cache_name"), adjustedName);
        }
        return cacheDir;
    }

    public static String sanitizeCacheName(String name) {
        return Util.sanitizeCacheName(name, provider);
    }

    static String sanitizeCacheName(String name, MessageDigestProvider provider) {
        return Util.hashCacheName(name, provider);
    }

    static String escapeString(String name) {
        int len = name.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c <= ' ' || c >= '\u007f' || c >= 'A' && c <= 'Z' || ILLEGALS.contains(Character.valueOf(c)) || c == '%') {
                sb.append('%');
                sb.append(String.format("%04x", c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String hashCacheName(String name, MessageDigestProvider provider) {
        MessageDigest md;
        try {
            md = provider.getMessageDigest();
        }
        catch (NoSuchAlgorithmException e) {
            return Util.escapeString(name);
        }
        byte[] hash = md.digest(Util.getBytes(name));
        StringBuilder sb = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    static byte[] getBytes(String name) {
        byte[] byteArray = new byte[name.length() * 2];
        int i = 0;
        for (char c : name.toCharArray()) {
            byteArray[i++] = (byte)(0xFF & c >> 8);
            byteArray[i++] = (byte)(0xFF & c);
        }
        return byteArray;
    }

    public static synchronized void ensureDirectory(File dir) throws IOException {
        if (dir.exists() && !dir.isDirectory()) {
            throw new IOException("Non-directory path exists at " + dir.getAbsolutePath());
        }
        if (dir.isDirectory()) {
            return;
        }
        boolean created = dir.mkdirs();
        if (!created) {
            throw new IOException("Cannot create directory: " + dir.getAbsolutePath());
        }
        if (!dir.canWrite()) {
            throw new IOException("Cannot write to [newly created] directory: " + dir.getAbsolutePath());
        }
    }

    public static void deleteDirectory(File dir) throws IOException {
        Util.cleanDirectory(dir, true);
    }

    public static void cleanDirectory(File dir) throws IOException {
        Util.cleanDirectory(dir, false);
    }

    private static void cleanDirectory(File dir, boolean deleteTop) throws IOException {
        boolean deleted;
        if (!dir.exists()) {
            return;
        }
        if (dir.isFile()) {
            throw new IOException(dir + " is not a directory");
        }
        for (File entry : dir.listFiles()) {
            if (entry.isDirectory()) {
                Util.deleteDirectory(entry);
                continue;
            }
            boolean deleted2 = entry.delete();
            if (deleted2) continue;
            throw new IOException("Cannot delete " + entry);
        }
        if (deleteTop && !(deleted = dir.delete())) {
            throw new IOException("Cannot delete " + dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest) throws IOException {
        if (!src.isFile()) {
            throw new IOException(src + " is not a file");
        }
        byte[] buf = new byte[8192];
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int read;
            in = new FileInputStream(src);
            out = new FileOutputStream(dest, false);
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
        }
        catch (Throwable throwable) {
            Util.closeQuietly(in);
            Util.closeQuietly(out);
            throw throwable;
        }
        Util.closeQuietly(in);
        Util.closeQuietly(out);
    }

    public static void closeQuietly(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        ILLEGALS.add(Character.valueOf('/'));
        ILLEGALS.add(Character.valueOf('\\'));
        ILLEGALS.add(Character.valueOf('<'));
        ILLEGALS.add(Character.valueOf('>'));
        ILLEGALS.add(Character.valueOf(':'));
        ILLEGALS.add(Character.valueOf('\"'));
        ILLEGALS.add(Character.valueOf('|'));
        ILLEGALS.add(Character.valueOf('?'));
        ILLEGALS.add(Character.valueOf('*'));
        ILLEGALS.add(Character.valueOf('.'));
        provider = new MessageDigestProvider();
    }

    static class MessageDigestProvider {
        MessageDigestProvider() {
        }

        MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
            return MessageDigest.getInstance("MD5");
        }
    }
}

