/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import com.terracottatech.search.Log2DistroBins;
import com.terracottatech.search.Logger;
import com.terracottatech.search.LoggerFactory;
import com.terracottatech.search.NVPair;
import com.terracottatech.search.QueryID;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.terracotta.shaded.lucene.search.Query;

public class SearchMonitor {
    private static long ENV_INTERVAL_SECONDS = Math.max(Long.parseLong(System.getProperty("tc.searchmonitor.intervalMS", "0")), Long.parseLong(System.getProperty("tc.searchmonitor.interval", "0")));
    private static long LOGGING_RESULT_MIN = Long.parseLong(System.getProperty("tc.searchmonitor.oversizedQueryLogging", "0"));
    private static Query NULLQ = new Query(){

        @Override
        public String toString(String s) {
            return "unknown query";
        }
    };
    private final Logger log;
    private AtomicLong generation = new AtomicLong(0L);
    private final TotalStatsHolder[] holders = new TotalStatsHolder[]{new TotalStatsHolder(), new TotalStatsHolder()};
    private volatile Timer timer;
    private volatile TimerTask task;
    private volatile long intervalMS;
    private volatile int currentIndex = 0;
    private volatile TotalStatsHolder currentHolder = this.holders[this.currentIndex];
    private volatile boolean dead = false;
    private ConcurrentHashMap<QueryID, QueryInfo> liveQueries = new ConcurrentHashMap();
    private volatile long oversizedMin;
    private static Comparator<QueryInfo> QICOMP = new Comparator<QueryInfo>(){

        @Override
        public int compare(QueryInfo o1, QueryInfo o2) {
            return o1.compareTo(o2);
        }
    };

    public SearchMonitor(LoggerFactory logFactory) {
        this(logFactory, ENV_INTERVAL_SECONDS, TimeUnit.SECONDS, LOGGING_RESULT_MIN);
    }

    public SearchMonitor(LoggerFactory logFactory, long interval, TimeUnit unit, long oversizeMinimum) {
        this.log = logFactory.getLogger(SearchMonitor.class);
        this.setInterval(interval, unit);
        this.setOversizedMinimum(oversizeMinimum);
    }

    public void setOversizedMinimum(long i) {
        this.oversizedMin = i;
    }

    public synchronized void setInterval(long dur, TimeUnit unit) {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.intervalMS = TimeUnit.MILLISECONDS.convert(dur, unit);
        if (this.intervalMS > 0L) {
            this.timer = new Timer("Search monitor", true);
            this.task = new TimerTask(){

                @Override
                public void run() {
                    SearchMonitor.this.logAndRotate();
                }
            };
            this.timer.schedule(this.task, this.intervalMS, this.intervalMS);
        } else {
            this.timer = null;
            this.task = null;
        }
    }

    public synchronized void shutdown() {
        if (!this.dead) {
            this.dead = true;
            this.setInterval(0L, TimeUnit.SECONDS);
            this.liveQueries.clear();
        }
    }

    public void beginTrackingQuery(long startNanos, QueryID id, String indexName, int queryStackSize, Query query, boolean includeKeys, boolean includeValues, Set<String> attributeSet, Set<String> groupByAttributes, List<NVPair> sortAttributes, List<NVPair> aggPairs, int resultLimit, int batchLimit) {
        if (this.dead) {
            return;
        }
        QueryInfo qi = new QueryInfo(startNanos, id, indexName, query, queryStackSize, includeKeys, includeValues, attributeSet, groupByAttributes, sortAttributes, aggPairs, resultLimit, batchLimit);
        QueryInfo ret = this.liveQueries.putIfAbsent(id, qi);
        if (this.intervalMS > 0L) {
            TotalStatsHolder p = this.currentHolder;
            p.searchCount.incrementAndGet();
            p.queryStackSizeCount.addAndGet(queryStackSize);
            p.aggregateCount.addAndGet(aggPairs.size());
            p.attributeSetCount.addAndGet(attributeSet.size());
            p.groupByAttributeCount.addAndGet(groupByAttributes.size());
            if (includeKeys) {
                p.includeKeysCount.incrementAndGet();
            }
            if (includeValues) {
                p.includeValuesCount.incrementAndGet();
            }
            p.sortAttributeCount.addAndGet(sortAttributes.size());
            int was = p.maxStackDepthCount.get();
            if (queryStackSize > was) {
                if (p.maxStackDepthSeen.compareAndSet(was, queryStackSize)) {
                    p.maxStackDepthCount.set(0);
                }
            } else if (queryStackSize == was) {
                p.maxStackDepthCount.incrementAndGet();
            }
        }
    }

    public TotalStatsHolder currentTotalStats() {
        return this.currentHolder;
    }

    public void trackQueryResults(QueryID id, int cnt) {
        QueryInfo q;
        if (this.dead || this.intervalMS <= 0L) {
            return;
        }
        TotalStatsHolder p = this.currentHolder;
        p.resultCount.addAndGet(cnt);
        if (cnt > 0 && (q = this.liveQueries.get(id)) != null) {
            q.resultCount += (long)cnt;
            if (this.oversizedMin > 0L && q.resultCount > this.oversizedMin) {
                this.log.warn("Search-Monitor-Oversized-Query : " + q.toString());
                p.oversizedCount.incrementAndGet();
            }
        }
    }

    public void finishTrackingQuery(QueryID id) {
        if (this.dead) {
            return;
        }
        QueryInfo ret = this.liveQueries.remove(id);
        if (ret != null) {
            long took = System.nanoTime() - ret.startTimeNS;
            ret.setElapsedTimeNS(took);
            TotalStatsHolder p = this.currentHolder;
            p.searchLatencies.record(TimeUnit.NANOSECONDS.convert(took, TimeUnit.NANOSECONDS));
            p.maxElapsedTime.inform(took, ret);
            p.maxQueryStack.inform(ret.queryStackSize, ret);
            p.maxResults.inform(ret.resultCount, ret);
        }
    }

    public void logAndRotate() {
        this.loginfo();
        this.rotate();
    }

    private void loginfo() {
        TotalStatsHolder p = this.currentHolder;
        this.log.info("Search-Monitor-Interval-Stats (" + p.currentGeneration + ") : " + p.intervalString());
        this.log.info("Search-Monitor-Latency (" + p.currentGeneration + ") : " + p.searchLatencies.toString(Log2DistroBins.ToString.RANGES_NO_ZEROS));
        this.log.info("Search-Monitor-MaxResults (" + p.currentGeneration + ") : " + p.maxResults);
        this.log.info("Search-Monitor-MaxElapsedTime (" + p.currentGeneration + ") : " + Log2DistroBins.unixDurationNS(p.maxElapsedTime.value) + " " + p.maxElapsedTime.qi);
        this.log.info("Search-Monitor-MaxQueryStack (" + p.currentGeneration + ") : " + p.maxQueryStack);
        long now = System.nanoTime();
        for (QueryInfo qi : this.getLiveQuerySnapshot()) {
            this.log.info("Search-Monitor-Live-Search (" + p.currentGeneration + ") : " + qi.toString(now));
        }
    }

    public List<QueryInfo> getLiveQuerySnapshot() {
        ArrayList<QueryInfo> ts = new ArrayList<QueryInfo>(this.liveQueries.values());
        Collections.sort(ts, QICOMP);
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        TotalStatsHolder p;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        TotalStatsHolder totalStatsHolder = p = this.currentHolder;
        synchronized (totalStatsHolder) {
            pw.println("Search-Monitor-Interval-Stats (" + p.currentGeneration + ") : " + p.intervalString());
            pw.println("Search-Monitor-Latency (" + p.currentGeneration + ") : " + p.searchLatencies.toString(Log2DistroBins.ToString.RANGES_NO_ZEROS));
            pw.println("Search-Monitor-MaxResults (" + p.currentGeneration + ") : " + p.maxResults);
            pw.println("Search-Monitor-MaxElapsedTime (" + p.currentGeneration + ") : " + Log2DistroBins.unixDurationNS(p.maxElapsedTime.value) + " " + p.maxElapsedTime.qi);
            pw.println("Search-Monitor-MaxQueryStack (" + p.currentGeneration + ") : " + p.maxQueryStack);
            long now = System.nanoTime();
            for (QueryInfo qi : this.getLiveQuerySnapshot()) {
                pw.println("Search-Monitor-Live-Search (" + p.currentGeneration + ") : " + qi.toString(now));
            }
            pw.flush();
            return sw.toString();
        }
    }

    private synchronized void rotate() {
        TotalStatsHolder was = this.currentHolder;
        this.currentIndex = 1 - this.currentIndex;
        this.currentHolder = this.holders[this.currentIndex];
        was.reset();
    }

    static class MaxHolder {
        private final String name;
        private volatile long value = 0L;
        private volatile QueryInfo qi;
        private volatile boolean empty = true;

        public MaxHolder(String name) {
            this.name = name;
        }

        public synchronized void inform(long val, QueryInfo info) {
            if (info != null) {
                if (this.empty) {
                    this.value = val;
                    this.qi = info;
                    this.empty = false;
                } else if (val >= this.value) {
                    this.qi = info;
                    this.value = val;
                }
            }
        }

        public void reset() {
            this.empty = true;
        }

        public String toString() {
            QueryInfo p = this.qi;
            if (!this.empty) {
                return this.value + " " + p.toString();
            }
            return "NA";
        }
    }

    class TotalStatsHolder {
        final AtomicLong searchCount = new AtomicLong(0L);
        final AtomicLong queryStackSizeCount = new AtomicLong(0L);
        final AtomicLong includeKeysCount = new AtomicLong(0L);
        final AtomicLong includeValuesCount = new AtomicLong(0L);
        final AtomicLong attributeSetCount = new AtomicLong(0L);
        final AtomicLong groupByAttributeCount = new AtomicLong(0L);
        final AtomicLong sortAttributeCount = new AtomicLong(0L);
        final AtomicLong aggregateCount = new AtomicLong(0L);
        final AtomicLong resultCount = new AtomicLong(0L);
        final AtomicInteger maxStackDepthSeen = new AtomicInteger(0);
        final AtomicInteger maxStackDepthCount = new AtomicInteger(0);
        final AtomicInteger oversizedCount = new AtomicInteger(0);
        final MaxHolder maxElapsedTime = new MaxHolder("elapsed time");
        final MaxHolder maxQueryStack = new MaxHolder("query stack");
        final MaxHolder maxResults = new MaxHolder("results");
        final Log2DistroBins searchLatencies = new Log2DistroBins(Log2DistroBins.NANOS_LABELS, 15);
        long currentGeneration = SearchMonitor.access$300(SearchMonitor.this).getAndIncrement();

        TotalStatsHolder() {
        }

        synchronized void reset() {
            this.searchCount.set(0L);
            this.queryStackSizeCount.set(0L);
            this.includeKeysCount.set(0L);
            this.includeValuesCount.set(0L);
            this.attributeSetCount.set(0L);
            this.groupByAttributeCount.set(0L);
            this.sortAttributeCount.set(0L);
            this.aggregateCount.set(0L);
            this.resultCount.set(0L);
            this.oversizedCount.set(0);
            this.oversizedCount.set(0);
            this.maxStackDepthSeen.set(0);
            this.maxElapsedTime.reset();
            this.maxQueryStack.reset();
            this.maxResults.reset();
            this.searchLatencies.sloppyReset();
            this.currentGeneration = SearchMonitor.this.generation.getAndIncrement();
        }

        public String toString() {
            return this.intervalString();
        }

        public String intervalString() {
            return "searches=" + this.searchCount + " searchTerms=" + this.queryStackSizeCount + " keysIncluded=" + this.includeKeysCount + " valuesIncluded=" + this.includeValuesCount + " attributes=" + this.attributeSetCount + " groupBys=" + this.groupByAttributeCount + " sortAttributes=" + this.sortAttributeCount + " aggregates=" + this.aggregateCount + " resultCount=" + this.resultCount + " maxStackSize=" + this.maxStackDepthSeen + "/" + this.maxStackDepthCount.get() + " oversized queries=" + this.oversizedCount.get();
        }
    }

    static class QueryInfo
    implements Comparable<QueryInfo> {
        final QueryID id;
        final int queryStackSize;
        final boolean keys;
        final boolean values;
        final Set<String> attributeSet;
        final Set<String> groupByAttributes;
        final List<NVPair> sortAttributes;
        final List<NVPair> aggPairs;
        final int resultlimit;
        final int batchLimit;
        final Query query;
        final String indexName;
        final long startTimeNS;
        volatile long resultCount;
        volatile long elapsedTimeNS;

        public QueryInfo(long startNanos, QueryID id, String indexName, Query query, int queryStackSize, boolean keys, boolean values, Set<String> attributeSet, Set<String> groupByAttributes, List<NVPair> sortAttributes, List<NVPair> aggPairs, int resultLimit, int batchLimit) {
            this.startTimeNS = startNanos;
            this.id = id == null ? new QueryID(-1L, -1L) : id;
            this.indexName = indexName == null ? "unknown" : indexName;
            this.query = query == null ? NULLQ : query;
            this.queryStackSize = queryStackSize;
            this.keys = keys;
            this.values = values;
            this.attributeSet = attributeSet == null ? Collections.EMPTY_SET : attributeSet;
            this.groupByAttributes = groupByAttributes == null ? Collections.EMPTY_SET : groupByAttributes;
            this.sortAttributes = sortAttributes == null ? Collections.EMPTY_LIST : sortAttributes;
            this.aggPairs = aggPairs == null ? Collections.EMPTY_LIST : aggPairs;
            this.resultlimit = resultLimit;
            this.batchLimit = batchLimit;
            this.resultCount = 0L;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryInfo info = (QueryInfo)o;
            return this.id.equals(info.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            if (this.elapsedTimeNS == 0L) {
                return this.toString(System.nanoTime());
            }
            return this.toString(this.startTimeNS + this.elapsedTimeNS);
        }

        public String toString(long nowNS) {
            long timeTook = nowNS - this.startTimeNS;
            try {
                return this.id + " Index=" + this.indexName + " Search: [" + this.query.toString() + "] keys=" + this.keys + " values=" + this.values + " attributeSet=" + this.attributeSet + " groupByAttributes=" + this.groupByAttributes + " sortAttributes=" + this.sortAttributes + " aggPairs=" + this.aggPairs + " resultLimit=" + this.resultlimit + " batchLimit=" + this.batchLimit + " resultCount=" + this.resultCount + " (" + Log2DistroBins.unixDurationNS(timeTook) + " = " + timeTook + "ns)";
            }
            catch (Throwable t) {
                return "unprintable QueryInfo";
            }
        }

        @Override
        public int compareTo(QueryInfo o) {
            long ret = this.id.queryId - o.id.queryId;
            if (ret == 0L) {
                ret = this.id.requesterId - o.id.requesterId;
            }
            if (ret < 0L) {
                return -1;
            }
            if (ret > 0L) {
                return 1;
            }
            return 0;
        }

        public void setElapsedTimeNS(long time) {
            this.elapsedTimeNS = time;
        }

        public long getElapsedTimeNS() {
            return this.elapsedTimeNS;
        }
    }
}

