/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.nio.ChannelOpener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

class FileChannelWriteOpener
implements ChannelOpener {
    private final File fileToOpen;
    private FileOutputStream currentStream;
    private volatile boolean closed;

    FileChannelWriteOpener(File fileToOpen) {
        this.fileToOpen = fileToOpen;
        this.currentStream = null;
        this.closed = false;
    }

    synchronized FileChannel open() throws IOException {
        this.closed = false;
        this.currentStream = new FileOutputStream(this.fileToOpen);
        return this.currentStream.getChannel();
    }

    @Override
    public synchronized FileChannel reopen() throws IOException {
        if (this.closed) {
            throw new IOException("Channel for file " + this.fileToOpen.getName() + " cannot be reopened");
        }
        if (this.currentStream != null) {
            try {
                this.currentStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.currentStream = new FileOutputStream(this.fileToOpen);
        return this.currentStream.getChannel();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        if (this.currentStream != null) {
            try {
                this.currentStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.currentStream = null;
    }
}

