/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.flash;

import com.terracottatech.frs.flash.ReadManager;
import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.IOManager;
import com.terracottatech.frs.io.Loadable;
import com.terracottatech.frs.log.FormatException;
import com.terracottatech.frs.log.LogRecord;
import com.terracottatech.frs.log.LogRegionPacker;
import com.terracottatech.frs.log.Signature;
import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadManagerImpl
implements ReadManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadManager.class);
    private final IOManager ioManager;
    private final String forceLogRegionFormat;
    private final Cache cached = new Cache();
    private int hit;
    private int miss;

    public ReadManagerImpl(IOManager io, String forceLogRegionFormat) {
        this.ioManager = io;
        this.forceLogRegionFormat = forceLogRegionFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Chunk check(long lsn) {
        Chunk c = (Chunk)this.cached.get(lsn);
        if (c != null) {
            ++this.hit;
            long pos = c.position();
            try {
                Chunk chunk = c.getChunk(c.remaining());
                return chunk;
            }
            finally {
                c.clear();
                c.skip(pos);
            }
        }
        ++this.miss;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Chunk cache(long lsn, Chunk records) throws IOException {
        if (records == null) {
            return null;
        }
        if (records instanceof Loadable) {
            ((Loadable)((Object)records)).load();
        }
        this.cached.put(lsn, records);
        long pos = records.position();
        try {
            Chunk chunk = records.getChunk(records.remaining());
            return chunk;
        }
        finally {
            records.clear();
            records.skip(pos);
        }
    }

    @Override
    public LogRecord get(long marker) throws IOException {
        Chunk c = this.ioManager.scan(marker);
        try {
            LogRecord send = LogRegionPacker.extract(Signature.NONE, this.forceLogRegionFormat, c, marker);
            if (send == null) {
                throw new RuntimeException("not found");
            }
            LogRecord logRecord = send;
            return logRecord;
        }
        catch (FormatException form) {
            throw new IOException(form);
        }
        finally {
            if (c instanceof Closeable) {
                ((Closeable)((Object)c)).close();
            }
        }
    }

    static class Cache
    extends LinkedHashMap<Long, Chunk> {
        boolean over = false;

        public Cache() {
            super(256, 1.25f, true);
        }

        @Override
        public Chunk remove(Object key) {
            this.over = false;
            return (Chunk)super.remove(key);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, Chunk> eldest) {
            if (this.over || this.size() > 512) {
                this.over = true;
                if (eldest.getValue() instanceof Closeable) {
                    try {
                        ((Closeable)((Object)eldest.getValue())).close();
                    }
                    catch (IOException ioe) {
                        LOGGER.warn("error closing chunk", (Throwable)ioe);
                    }
                }
            }
            return this.over;
        }
    }
}

