/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs;

import com.terracottatech.frs.DeleteAction;
import com.terracottatech.frs.GettableAction;
import com.terracottatech.frs.NotPausedException;
import com.terracottatech.frs.PutAction;
import com.terracottatech.frs.RemoveAction;
import com.terracottatech.frs.RestartStore;
import com.terracottatech.frs.RestartStoreException;
import com.terracottatech.frs.Snapshot;
import com.terracottatech.frs.Statistics;
import com.terracottatech.frs.Transaction;
import com.terracottatech.frs.TransactionException;
import com.terracottatech.frs.Tuple;
import com.terracottatech.frs.action.Action;
import com.terracottatech.frs.action.ActionManager;
import com.terracottatech.frs.compaction.Compactor;
import com.terracottatech.frs.compaction.CompactorImpl;
import com.terracottatech.frs.config.Configuration;
import com.terracottatech.frs.config.FrsProperty;
import com.terracottatech.frs.flash.ReadManager;
import com.terracottatech.frs.io.IOManager;
import com.terracottatech.frs.io.IOStatistics;
import com.terracottatech.frs.log.LogManager;
import com.terracottatech.frs.log.LogRecord;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.recovery.RecoveryException;
import com.terracottatech.frs.recovery.RecoveryListener;
import com.terracottatech.frs.recovery.RecoveryManagerImpl;
import com.terracottatech.frs.transaction.TransactionHandle;
import com.terracottatech.frs.transaction.TransactionManager;
import com.terracottatech.frs.util.NullFuture;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartStoreImpl
implements RestartStore<ByteBuffer, ByteBuffer, ByteBuffer>,
RecoveryListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestartStoreImpl.class);
    private final ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager;
    private final TransactionManager transactionManager;
    private final Compactor compactor;
    private final LogManager logManager;
    private final ActionManager actionManager;
    private final ReadManager readManager;
    private final Configuration configuration;
    private final int maxPauseTime;
    private final ExecutorService pauseTaskExecutorService;
    private final ScheduledExecutorService pauseTimeOutService;
    private volatile Future<Future<Snapshot>> pauseTaskRef;
    private volatile Future<Future<Void>> shutdownTaskRef;
    private volatile ScheduledFuture<?> pauseTimerTaskRef;
    private volatile State state;
    private volatile State prevState;

    RestartStoreImpl(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, TransactionManager transactionManager, LogManager logManager, ActionManager actionManager, ReadManager read, Compactor compactor, Configuration configuration) {
        this.prevState = this.state = State.INIT;
        this.transactionManager = transactionManager;
        this.objectManager = objectManager;
        this.logManager = logManager;
        this.actionManager = actionManager;
        this.readManager = read;
        this.compactor = compactor;
        this.configuration = configuration;
        this.pauseTaskExecutorService = Executors.newSingleThreadExecutor();
        this.pauseTimeOutService = Executors.newSingleThreadScheduledExecutor();
        this.maxPauseTime = configuration.getInt(FrsProperty.STORE_MAX_PAUSE_TIME_IN_MILLIS);
    }

    public RestartStoreImpl(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, TransactionManager transactionManager, LogManager logManager, ActionManager actionManager, ReadManager read, IOManager ioManager, Configuration configuration) throws RestartStoreException {
        this(objectManager, transactionManager, logManager, actionManager, read, new CompactorImpl(objectManager, transactionManager, logManager, ioManager, configuration, actionManager), configuration);
    }

    @Override
    public synchronized Future<Void> startup() throws InterruptedException, RecoveryException {
        while (this.state != State.INIT) {
            if (this.state == State.FROZEN) {
                LOGGER.warn("FRS Store is frozen. Waiting for a shutdown or resume");
                this.wait();
                continue;
            }
            throw new IllegalStateException("Can't startup from state " + (Object)((Object)this.state));
        }
        this.state = State.RECOVERING;
        RecoveryManagerImpl recoveryManager = new RecoveryManagerImpl(this.logManager, this.actionManager, this.configuration);
        return recoveryManager.recover(this);
    }

    @Override
    public synchronized void recovered() throws InterruptedException {
        while (this.state == State.FROZEN) {
            LOGGER.warn("FRS Store is frozen. Waiting for a shutdown or resume");
            this.wait();
        }
        if (this.state == State.RECOVERING) {
            this.compactor.startup();
            this.state = State.RUNNING;
        }
    }

    @Override
    public synchronized void shutdown() throws InterruptedException {
        if (this.state != State.SHUTDOWN) {
            this.state = State.SHUTDOWN;
            this.compactor.shutdown();
            this.logManager.shutdown();
        }
    }

    @Override
    public Transaction<ByteBuffer, ByteBuffer, ByteBuffer> beginTransaction(boolean synchronous) {
        this.checkReadyState();
        return new TransactionImpl(synchronous);
    }

    @Override
    public Transaction<ByteBuffer, ByteBuffer, ByteBuffer> beginAutoCommitTransaction(boolean synchronous) {
        this.checkReadyState();
        return new AutoCommitTransaction(synchronous);
    }

    @Override
    public Tuple<ByteBuffer, ByteBuffer, ByteBuffer> get(long marker) {
        try {
            LogRecord c = this.readManager.get(marker);
            if (c == null) {
                return null;
            }
            Action a = this.actionManager.extract(c);
            if (a instanceof GettableAction) {
                return (GettableAction)a;
            }
            throw new IllegalArgumentException("action is not a gettable event");
        }
        catch (InterruptedIOException ioe) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (IOException ioe) {
            throw new RuntimeException("unrecoverable", ioe);
        }
    }

    @Override
    public synchronized Snapshot snapshot() throws RestartStoreException {
        this.checkReadyState();
        this.compactor.pause();
        try {
            Snapshot snapshot = this.logManager.snapshot();
            return snapshot;
        }
        catch (Exception e) {
            throw new RestartStoreException(e);
        }
        finally {
            this.compactor.unpause();
        }
    }

    @Override
    public Statistics getStatistics() {
        return new Statistics(){
            private final IOStatistics delegate;
            {
                this.delegate = RestartStoreImpl.this.logManager.getIOStatistics();
            }

            @Override
            public long getTotalAvailable() {
                return this.delegate.getTotalAvailable();
            }

            @Override
            public long getTotalUsed() {
                return this.delegate.getTotalUsed();
            }

            @Override
            public long getTotalWritten() {
                return this.delegate.getTotalWritten();
            }

            @Override
            public long getTotalRead() {
                return this.delegate.getTotalRead();
            }

            @Override
            public long getLiveSize() {
                return this.delegate.getLiveSize();
            }

            @Override
            public long getExpiredSize() {
                return this.delegate.getExpiredSize();
            }
        };
    }

    @Override
    public synchronized Future<Future<Snapshot>> pause() {
        if (this.state == State.PAUSED) {
            return this.pauseTaskRef;
        }
        if (this.state != State.RUNNING) {
            throw new IllegalStateException("RestartStore is not ready for pause. Current state " + (Object)((Object)this.state));
        }
        this.state = State.PAUSED;
        this.pauseTimerTaskRef = this.pauseTimeOutService.schedule(new Runnable(){

            @Override
            public void run() {
                RestartStoreImpl.this.forceResume();
            }
        }, (long)this.maxPauseTime, TimeUnit.MILLISECONDS);
        this.pauseTaskRef = this.pauseTaskExecutorService.submit(new Callable<Future<Snapshot>>(){

            @Override
            public Future<Snapshot> call() throws Exception {
                RestartStoreImpl.this.compactor.pause();
                RestartStoreImpl.this.actionManager.pause();
                return new OuterSnapshotFuture(RestartStoreImpl.this.logManager.snapshotAsync());
            }
        });
        return this.pauseTaskRef;
    }

    @Override
    public synchronized void resume() throws NotPausedException {
        if (this.state != State.PAUSED && this.state != State.FROZEN) {
            throw new NotPausedException("Restart store is currently not paused");
        }
        if (this.state == State.PAUSED) {
            if (!this.pauseTaskRef.isDone()) {
                throw new IllegalStateException("Pause task is still running. This is unexpected");
            }
            this.pauseTimerTaskRef.cancel(true);
        }
        this.pauseTaskRef = null;
        this.pauseTimerTaskRef = null;
        this.shutdownTaskRef = null;
        if (this.state != State.FROZEN || this.prevState == State.RUNNING) {
            if (this.state == State.FROZEN) {
                this.compactor.unpause();
            }
            this.actionManager.resume();
            this.state = State.RUNNING;
        } else {
            this.state = this.prevState;
            this.notifyAll();
        }
    }

    @Override
    public synchronized Future<Future<Void>> freeze() {
        if (this.shutdownTaskRef != null) {
            return this.shutdownTaskRef;
        }
        if (this.state == State.PAUSED) {
            throw new IllegalStateException("RestartStore is not ready for freeze. Snapshot may be in progress");
        }
        this.prevState = this.state;
        this.state = State.FROZEN;
        if (this.prevState != State.RUNNING) {
            this.shutdownTaskRef = new NullFutureFuture();
            return this.shutdownTaskRef;
        }
        this.shutdownTaskRef = this.pauseTaskExecutorService.submit(new Callable<Future<Void>>(){

            @Override
            public Future<Void> call() throws Exception {
                RestartStoreImpl.this.compactor.pause();
                RestartStoreImpl.this.actionManager.pause();
                return new OuterFreezeFuture(RestartStoreImpl.this.logManager.appendAndSync(RestartStoreImpl.this.actionManager.barrierAction()));
            }
        });
        return this.shutdownTaskRef;
    }

    private synchronized void forceResume() {
        if (this.state != State.PAUSED) {
            return;
        }
        this.compactor.unpause();
        this.actionManager.resume();
        this.pauseTaskRef.cancel(true);
        this.pauseTaskRef = null;
        this.pauseTimerTaskRef = null;
        this.state = State.RUNNING;
    }

    private void checkReadyState() {
        if (this.isNotInReadyState(this.state) && (this.state != State.FROZEN || this.isNotInReadyState(this.prevState))) {
            throw new IllegalStateException("RestartStore is not ready for mutations. Current state " + (Object)((Object)(this.state == State.FROZEN ? this.prevState : this.state)));
        }
    }

    private boolean isNotInReadyState(State stateToCheck) {
        return stateToCheck != State.RUNNING && stateToCheck != State.RECOVERING && stateToCheck != State.PAUSED;
    }

    private boolean isRecovering() {
        return this.state == State.RECOVERING || this.state == State.FROZEN && this.prevState == State.RECOVERING;
    }

    private static class OuterSnapshot
    implements Snapshot {
        private final Snapshot inner;
        private final Compactor compactor;

        public OuterSnapshot(Snapshot inner, Compactor compactor) {
            this.inner = inner;
            this.compactor = compactor;
        }

        @Override
        public void close() throws IOException {
            this.compactor.unpause();
            this.inner.close();
        }

        @Override
        public Iterator<File> iterator() {
            return this.inner.iterator();
        }
    }

    private class OuterSnapshotFuture
    implements Future<Snapshot> {
        private final Future<Snapshot> innerSnapshot;

        private OuterSnapshotFuture(Future<Snapshot> innerSnapshot) {
            this.innerSnapshot = innerSnapshot;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException("Not yet supported.");
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.innerSnapshot.isDone();
        }

        @Override
        public Snapshot get() throws InterruptedException, ExecutionException {
            Snapshot inner = this.innerSnapshot.get();
            return new OuterSnapshot(inner, RestartStoreImpl.this.compactor);
        }

        @Override
        public Snapshot get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Snapshot inner = this.innerSnapshot.get(timeout, unit);
            return inner != null ? new OuterSnapshot(inner, RestartStoreImpl.this.compactor) : null;
        }
    }

    private class OuterFreezeFuture
    implements Future<Void> {
        private final Future<Void> innerFreezeMarker;

        private OuterFreezeFuture(Future<Void> innerFreezeMarker) {
            this.innerFreezeMarker = innerFreezeMarker;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException("Not yet supported.");
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.innerFreezeMarker.isDone();
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            return this.innerFreezeMarker.get();
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.innerFreezeMarker.get(timeout, unit);
        }
    }

    private class TransactionImpl
    implements Transaction<ByteBuffer, ByteBuffer, ByteBuffer> {
        private final boolean synchronous;
        private final TransactionHandle handle;
        private boolean committed = false;

        TransactionImpl(boolean synchronous) {
            this.handle = RestartStoreImpl.this.transactionManager.begin();
            this.synchronous = synchronous;
        }

        @Override
        public synchronized Transaction<ByteBuffer, ByteBuffer, ByteBuffer> put(ByteBuffer id, ByteBuffer key, ByteBuffer value) {
            RestartStoreImpl.this.checkReadyState();
            this.checkCommitted();
            RestartStoreImpl.this.transactionManager.happened(this.handle, new PutAction((ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer>)RestartStoreImpl.this.objectManager, RestartStoreImpl.this.compactor, id, key, value, RestartStoreImpl.this.isRecovering()));
            return this;
        }

        @Override
        public synchronized Transaction<ByteBuffer, ByteBuffer, ByteBuffer> delete(ByteBuffer id) {
            RestartStoreImpl.this.checkReadyState();
            this.checkCommitted();
            RestartStoreImpl.this.transactionManager.happened(this.handle, new DeleteAction(RestartStoreImpl.this.objectManager, RestartStoreImpl.this.compactor, id, RestartStoreImpl.this.isRecovering()));
            return this;
        }

        @Override
        public synchronized Transaction<ByteBuffer, ByteBuffer, ByteBuffer> remove(ByteBuffer id, ByteBuffer key) {
            RestartStoreImpl.this.checkReadyState();
            this.checkCommitted();
            RestartStoreImpl.this.transactionManager.happened(this.handle, new RemoveAction(RestartStoreImpl.this.objectManager, RestartStoreImpl.this.compactor, id, key, RestartStoreImpl.this.isRecovering()));
            return this;
        }

        @Override
        public synchronized void commit() throws TransactionException {
            RestartStoreImpl.this.checkReadyState();
            this.checkCommitted();
            RestartStoreImpl.this.transactionManager.commit(this.handle, this.synchronous);
            this.committed = true;
        }

        private void checkCommitted() {
            if (this.committed) {
                throw new IllegalStateException("Transaction is already committed.");
            }
        }
    }

    private class AutoCommitTransaction
    implements Transaction<ByteBuffer, ByteBuffer, ByteBuffer> {
        private final boolean synchronous;

        private AutoCommitTransaction(boolean synchronous) {
            this.synchronous = synchronous;
        }

        private void happened(Action action) throws TransactionException {
            if (this.synchronous) {
                boolean interrupted = false;
                Future<Void> written = RestartStoreImpl.this.actionManager.syncHappened(action);
                while (true) {
                    try {
                        written.get();
                    }
                    catch (ExecutionException e) {
                        throw new TransactionException(e);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            } else {
                RestartStoreImpl.this.actionManager.happened(action);
            }
        }

        @Override
        public Transaction<ByteBuffer, ByteBuffer, ByteBuffer> put(ByteBuffer id, ByteBuffer key, ByteBuffer value) throws TransactionException {
            RestartStoreImpl.this.checkReadyState();
            this.happened(new PutAction((ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer>)RestartStoreImpl.this.objectManager, RestartStoreImpl.this.compactor, id, key, value, RestartStoreImpl.this.isRecovering()));
            return this;
        }

        @Override
        public Transaction<ByteBuffer, ByteBuffer, ByteBuffer> delete(ByteBuffer id) throws TransactionException {
            RestartStoreImpl.this.checkReadyState();
            this.happened(new DeleteAction(RestartStoreImpl.this.objectManager, RestartStoreImpl.this.compactor, id, RestartStoreImpl.this.isRecovering()));
            return this;
        }

        @Override
        public Transaction<ByteBuffer, ByteBuffer, ByteBuffer> remove(ByteBuffer id, ByteBuffer key) throws TransactionException {
            RestartStoreImpl.this.checkReadyState();
            this.happened(new RemoveAction(RestartStoreImpl.this.objectManager, RestartStoreImpl.this.compactor, id, key, RestartStoreImpl.this.isRecovering()));
            return this;
        }

        @Override
        public void commit() throws TransactionException {
        }
    }

    private class NullFutureFuture
    implements Future<Future<Void>> {
        private NullFutureFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public Future<Void> get() throws InterruptedException, ExecutionException {
            return new NullFuture();
        }

        @Override
        public Future<Void> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return new NullFuture();
        }
    }

    private static enum State {
        INIT,
        RECOVERING,
        RUNNING,
        SHUTDOWN,
        PAUSED,
        FROZEN;

    }
}

