/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs;

import com.terracottatech.frs.RestartStore;
import com.terracottatech.frs.RestartStoreFactory;
import com.terracottatech.frs.Transaction;
import com.terracottatech.frs.TransactionException;
import com.terracottatech.frs.config.FrsProperty;
import com.terracottatech.frs.object.NullObjectManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Properties;

public class OfflineCompactor {
    private final File in;
    private final File out;

    public OfflineCompactor(File in, File out) {
        this.in = in;
        this.out = out;
    }

    public void compact() throws Exception {
        if (!this.in.isDirectory()) {
            throw new IOException("Input folder " + this.in + " is not a directory.");
        }
        this.initOutputDirectory();
        Properties properties = new Properties();
        properties.setProperty(FrsProperty.COMPACTOR_POLICY.shortName(), "NoCompactionPolicy");
        properties.setProperty(FrsProperty.IO_NIO_ACCESS_METHOD.shortName(), "MAPPED");
        properties.setProperty(FrsProperty.IO_NIO_POOL_MEMORY_SIZE.shortName(), Long.toString(0x20000000L));
        RestartStore<ByteBuffer, ByteBuffer, ByteBuffer> outputStore = RestartStoreFactory.createStore(new NullObjectManager<ByteBuffer, ByteBuffer, ByteBuffer>(), this.out, properties);
        outputStore.startup().get();
        ForwardingObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager = new ForwardingObjectManager<ByteBuffer, ByteBuffer, ByteBuffer>(outputStore);
        RestartStore<ByteBuffer, ByteBuffer, ByteBuffer> inputStore = RestartStoreFactory.createStore(objectManager, this.in, properties);
        inputStore.startup().get();
        inputStore.shutdown();
        outputStore.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOutputDirectory() throws IOException {
        if (this.out.exists()) {
            throw new IOException("Output directory " + this.out + " already exists.");
        }
        if (!this.out.mkdirs()) {
            throw new IOException("Failed to created output directory " + this.out);
        }
        File userPropertiesFile = new File(this.in, "frs.properties");
        if (userPropertiesFile.exists()) {
            Properties userProperties = new Properties();
            try (FileInputStream fis = new FileInputStream(userPropertiesFile);){
                userProperties.load(fis);
            }
            File compactedUserPropertiesFile = new File(this.out, "frs.properties");
            try (FileOutputStream fos = new FileOutputStream(compactedUserPropertiesFile);){
                userProperties.store(fos, null);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: java com.terracottatech.frs.OfflineCompactor inputFolder outputFolder");
            System.exit(1);
        }
        File inputFile = new File(args[0]);
        File outputFile = new File(args[1]);
        System.out.println("Starting compaction.");
        new OfflineCompactor(inputFile, outputFile).compact();
        System.out.println("Compaction completed successfully.");
    }

    private static class ForwardingObjectManager<I, K, V>
    extends NullObjectManager<I, K, V> {
        private final Transaction<I, K, V> transaction;

        private ForwardingObjectManager(RestartStore<I, K, V> backingStore) {
            this.transaction = backingStore.beginAutoCommitTransaction(false);
        }

        @Override
        public long getLsn(I id, K key) {
            return -1L;
        }

        @Override
        public void replayPut(I id, K key, V value, long lsn) {
            try {
                this.transaction.put(id, key, value);
            }
            catch (TransactionException e) {
                throw new RuntimeException("Failed to play back put.", e);
            }
        }
    }
}

