/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.store;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.terracotta.shaded.lucene.store.Directory;
import org.terracotta.shaded.lucene.store.FilterDirectory;
import org.terracotta.shaded.lucene.store.IOContext;
import org.terracotta.shaded.lucene.store.IndexOutput;

public final class TrackingDirectoryWrapper
extends FilterDirectory {
    private final Set<String> createdFileNames = Collections.synchronizedSet(new HashSet());

    public TrackingDirectoryWrapper(Directory in) {
        super(in);
    }

    @Override
    public void deleteFile(String name) throws IOException {
        this.createdFileNames.remove(name);
        this.in.deleteFile(name);
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.createdFileNames.add(name);
        return this.in.createOutput(name, context);
    }

    @Override
    public void copy(Directory to, String src, String dest, IOContext context) throws IOException {
        this.createdFileNames.add(dest);
        this.in.copy(to, src, dest, context);
    }

    @Override
    public Directory.IndexInputSlicer createSlicer(String name, IOContext context) throws IOException {
        return this.in.createSlicer(name, context);
    }

    public Set<String> getCreatedFiles() {
        return this.createdFileNames;
    }
}

