/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.license.constraints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.terracotta.license.License;
import org.terracotta.license.LicenseException;
import org.terracotta.license.constraints.LicenseConstraint;
import org.terracotta.license.constraints.RequiredFieldConstraint;

public class LicenseContraintsFactory {
    public static List<LicenseConstraint> getAllContraints(License license) {
        ArrayList<LicenseConstraint> contraints = new ArrayList<LicenseConstraint>();
        contraints.add(new RequiredFieldConstraint(license.getProperties()));
        List<String> terracottaCapabilities = Arrays.asList("authentication", "server striping", "sessions", "server array offheap");
        contraints.add(new TerracottaAndClientCountContraint(license, terracottaCapabilities));
        return contraints;
    }

    static class TerracottaAndClientCountContraint
    implements LicenseConstraint {
        private final License license;
        private final List<String> terracottaCapabilities;

        public TerracottaAndClientCountContraint(License license, List<String> terracottaCapabilities) {
            this.license = license;
            this.terracottaCapabilities = terracottaCapabilities;
        }

        @Override
        public void verify() {
            boolean tcEnabled = false;
            String terracottaCapability = null;
            Set<String> currentCapabilities = this.license.capabilities();
            for (String capability : this.terracottaCapabilities) {
                if (!currentCapabilities.contains(capability)) continue;
                tcEnabled = true;
                terracottaCapability = capability;
            }
            int maxClientCount = this.license.maxClientCount();
            if (tcEnabled && maxClientCount <= 0) {
                throw new LicenseException("Terracotta capability '" + terracottaCapability + "' is enabled therefore \nfield '" + "Max Client Count" + "' must have non-zero value");
            }
        }
    }
}

