/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.writer.writebehind;

import java.io.Serializable;
import java.nio.ByteBuffer;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.store.offheap.portability.EhcacheElementPortability;
import net.sf.ehcache.writer.writebehind.operations.DeleteOperation;
import net.sf.ehcache.writer.writebehind.operations.SingleOperation;
import net.sf.ehcache.writer.writebehind.operations.WriteOperation;
import org.terracotta.offheapstore.storage.portability.Portability;
import org.terracotta.offheapstore.storage.portability.SerializablePortability;

public class SingleOperationPortability
implements Portability<SingleOperation> {
    private static final byte DELETE_WITH_ELEMENT = 0;
    private static final byte DELETE_WITHOUT_ELEMENT = 1;
    private static final byte WRITE = 2;
    private static final int SINGLE_OPERATION_HEADER_SIZE = 9;
    private final SerializablePortability serializablePortability;
    private final EhcacheElementPortability elementPortability;

    public SingleOperationPortability(CacheConfiguration config, SerializablePortability serializablePortability) {
        this.serializablePortability = serializablePortability;
        this.elementPortability = new EhcacheElementPortability(serializablePortability, config);
    }

    @Override
    public ByteBuffer encode(SingleOperation object) {
        if (object instanceof DeleteOperation) {
            DeleteOperation deleteOperation = (DeleteOperation)object;
            ByteBuffer keyBuffer = this.serializablePortability.encode((Serializable)deleteOperation.getKey());
            if (deleteOperation.getEntry().getElement() != null) {
                ByteBuffer elementBuffer = this.elementPortability.encode(deleteOperation.getEntry().getElement());
                ByteBuffer encoded = ByteBuffer.allocate(keyBuffer.remaining() + elementBuffer.remaining() + 9);
                encoded.put((byte)0);
                encoded.putLong(deleteOperation.getCreationTime());
                encoded.put(keyBuffer);
                encoded.put(elementBuffer);
                encoded.flip();
                return encoded;
            }
            ByteBuffer encoded = ByteBuffer.allocate(keyBuffer.remaining() + 9);
            encoded.put((byte)1);
            encoded.putLong(deleteOperation.getCreationTime());
            encoded.put(keyBuffer);
            encoded.flip();
            return encoded;
        }
        if (object instanceof WriteOperation) {
            ByteBuffer elementBuffer = this.elementPortability.encode(((WriteOperation)object).getElement());
            ByteBuffer encoded = ByteBuffer.allocate(elementBuffer.remaining() + 9);
            encoded.put((byte)2);
            encoded.putLong(object.getCreationTime());
            encoded.put(elementBuffer);
            encoded.flip();
            return encoded;
        }
        throw new IllegalArgumentException("Unknown SingleOperation type " + object);
    }

    @Override
    public SingleOperation decode(ByteBuffer buffer) {
        ByteBuffer readOnly = buffer.asReadOnlyBuffer();
        byte type = readOnly.get();
        long creationTime = readOnly.getLong();
        switch (type) {
            case 0: {
                Serializable key = this.serializablePortability.decode(readOnly);
                Element e = this.elementPortability.decode(readOnly);
                return new DeleteOperation(new CacheEntry(key, e), creationTime);
            }
            case 1: {
                return new DeleteOperation(new CacheEntry(this.serializablePortability.decode(readOnly), null), creationTime);
            }
            case 2: {
                return new WriteOperation(this.elementPortability.decode(readOnly), creationTime);
            }
        }
        throw new IllegalArgumentException("Unknown SingleOperation type " + type);
    }

    @Override
    public boolean equals(Object object, ByteBuffer buffer) {
        return this.decode(buffer).equals(object);
    }
}

