/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.writer.writebehind;

import com.terracottatech.frs.RestartStore;
import com.terracottatech.frs.object.ObjectManagerStripe;
import com.terracottatech.frs.object.RestartableObject;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.store.restartability.EhcacheRestartability;
import net.sf.ehcache.store.restartability.RestartableQueue;
import net.sf.ehcache.writer.writebehind.AbstractWriteBehindQueue;
import net.sf.ehcache.writer.writebehind.SingleOperationPortability;
import net.sf.ehcache.writer.writebehind.operations.SingleOperation;
import org.terracotta.offheapstore.storage.portability.Portability;
import org.terracotta.offheapstore.storage.portability.SerializablePortability;

public class RestartableWriteBehindQueue
extends AbstractWriteBehindQueue
implements RestartableObject<ByteBuffer, ByteBuffer, ByteBuffer> {
    private final RestartableWriteBehindQueueBackend backend;

    public RestartableWriteBehindQueue(CacheConfiguration config, int id, RestartStore<ByteBuffer, ByteBuffer, ByteBuffer> cacheStore, SerializablePortability serializablePortability) {
        super(config);
        this.backend = new RestartableWriteBehindQueueBackend(RestartableWriteBehindQueue.createId(config.getName(), id), cacheStore, RestartableWriteBehindQueue.createPortability(config, serializablePortability), config.getPersistenceConfiguration().getSynchronousWrites());
    }

    public RestartableWriteBehindQueue(CacheConfiguration config, int id, EhcacheRestartability ehcacheRestartability) {
        this(config, id, ehcacheRestartability.getCacheStore(), ehcacheRestartability.getRestartablePortability());
        ehcacheRestartability.registerRestartableCacheObject(this);
    }

    @Override
    protected List<SingleOperation> quarantineItems() {
        return this.backend.getListView();
    }

    @Override
    protected void addItem(SingleOperation operation) {
        this.backend.add(operation);
    }

    @Override
    public long getQueueSize() {
        return this.backend.size();
    }

    @Override
    public ObjectManagerStripe<ByteBuffer, ByteBuffer, ByteBuffer> getObjectManagerStripe() {
        return this.backend.getObjectManagerStripe();
    }

    @Override
    public ByteBuffer getId() {
        return this.backend.getId();
    }

    @Override
    protected void reinsertUnprocessedItems(List<SingleOperation> operations) {
    }

    private static Portability<SingleOperation> createPortability(CacheConfiguration cacheConfiguration, SerializablePortability serializablePortability) {
        return new SingleOperationPortability(cacheConfiguration, serializablePortability);
    }

    private static ByteBuffer createId(String cacheName, int id) {
        return EhcacheRestartability.getWriteBehindIdentifier(cacheName, id);
    }

    private class RestartableWriteBehindQueueBackend
    extends RestartableQueue<SingleOperation> {
        public RestartableWriteBehindQueueBackend(ByteBuffer id, RestartStore<ByteBuffer, ByteBuffer, ByteBuffer> restartability, Portability<SingleOperation> portability, boolean synchronous) {
            super(id, restartability, portability, synchronous);
        }

        private List<SingleOperation> getListView() {
            return new ListView();
        }

        private class ListView
        extends AbstractList<SingleOperation> {
            private List<Long> modList = new ArrayList<Long>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private ListView() {
                RestartableWriteBehindQueueBackend.this.readLock().lock();
                try {
                    Iterator modIterator = RestartableWriteBehindQueueBackend.this.modIterator();
                    while (modIterator.hasNext()) {
                        Long mod = (Long)modIterator.next();
                        assert (mod != null);
                        this.modList.add(mod);
                    }
                }
                finally {
                    RestartableWriteBehindQueueBackend.this.readLock().unlock();
                }
            }

            @Override
            public SingleOperation get(int index) {
                RestartableWriteBehindQueueBackend.this.readLock().lock();
                try {
                    SingleOperation singleOperation = (SingleOperation)RestartableWriteBehindQueueBackend.this.getValue(this.modList.get(index));
                    return singleOperation;
                }
                finally {
                    RestartableWriteBehindQueueBackend.this.readLock().unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SingleOperation remove(int index) {
                RestartableWriteBehindQueueBackend.this.writeLock().lock();
                try {
                    ++this.modCount;
                    long mod = this.modList.remove(index);
                    SingleOperation singleOperation = (SingleOperation)RestartableWriteBehindQueueBackend.this.removeValue(mod);
                    return singleOperation;
                }
                finally {
                    RestartableWriteBehindQueueBackend.this.writeLock().unlock();
                }
            }

            @Override
            public int size() {
                return this.modList.size();
            }
        }
    }
}

