/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.restartability;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.xa.Xid;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.store.restartability.EhcacheRestartability;
import net.sf.ehcache.store.restartability.EhcacheRestartableMap;
import net.sf.ehcache.transaction.AbstractTransactionIDFactory;
import net.sf.ehcache.transaction.Decision;
import net.sf.ehcache.transaction.ExpiredTransactionIDImpl;
import net.sf.ehcache.transaction.TransactionID;
import net.sf.ehcache.transaction.TransactionIDImpl;
import net.sf.ehcache.transaction.TransactionIDSerializedForm;
import net.sf.ehcache.transaction.XidTransactionIDSerializedForm;
import net.sf.ehcache.transaction.xa.ExpiredXidTransactionIDImpl;
import net.sf.ehcache.transaction.xa.XidTransactionID;
import net.sf.ehcache.transaction.xa.XidTransactionIDImpl;
import org.terracotta.offheapstore.storage.portability.Portability;

public class RestartableTransactionIDFactory
extends AbstractTransactionIDFactory {
    private final ConcurrentMap<TransactionID, Decision> transactionStates;

    public RestartableTransactionIDFactory(EhcacheRestartability restartability) {
        this.transactionStates = new RestartableTransactionMap(restartability);
    }

    @Override
    public TransactionID createTransactionID() {
        TransactionIDImpl id;
        do {
            id = new TransactionIDImpl();
        } while (this.getTransactionStates().putIfAbsent(id, Decision.IN_DOUBT) != null);
        return id;
    }

    @Override
    public TransactionID restoreTransactionID(TransactionIDSerializedForm serializedForm) {
        throw new UnsupportedOperationException("unclustered transaction IDs are directly deserializable!");
    }

    @Override
    public XidTransactionID createXidTransactionID(Xid xid, Ehcache cache) {
        XidTransactionIDImpl id = new XidTransactionIDImpl(xid, cache.getName());
        this.getTransactionStates().putIfAbsent(id, Decision.IN_DOUBT);
        return id;
    }

    @Override
    public XidTransactionID restoreXidTransactionID(XidTransactionIDSerializedForm serializedForm) {
        throw new UnsupportedOperationException("unclustered transaction IDs are directly deserializable!");
    }

    @Override
    protected ConcurrentMap<TransactionID, Decision> getTransactionStates() {
        return this.transactionStates;
    }

    @Override
    public Boolean isPersistent() {
        return Boolean.TRUE;
    }

    @Override
    public boolean isExpired(TransactionID transactionID) {
        return transactionID instanceof ExpiredTransactionIDImpl || transactionID instanceof ExpiredXidTransactionIDImpl;
    }

    static class RestartableTransactionMap
    extends EhcacheRestartableMap<TransactionID, Decision, ByteBuffer, ByteBuffer, ByteBuffer> {
        private final Portability<? super Serializable> portability;

        RestartableTransactionMap(EhcacheRestartability restartability) {
            super(EhcacheRestartability.getTransactionsIdentifier(), restartability.getCacheStore());
            this.portability = restartability.getRestartablePortability();
            restartability.registerRestartableCacheObject(this);
        }

        @Override
        protected ByteBuffer encodeKey(TransactionID key) {
            return this.portability.encode(key);
        }

        @Override
        protected ByteBuffer encodeValue(Decision value) {
            return this.portability.encode((Serializable)((Object)value));
        }

        @Override
        protected TransactionID decodeKey(ByteBuffer rKey) {
            return (TransactionID)this.portability.decode(rKey.duplicate());
        }

        @Override
        protected Decision decodeValue(ByteBuffer rValue) {
            return (Decision)((Object)this.portability.decode(rValue.duplicate()));
        }

        @Override
        protected void replayPut(TransactionID key, Decision value) {
            if (key instanceof XidTransactionID) {
                super.replayPut(new ExpiredXidTransactionIDImpl((XidTransactionID)key), value);
            } else {
                super.replayPut(new ExpiredTransactionIDImpl((TransactionIDImpl)key), value);
            }
        }

        @Override
        protected long keyByteSize(TransactionID key, ByteBuffer encodedKey) {
            return encodedKey.capacity();
        }

        @Override
        protected long valueByteSize(Decision value, ByteBuffer encodedValue) {
            return encodedValue.capacity();
        }
    }
}

