/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.restartability;

import com.terracottatech.frs.RestartStore;
import com.terracottatech.frs.object.ObjectManagerEntry;
import com.terracottatech.frs.object.ObjectManagerSegment;
import com.terracottatech.frs.object.ObjectManagerStripe;
import com.terracottatech.frs.object.RestartableMap;
import com.terracottatech.frs.object.RestartableObject;
import java.nio.ByteBuffer;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.store.restartability.EhcacheRestartableMap;
import org.terracotta.offheapstore.storage.portability.Portability;

public class RestartableQueue<T>
extends AbstractQueue<T>
implements RestartableObject<ByteBuffer, ByteBuffer, ByteBuffer> {
    private final ByteBuffer id;
    private final RestartableMap<Long, T, ByteBuffer, ByteBuffer, ByteBuffer> backend;
    private final ObjectManagerStripe<ByteBuffer, ByteBuffer, ByteBuffer> objectManagerStripe;
    private final SortedSet<Long> modSet = new TreeSet<Long>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile long modCount = 0L;

    public RestartableQueue(ByteBuffer id, RestartStore<ByteBuffer, ByteBuffer, ByteBuffer> restartability, Portability<T> portability) {
        this(id, restartability, portability, true);
    }

    public RestartableQueue(ByteBuffer id, RestartStore<ByteBuffer, ByteBuffer, ByteBuffer> restartability, Portability<T> portability, boolean synchronous) {
        this.id = id;
        this.backend = new RestartableQueueBackend(id, restartability, portability, synchronous);
        this.objectManagerStripe = new RestartableQueueObjectManagerStripe(this.backend.getObjectManagerStripe());
    }

    @Override
    public ByteBuffer getId() {
        return this.id;
    }

    @Override
    public ObjectManagerStripe<ByteBuffer, ByteBuffer, ByteBuffer> getObjectManagerStripe() {
        return this.objectManagerStripe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(T item) {
        this.writeLock().lock();
        try {
            long itemModCount = this.modCount++;
            this.modSet.add(itemModCount);
            this.backend.put(itemModCount, item);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    @Override
    public T peek() {
        this.readLock().lock();
        try {
            if (this.modSet.isEmpty()) {
                T t = null;
                return t;
            }
            T t = this.getValue(this.modSet.first());
            return t;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T poll() {
        this.writeLock().lock();
        try {
            if (this.modSet.isEmpty()) {
                T t = null;
                return t;
            }
            long mod = this.modSet.first();
            this.modSet.remove(mod);
            T t = this.removeValue(mod);
            return t;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new RestartableQueueIterator();
    }

    @Override
    public int size() {
        this.readLock().lock();
        try {
            int n = this.modSet.size();
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    protected final Iterator<Long> modIterator() {
        this.readLock().lock();
        try {
            Iterator<Long> iterator = this.modSet.iterator();
            return iterator;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final T getValue(long mod) {
        this.readLock().lock();
        try {
            T t = this.backend.get(mod);
            return t;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final T removeValue(long mod) {
        this.writeLock().lock();
        try {
            ++this.modCount;
            this.modSet.remove(mod);
            T t = this.backend.remove(mod);
            return t;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    protected Lock writeLock() {
        return this.lock.writeLock();
    }

    protected Lock readLock() {
        return this.lock.readLock();
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.modSet.clear();
            this.backend.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long decodeKey(ByteBuffer buf) {
        int p = buf.position();
        try {
            long l = buf.getLong();
            return l;
        }
        finally {
            buf.position(p);
        }
    }

    private class RestartableQueueObjectManagerStripe
    implements ObjectManagerStripe<ByteBuffer, ByteBuffer, ByteBuffer> {
        private final ObjectManagerStripe<ByteBuffer, ByteBuffer, ByteBuffer> delegate;

        RestartableQueueObjectManagerStripe(ObjectManagerStripe<ByteBuffer, ByteBuffer, ByteBuffer> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Long getLowestLsn() {
            return this.delegate.getLowestLsn();
        }

        @Override
        public Long getLsn(ByteBuffer key) {
            return this.delegate.getLsn(key);
        }

        @Override
        public void put(ByteBuffer key, ByteBuffer value, long lsn) {
            this.delegate.put(key, value, lsn);
        }

        @Override
        public void remove(ByteBuffer key) {
            this.delegate.remove(key);
        }

        @Override
        public void delete() {
            this.delegate.delete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replayPut(ByteBuffer key, ByteBuffer value, long lsn) {
            RestartableQueue.this.writeLock().lock();
            try {
                this.delegate.replayPut(key, value, lsn);
                long mod = RestartableQueue.decodeKey(key);
                if (mod >= RestartableQueue.this.modCount) {
                    RestartableQueue.this.modCount = mod + 1L;
                }
                RestartableQueue.this.modSet.add(mod);
            }
            finally {
                RestartableQueue.this.writeLock().unlock();
            }
        }

        @Override
        public Collection<ObjectManagerSegment<ByteBuffer, ByteBuffer, ByteBuffer>> getSegments() {
            return this.delegate.getSegments();
        }

        @Override
        public void updateLsn(ObjectManagerEntry<ByteBuffer, ByteBuffer, ByteBuffer> entry, long newLsn) {
            this.delegate.updateLsn(entry, newLsn);
        }

        @Override
        public void releaseCompactionEntry(ObjectManagerEntry<ByteBuffer, ByteBuffer, ByteBuffer> entry) {
            this.delegate.releaseCompactionEntry(entry);
        }

        @Override
        public long size() {
            return this.delegate.size();
        }

        @Override
        public long sizeInBytes() {
            return this.delegate.sizeInBytes();
        }
    }

    private class RestartableQueueBackend
    extends EhcacheRestartableMap<Long, T, ByteBuffer, ByteBuffer, ByteBuffer> {
        private final Portability<T> portability;

        RestartableQueueBackend(ByteBuffer identifier, RestartStore<ByteBuffer, ByteBuffer, ByteBuffer> restartability, Portability<T> portability, boolean synchronous) {
            super(identifier, restartability, synchronous);
            this.portability = portability;
        }

        @Override
        protected ByteBuffer encodeKey(Long key) {
            ByteBuffer buf = ByteBuffer.allocate(8);
            buf.putLong(key).flip();
            return buf;
        }

        @Override
        protected ByteBuffer encodeValue(T value) {
            return this.portability.encode(value);
        }

        @Override
        protected Long decodeKey(ByteBuffer rKey) {
            return RestartableQueue.decodeKey(rKey);
        }

        @Override
        protected T decodeValue(ByteBuffer rValue) {
            return this.portability.decode(rValue.duplicate());
        }

        @Override
        protected long keyByteSize(Long key, ByteBuffer encodedKey) {
            return 8L;
        }

        @Override
        protected long valueByteSize(T value, ByteBuffer encodedValue) {
            return encodedValue.capacity();
        }
    }

    private class RestartableQueueIterator
    implements Iterator<T> {
        Iterator<Long> i;
        private Long lastModCount;

        private RestartableQueueIterator() {
            this.i = RestartableQueue.this.modIterator();
            this.lastModCount = null;
        }

        @Override
        public boolean hasNext() {
            RestartableQueue.this.readLock().lock();
            try {
                boolean bl = this.i.hasNext();
                return bl;
            }
            finally {
                RestartableQueue.this.readLock().unlock();
            }
        }

        @Override
        public T next() {
            RestartableQueue.this.readLock().lock();
            try {
                this.lastModCount = this.i.next();
                Object t = RestartableQueue.this.backend.get(this.lastModCount);
                return t;
            }
            finally {
                RestartableQueue.this.readLock().unlock();
            }
        }

        @Override
        public void remove() {
            RestartableQueue.this.writeLock().lock();
            try {
                this.i.remove();
                RestartableQueue.this.removeValue(this.lastModCount);
            }
            finally {
                RestartableQueue.this.writeLock().unlock();
            }
        }
    }
}

