/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.configuration;

import net.sf.ehcache.store.offheap.configuration.AdvancedConfigPropertyParser;
import net.sf.ehcache.store.offheap.configuration.ExplicitConfiguration;
import org.terracotta.offheapstore.util.DebuggingUtils;
import org.terracotta.offheapstore.util.MemoryUnit;

public class ExplicitDiskConfiguration
extends ExplicitConfiguration {
    public static ExplicitDiskConfiguration createFor(String cacheName) {
        int concurrency = (int)AdvancedConfigPropertyParser.getAdvancedMemorySizeConfigProperty("disk.concurrency", cacheName, 16L);
        int initialSegmentTableSize = (int)AdvancedConfigPropertyParser.getAdvancedMemorySizeConfigProperty("disk.initialTableSize", cacheName, 64L);
        int initialSegmentPageSize = (int)AdvancedConfigPropertyParser.getAdvancedMemorySizeConfigProperty("disk.initialPageSize", cacheName, MemoryUnit.KILOBYTES.toBytes(2L));
        return new ExplicitDiskConfiguration(concurrency, initialSegmentTableSize, initialSegmentPageSize);
    }

    public ExplicitDiskConfiguration(int concurrency, int initialSegmentTableSize, int segmentDataPageSize) {
        super(-1L, -1, -1, concurrency, initialSegmentTableSize, segmentDataPageSize);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Explicit Disk Configuration:\n");
        sb.append("Concurrency                : ").append(this.getConcurrency()).append("\n");
        sb.append("Initial Segment Table Size : ").append(DebuggingUtils.toBase2SuffixedString(this.getInitialSegmentTableSize())).append(" slots\n");
        sb.append("Segment Data Page Size     : ").append(DebuggingUtils.toBase2SuffixedString(this.getSegmentDataPageSize())).append("B\n");
        return sb.toString();
    }
}

