/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class Log2DistroBins {
    static final long ONE_SECOND = 1000000000L;
    static final long SECONDS = 60L;
    static final long MINUTES = 60L;
    static final long HOURS = 24L;
    public static final RangeLabelMaker COMMA_LONG_LABELS = new RangeLabelMaker(){

        @Override
        public String label(long val) {
            return String.format("%,d", val);
        }
    };
    public static RangeLabelMaker NANOS_LABELS = new RangeLabelMaker(){

        @Override
        public String label(long ns) {
            if (ns < TimeUnit.MILLISECONDS.toNanos(1L) - 1L) {
                return ns + "ns";
            }
            if (ns < TimeUnit.SECONDS.toNanos(1L) - 1L) {
                return TimeUnit.NANOSECONDS.toMillis(ns) + "ms";
            }
            if (ns < TimeUnit.MINUTES.toNanos(1L) - 1L) {
                return TimeUnit.NANOSECONDS.toSeconds(ns) + "sec";
            }
            if (ns < TimeUnit.HOURS.toNanos(1L) - 1L) {
                return TimeUnit.NANOSECONDS.toMinutes(ns) + "min";
            }
            if (ns < TimeUnit.DAYS.toNanos(1L) - 1L) {
                return TimeUnit.NANOSECONDS.toHours(ns) + "hours";
            }
            return "infinity";
        }
    };
    private final Counter[] bins;
    private final Counter counter;
    private final int binCount;
    private final int smallestResolutionPower;
    private RangeLabelMaker labelMaker = COMMA_LONG_LABELS;
    private static final TimeUnit[] UNIX_TIME_UNITS_IN_ORDER = new TimeUnit[]{TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES, TimeUnit.SECONDS, TimeUnit.MILLISECONDS};
    private static final String[] UNIX_TIME_UNITS_LABELS = new String[]{"d", "h", "m", "s", "ms"};

    public Log2DistroBins(RangeLabelMaker labelMaker, int smallestResolutionPower) {
        this.labelMaker = labelMaker;
        this.smallestResolutionPower = Math.min(Math.max(1, smallestResolutionPower), 63);
        this.binCount = Math.max(1, 63 - this.smallestResolutionPower);
        this.bins = new Counter[this.binCount];
        this.counter = Log2DistroBins.atomicBased();
        for (int i = 0; i < this.bins.length; ++i) {
            this.bins[i] = Log2DistroBins.atomicBased();
        }
    }

    static Counter atomicBased() {
        return new Counter(){
            AtomicLong base = new AtomicLong();

            @Override
            public void reset() {
                this.base.set(0L);
            }

            @Override
            public long longValue() {
                return this.base.get();
            }

            @Override
            public void add(long val) {
                this.base.addAndGet(val);
            }

            @Override
            public void increment() {
                this.base.incrementAndGet();
            }
        };
    }

    public RangeLabelMaker getLabelMaker() {
        return this.labelMaker;
    }

    public static Log2DistroBins sum(Log2DistroBins one, Log2DistroBins two) {
        int smallest = Math.min(one.smallestResolutionPower, two.smallestResolutionPower);
        int topPower1 = one.smallestResolutionPower + one.binCount;
        int topPower2 = two.smallestResolutionPower + two.binCount;
        int newBinCount = Math.max(topPower1, topPower2) - smallest;
        Log2DistroBins sum = new Log2DistroBins(one.getLabelMaker(), smallest);
        for (int i = 0; i < 64; ++i) {
            if (i < sum.smallestResolutionPower || i >= sum.smallestResolutionPower + sum.binCount) continue;
            int destIndex = i - sum.smallestResolutionPower;
            int sourceIndex1 = i - one.smallestResolutionPower;
            int sourceIndex2 = i - two.smallestResolutionPower;
            sum.bins[destIndex].add(one.bins[sourceIndex1].longValue());
            sum.bins[destIndex].add(two.bins[sourceIndex2].longValue());
        }
        sum.counter.add(one.counter.longValue());
        sum.counter.add(two.counter.longValue());
        return sum;
    }

    public void record(long ... values) {
        for (long v : values) {
            this.bins[this.binIndexFor(v)].increment();
            this.counter.increment();
        }
    }

    private int binIndexFor(long val) {
        int leadingZeros = 63 - Long.numberOfLeadingZeros(val);
        if ((leadingZeros = leadingZeros - this.smallestResolutionPower + 1) <= 0) {
            return 0;
        }
        return Math.min(this.bins.length - 1, leadingZeros);
    }

    public int getSmallestResolutionPower() {
        return this.smallestResolutionPower;
    }

    public String toString() {
        return this.toString(ToString.NO_RANGES_AND_ZEROS);
    }

    public String toString(ToString formatting) {
        return this.toString(formatting, this.binCounts(), this.count());
    }

    public String toString(ToString formatting, long[] binCounts, long count) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(count);
        if (!formatting.includeRanges()) {
            sb.append(" @ ");
            sb.append(this.labelMaker.label(this.maxForBin(0)));
        }
        sb.append(") [");
        boolean first = true;
        for (int i = 0; i < binCounts.length; ++i) {
            if (!formatting.includeZeros() && binCounts[i] <= 0L) continue;
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            if (formatting.includeRanges()) {
                long maxNS;
                sb.append(binCounts[i]);
                if (i == binCounts.length - 1) {
                    maxNS = this.maxForBin(i - 1);
                    sb.append(" >");
                    sb.append(this.labelMaker.label(maxNS));
                    continue;
                }
                maxNS = this.maxForBin(i);
                sb.append(" <=");
                sb.append(this.labelMaker.label(maxNS));
                continue;
            }
            sb.append(binCounts[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    public long maxForBin(int index) {
        if (index < 0 || index >= this.bins.length) {
            throw new IllegalArgumentException();
        }
        if (index >= this.bins.length - 1) {
            return Long.MAX_VALUE;
        }
        long val = 1L << index + this.smallestResolutionPower;
        return val;
    }

    public long[] binCounts() {
        long[] ret = new long[this.bins.length];
        for (int i = 0; i < this.bins.length; ++i) {
            ret[i] = this.bins[i].longValue();
        }
        return ret;
    }

    public long count() {
        return this.counter.longValue();
    }

    public int getBinCount() {
        return this.binCount;
    }

    public void sloppyReset() {
        this.counter.reset();
        for (int i = 0; i < this.bins.length; ++i) {
            this.bins[i].reset();
        }
    }

    public long minForBin(int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (index == 0) {
            return 0L;
        }
        return this.maxForBin(index - 1) + 1L;
    }

    public Log2DistroBins duplicate() {
        Log2DistroBins cp = new Log2DistroBins(this.labelMaker, this.smallestResolutionPower);
        for (int i = 0; i < this.bins.length; ++i) {
            cp.bins[i].add(this.bins[i].longValue());
        }
        cp.counter.add(this.counter.longValue());
        return cp;
    }

    public String toMultiLineString(boolean compressed) {
        int i;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("(" + this.count() + ")");
        long[] binCounts = this.binCounts();
        long sum = 0L;
        int firstNonZero = binCounts.length;
        int lastNonZero = -1;
        for (i = 0; i < binCounts.length; ++i) {
            sum += binCounts[i];
            if (binCounts[i] <= 0L) continue;
            if (i < firstNonZero) {
                firstNonZero = i;
            }
            if (i <= lastNonZero) continue;
            lastNonZero = i;
        }
        if (compressed) {
            if (firstNonZero <= lastNonZero) {
                ++lastNonZero;
            }
        } else {
            firstNonZero = 0;
            lastNonZero = binCounts.length;
        }
        for (i = firstNonZero; i < lastNonZero; ++i) {
            long maxNS = this.maxForBin(i);
            long perc = 0L;
            if (sum > 0L) {
                perc = 100L * binCounts[i] / sum;
            }
            pw.print("   (" + perc + "%) " + binCounts[i] + " <= " + this.labelMaker.label(maxNS));
            if (i + 1 >= lastNonZero) continue;
            pw.println();
        }
        pw.flush();
        return sw.toString();
    }

    public static String unixDurationMS(long durationMS) {
        return Log2DistroBins.unixDurationNS(durationMS * 1000000L);
    }

    public static String unixDurationNS(long durationNS) {
        long duration = durationNS;
        StringBuilder sb = new StringBuilder();
        boolean dirty = false;
        for (int i = 0; i < UNIX_TIME_UNITS_IN_ORDER.length; ++i) {
            TimeUnit u = UNIX_TIME_UNITS_IN_ORDER[i];
            long t = u.convert(duration, TimeUnit.NANOSECONDS);
            duration -= TimeUnit.NANOSECONDS.convert(t, u);
            if (t <= 0L && !dirty) continue;
            dirty = true;
            sb.append(t);
            sb.append(UNIX_TIME_UNITS_LABELS[i]);
        }
        return sb.toString();
    }

    public static enum ToString {
        NO_RANGES_AND_ZEROS(false, true),
        RANGES_AND_ZEROS(true, true),
        RANGES_NO_ZEROS(true, false);

        private final boolean includeRanges;
        private final boolean includeZeros;

        private ToString(boolean includeRanges, boolean includeZeros) {
            this.includeRanges = includeRanges;
            this.includeZeros = includeZeros;
        }

        public boolean includeRanges() {
            return this.includeRanges;
        }

        public boolean includeZeros() {
            return this.includeZeros;
        }
    }

    static interface Counter {
        public void reset();

        public long longValue();

        public void add(long var1);

        public void increment();
    }

    public static interface RangeLabelMaker {
        public String label(long var1);
    }
}

