/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.disk;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.pool.Size;
import net.sf.ehcache.pool.SizeOfEngine;

public class OffHeapDiskStoreSizeOfEngine
implements SizeOfEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Size sizeOf(Object key, Object value, Object container) {
        try {
            NullOutputStream nos = new NullOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream(nos);){
                oos.writeObject(container);
            }
            return new Size(nos.size(), true);
        }
        catch (IOException e) {
            throw new CacheException("error sizing objects with serialization", e);
        }
    }

    @Override
    public SizeOfEngine copyWith(int maxDepth, boolean abortWhenMaxDepthExceeded) {
        return new OffHeapDiskStoreSizeOfEngine();
    }

    static class NullOutputStream
    extends OutputStream {
        private int written = 0;

        NullOutputStream() {
        }

        @Override
        public void write(int b) {
            ++this.written;
        }

        @Override
        public void write(byte[] data, int offset, int length) {
            if (data == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || offset > data.length || length < 0 || offset + length > data.length || offset + length < 0) {
                throw new IndexOutOfBoundsException();
            }
            this.written += length;
        }

        public int size() {
            return this.written;
        }
    }
}

