/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.cachingtier;

import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.statistics.StatisticBuilder;
import net.sf.ehcache.store.CachingTier;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.StoreOperationOutcomes;
import net.sf.ehcache.store.cachingtier.OnHeapCachingTier;
import net.sf.ehcache.store.offheap.BackingMapFactory;
import net.sf.ehcache.store.offheap.pool.OffHeapPool;
import net.sf.ehcache.store.offheap.pool.OffHeapPoolParticipant;
import net.sf.ehcache.store.offheap.pool.impl.CrossPoolEvictionException;
import org.terracotta.context.annotations.ContextChild;
import org.terracotta.offheapstore.concurrent.ConcurrentOffHeapClockCache;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.Statistic;
import org.terracotta.statistics.StatisticsManager;
import org.terracotta.statistics.derived.EventRateSimpleMovingAverage;
import org.terracotta.statistics.derived.OperationResultFilter;
import org.terracotta.statistics.observer.OperationObserver;

public class OffHeapCachingTier<K, V>
implements CachingTier<K, V> {
    @ContextChild
    private final OnHeapCachingTier<K, V> heapCachingTier;
    private final ConcurrentOffHeapClockCache<K, V> offHeapClockCache;
    private final OperationObserver<StoreOperationOutcomes.GetOutcome> getObserver;
    private final OperationObserver<StoreOperationOutcomes.PutOutcome> putObserver;
    private final OperationObserver<StoreOperationOutcomes.RemoveOutcome> removeObserver;
    private final OffHeapPool pool;
    private final Participant participant;
    private final List<CachingTier.Listener<K, V>> listeners;

    public OffHeapCachingTier(OnHeapCachingTier<K, V> heapCachingTier, BackingMapFactory<ConcurrentOffHeapClockCache<K, V>, OffHeapCachingTier<K, V>> offHeapClockCacheFactory, List<CachingTier.Listener<K, V>> listeners, OffHeapPool pool) {
        this.heapCachingTier = heapCachingTier;
        this.getObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.GetOutcome.class).named("get")).of(this)).tag("local-offheap")).build();
        this.putObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.PutOutcome.class).named("put")).of(this)).tag("local-offheap")).build();
        this.removeObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.RemoveOutcome.class).named("remove")).of(this)).tag("local-offheap")).build();
        this.pool = pool;
        this.participant = new Participant();
        this.offHeapClockCache = offHeapClockCacheFactory.create(this, this.participant);
        if (pool != null) {
            pool.registerParticipant(this.participant);
        }
        this.listeners = listeners;
        this.heapCachingTier.addListener(new CachingTier.Listener<K, V>(){

            @Override
            public void evicted(K key, V value) {
                if (value == null) {
                    return;
                }
                OffHeapCachingTier.this.putObserver.begin();
                while (true) {
                    try {
                        OffHeapCachingTier.this.offHeapClockCache.put(key, value);
                        OffHeapCachingTier.this.putObserver.end(StoreOperationOutcomes.PutOutcome.ADDED);
                        return;
                    }
                    catch (CrossPoolEvictionException ex) {
                        OffHeapCachingTier.this.handleCrossPoolEvictionException(key, value, ex);
                        continue;
                    }
                    break;
                }
            }
        });
    }

    private void handleCrossPoolEvictionException(K key, V value, CrossPoolEvictionException cause) {
        if (this.pool == null) {
            throw new AssertionError();
        }
        if (!this.pool.getEvictor().freeSpace(this.pool.getPoolAccessors(), 0L, this.participant, key.hashCode())) {
            throw new CacheException("The element '" + value + "' is too large to be stored in this offheap store.", cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(final K key, final Callable<V> source, boolean updateStats) {
        try {
            V v = this.heapCachingTier.get(key, new Callable<V>(){

                @Override
                public V call() throws Exception {
                    OffHeapCachingTier.this.getObserver.begin();
                    Object remove = OffHeapCachingTier.this.offHeapClockCache.remove(key);
                    if (remove != null) {
                        OffHeapCachingTier.this.getObserver.end(StoreOperationOutcomes.GetOutcome.HIT);
                        return remove;
                    }
                    OffHeapCachingTier.this.getObserver.end(StoreOperationOutcomes.GetOutcome.MISS);
                    return source.call();
                }
            }, updateStats);
            return v;
        }
        finally {
            this.offHeapClockCache.remove(key);
        }
    }

    @Override
    public V remove(K key) {
        V remove = this.heapCachingTier.remove(key);
        if (remove != null) {
            this.offHeapClockCache.remove(key);
            return remove;
        }
        this.removeObserver.begin();
        Object removed = this.offHeapClockCache.remove(key);
        if (removed != null) {
            this.removeObserver.end(StoreOperationOutcomes.RemoveOutcome.SUCCESS);
        }
        return removed;
    }

    @Override
    public void clear() {
        this.heapCachingTier.clear();
        this.offHeapClockCache.clear();
    }

    @Override
    public void clearAndNotify() {
        throw new UnsupportedOperationException("That shouldn't happen?!");
    }

    @Override
    public void addListener(CachingTier.Listener<K, V> listener) {
        this.listeners.add(listener);
    }

    @Override
    public int getInMemorySize() {
        return this.heapCachingTier.getInMemorySize();
    }

    @Override
    @Statistic(name="size", tags={"local-offheap"})
    public int getOffHeapSize() {
        return this.offHeapClockCache.size();
    }

    @Override
    public boolean contains(K key) {
        return this.heapCachingTier.contains(key);
    }

    @Override
    public long getInMemorySizeInBytes() {
        return this.heapCachingTier.getInMemorySizeInBytes();
    }

    @Override
    @Statistic(name="size-in-bytes", tags={"local-offheap"})
    public long getOffHeapSizeInBytes() {
        return this.offHeapClockCache.getOccupiedMemory();
    }

    @Override
    public long getOnDiskSizeInBytes() {
        return 0L;
    }

    @Override
    public void recalculateSize(K key) {
        this.heapCachingTier.recalculateSize(key);
    }

    @Override
    public Policy getEvictionPolicy() {
        return this.heapCachingTier.getEvictionPolicy();
    }

    @Override
    public void setEvictionPolicy(Policy policy) {
        this.heapCachingTier.setEvictionPolicy(policy);
    }

    @Override
    public boolean loadOnPut() {
        return true;
    }

    class Participant
    implements OffHeapPoolParticipant {
        private final EventRateSimpleMovingAverage hitRate = new EventRateSimpleMovingAverage(1L, TimeUnit.SECONDS);
        private final EventRateSimpleMovingAverage missRate = new EventRateSimpleMovingAverage(1L, TimeUnit.SECONDS);

        Participant() {
            OperationStatistic<OperationResultFilter<StoreOperationOutcomes.GetOutcome>> getStatistic = StatisticsManager.getOperationStatisticFor(OffHeapCachingTier.this.getObserver);
            getStatistic.addDerivedStatistic(new OperationResultFilter<StoreOperationOutcomes.GetOutcome>(EnumSet.of(StoreOperationOutcomes.GetOutcome.HIT), this.hitRate));
            getStatistic.addDerivedStatistic(new OperationResultFilter<StoreOperationOutcomes.GetOutcome>(EnumSet.of(StoreOperationOutcomes.GetOutcome.MISS), this.missRate));
        }

        @Override
        public boolean evict(int count, long size) {
            return OffHeapCachingTier.this.offHeapClockCache.shrink();
        }

        @Override
        public boolean evict(int count, long size, int excludedHash) {
            return OffHeapCachingTier.this.offHeapClockCache.shrinkOthers(excludedHash);
        }

        @Override
        public float getApproximateHitRate() {
            return this.hitRate.rate(TimeUnit.SECONDS).floatValue();
        }

        @Override
        public float getApproximateMissRate() {
            return this.missRate.rate(TimeUnit.SECONDS).floatValue();
        }

        @Override
        public long getApproximateCountSize() {
            return OffHeapCachingTier.this.offHeapClockCache.getSize();
        }

        @Override
        public long getSizeInBytes() {
            return OffHeapCachingTier.this.offHeapClockCache.getAllocatedMemory();
        }
    }
}

