/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search.store;

import com.terracottatech.offheapstore.filesystem.File;
import com.terracottatech.offheapstore.filesystem.SeekableInputStream;
import java.io.IOException;
import org.terracotta.shaded.lucene.store.IndexInput;

public class OffHeapIndexInputStream
extends IndexInput
implements Cloneable {
    private final File file;
    private final SeekableInputStream stream;

    public OffHeapIndexInputStream(File file) throws IOException {
        super(file.getName());
        this.file = file;
        this.stream = file.getInputStream();
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.stream.read();
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.stream.readBytes(b, offset, len);
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public synchronized long getFilePointer() {
        long pointer = 0L;
        try {
            pointer = this.stream.getFilePointer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return pointer;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.stream.seek(pos);
    }

    @Override
    public synchronized long length() {
        long length = 0L;
        try {
            length = this.file.length();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return length;
    }

    @Override
    public synchronized OffHeapIndexInputStream clone() {
        try {
            OffHeapIndexInputStream copy = new OffHeapIndexInputStream(this.file);
            copy.seek(this.getFilePointer());
            return copy;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

