/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search.aggregator;

import com.terracottatech.search.AbstractNVPair;
import com.terracottatech.search.AggregatorOperations;
import com.terracottatech.search.ValueType;
import com.terracottatech.search.aggregator.AbstractAggregator;
import com.terracottatech.search.aggregator.Aggregator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Date;

public class MinMax
extends AbstractAggregator {
    private final boolean min;
    private Comparable result;

    private MinMax(AggregatorOperations operation, String attributeName, boolean min, ValueType type) {
        super(operation, attributeName, type);
        this.min = min;
    }

    public static MinMax min(String attributeName, ValueType type) {
        return new MinMax(AggregatorOperations.MIN, attributeName, true, type);
    }

    public static MinMax max(String attributeName, ValueType type) {
        return new MinMax(AggregatorOperations.MAX, attributeName, false, type);
    }

    @Override
    public Comparable getResult() {
        if (this.getType() == ValueType.ENUM) {
            return (Comparable)AbstractNVPair.createNVPair(this.getAttributeName(), this.result, this.getType()).getObjectValue();
        }
        return this.result;
    }

    @Override
    public void accept(Object input) throws IllegalArgumentException {
        if (input == null) {
            return;
        }
        Comparable next = MinMax.getComparable(input);
        if (this.result == null) {
            this.result = next;
        } else {
            int cmp;
            try {
                cmp = next.compareTo(this.result);
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException(this.getAttributeName(), cce);
            }
            if (this.min) {
                if (cmp < 0) {
                    this.result = next;
                }
            } else if (cmp > 0) {
                this.result = next;
            }
        }
    }

    @Override
    public void accept(Aggregator incoming) throws IllegalArgumentException {
        if (!(incoming instanceof MinMax)) {
            throw new IllegalArgumentException();
        }
        this.accept(((MinMax)incoming).result);
    }

    private static Comparable getComparable(Object o) throws IllegalArgumentException {
        if (o instanceof Comparable) {
            return (Comparable)o;
        }
        throw new IllegalArgumentException("Value is not Comparable: " + o.getClass());
    }

    @Override
    Aggregator deserializeData(DataInput input) throws IOException {
        boolean isNull = input.readBoolean();
        if (isNull) {
            this.result = null;
            return this;
        }
        switch (this.getType()) {
            case BOOLEAN: {
                this.result = Boolean.valueOf(input.readBoolean());
                return this;
            }
            case BYTE: {
                this.result = Byte.valueOf(input.readByte());
                return this;
            }
            case BYTE_ARRAY: {
                throw new AssertionError();
            }
            case CHAR: {
                this.result = Character.valueOf(input.readChar());
                return this;
            }
            case DATE: {
                this.result = new java.util.Date(input.readLong());
                return this;
            }
            case DOUBLE: {
                this.result = Double.valueOf(input.readDouble());
                return this;
            }
            case ENUM: {
                this.result = input.readUTF();
                return this;
            }
            case FLOAT: {
                this.result = Float.valueOf(input.readFloat());
                return this;
            }
            case INT: {
                this.result = Integer.valueOf(input.readInt());
                return this;
            }
            case LONG: {
                this.result = Long.valueOf(input.readLong());
                return this;
            }
            case NULL: {
                throw new AssertionError();
            }
            case SHORT: {
                this.result = Short.valueOf(input.readShort());
                return this;
            }
            case SQL_DATE: {
                this.result = new Date(input.readLong());
                return this;
            }
            case STRING: {
                this.result = input.readUTF();
                return this;
            }
            case VALUE_ID: {
                throw new AssertionError();
            }
        }
        throw new AssertionError((Object)this.getType());
    }

    @Override
    void serializeData(DataOutput output) throws IOException {
        if (this.result == null) {
            output.writeBoolean(true);
            return;
        }
        output.writeBoolean(false);
        switch (this.getType()) {
            case BOOLEAN: {
                output.writeBoolean((Boolean)this.result);
                return;
            }
            case BYTE: {
                output.writeByte(((Byte)this.result).byteValue());
                return;
            }
            case BYTE_ARRAY: {
                throw new AssertionError();
            }
            case CHAR: {
                output.writeChar(((Character)this.result).charValue());
                return;
            }
            case DATE: {
                output.writeLong(((java.util.Date)this.result).getTime());
                return;
            }
            case DOUBLE: {
                output.writeDouble((Double)this.result);
                return;
            }
            case ENUM: {
                if (this.result instanceof String) {
                    output.writeUTF((String)((Object)this.result));
                } else if (this.result instanceof Enum) {
                    output.writeUTF(AbstractNVPair.enumStorageString((Enum)((Object)this.result)));
                } else {
                    throw new AssertionError((Object)("Unexpected type: " + this.result.getClass()));
                }
                return;
            }
            case FLOAT: {
                output.writeFloat(((Float)this.result).floatValue());
                return;
            }
            case INT: {
                output.writeInt((Integer)this.result);
                return;
            }
            case LONG: {
                output.writeLong((Long)this.result);
                return;
            }
            case NULL: {
                throw new AssertionError();
            }
            case SHORT: {
                output.writeShort(((Short)this.result).shortValue());
                return;
            }
            case SQL_DATE: {
                output.writeLong(((Date)this.result).getTime());
                return;
            }
            case STRING: {
                output.writeUTF((String)((Object)this.result));
                return;
            }
            case VALUE_ID: {
                throw new AssertionError();
            }
        }
        throw new AssertionError((Object)this.getType());
    }
}

