/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage.restartable.partial;

import com.terracottatech.frs.Disposable;
import com.terracottatech.frs.RestartStore;
import com.terracottatech.frs.TransactionException;
import com.terracottatech.frs.Tuple;
import com.terracottatech.frs.object.ObjectManagerEntry;
import com.terracottatech.frs.object.ObjectManagerSegment;
import com.terracottatech.frs.object.SimpleObjectManagerEntry;
import com.terracottatech.offheapstore.storage.restartable.RestartableStorageEngine;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import org.terracotta.offheapstore.paging.OffHeapStorageArea;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.offheapstore.storage.BinaryStorageEngine;
import org.terracotta.offheapstore.storage.PointerSize;
import org.terracotta.offheapstore.storage.StorageEngine;
import org.terracotta.offheapstore.storage.listener.AbstractListenableStorageEngine;
import org.terracotta.offheapstore.storage.portability.Portability;
import org.terracotta.offheapstore.util.ByteBufferUtils;
import org.terracotta.offheapstore.util.Factory;
import org.terracotta.offheapstore.util.Validation;

public class RestartableMinimalStorageEngine<I, K, V>
extends AbstractListenableStorageEngine<K, V>
implements StorageEngine<K, V>,
BinaryStorageEngine,
ObjectManagerSegment<I, ByteBuffer, ByteBuffer> {
    private static final boolean VALIDATING = Validation.shouldValidate(RestartableMinimalStorageEngine.class);
    private static final int META_LSN_OFFSET = 0;
    private static final int META_PREVIOUS_OFFSET = 8;
    private static final int META_NEXT_OFFSET = 16;
    private static final int META_KEY_HASH_OFFSET = 24;
    private static final int META_ENTRY_SIZE_OFFSET = 28;
    private static final int META_SIZE = 32;
    private static final long NULL_ENCODING = Long.MIN_VALUE;
    private final Map<Long, Map.Entry<ByteBuffer, ByteBuffer>> holdingArea = new HashMap<Long, Map.Entry<ByteBuffer, ByteBuffer>>();
    protected final OffHeapStorageArea metadataArea;
    protected final Portability<? super K> keyPortability;
    protected final Portability<? super V> valuePortability;
    private final I identifier;
    private final RestartStore<I, ByteBuffer, ByteBuffer> transactionSource;
    private final boolean synchronous;
    protected volatile StorageEngine.Owner owner;
    private long lsnFirst = Long.MIN_VALUE;
    private long lsnLast = Long.MIN_VALUE;
    private ObjectManagerEntry<I, ByteBuffer, ByteBuffer> compactingEntry;
    private volatile long dataSize = 0L;

    public static <I, K, V> Factory<RestartableMinimalStorageEngine<I, K, V>> createMinimalFactory(final I identifier, final RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, final boolean synchronous, final PointerSize width, final PageSource source, final int pageSize, final Portability<? super K> keyPortability, final Portability<? super V> valuePortability, final boolean thief, final boolean victim, final float compressThreshold) {
        return new Factory<RestartableMinimalStorageEngine<I, K, V>>(){

            @Override
            public RestartableMinimalStorageEngine<I, K, V> newInstance() {
                return new RestartableMinimalStorageEngine(identifier, transactionSource, synchronous, width, source, pageSize, keyPortability, valuePortability, thief, victim, compressThreshold);
            }
        };
    }

    public static <I, K, V> Factory<RestartableMinimalStorageEngine<I, K, V>> createMinimalFactory(final I identifier, final RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, final boolean synchronous, final PointerSize width, final PageSource source, final int initialPageSize, final int maximalPageSize, final Portability<? super K> keyPortability, final Portability<? super V> valuePortability, final boolean thief, final boolean victim, final float compressThreshold) {
        return new Factory<RestartableMinimalStorageEngine<I, K, V>>(){

            @Override
            public RestartableMinimalStorageEngine<I, K, V> newInstance() {
                return new RestartableMinimalStorageEngine(identifier, transactionSource, synchronous, width, source, initialPageSize, maximalPageSize, keyPortability, valuePortability, thief, victim, compressThreshold);
            }
        };
    }

    public RestartableMinimalStorageEngine(I identifier, RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, boolean synchronous, PointerSize width, PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, float compressThreshold) {
        this(identifier, transactionSource, synchronous, width, source, pageSize, pageSize, keyPortability, valuePortability, compressThreshold);
    }

    public RestartableMinimalStorageEngine(I identifier, RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, boolean synchronous, PointerSize width, PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, float compressThreshold) {
        this(identifier, transactionSource, synchronous, width, source, initialPageSize, maximalPageSize, keyPortability, valuePortability, false, false, compressThreshold);
    }

    public RestartableMinimalStorageEngine(I identifier, RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, boolean synchronous, PointerSize width, PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim, float compressThreshold) {
        this(identifier, transactionSource, synchronous, width, source, pageSize, pageSize, keyPortability, valuePortability, thief, victim, compressThreshold);
    }

    public RestartableMinimalStorageEngine(I identifier, RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, boolean synchronous, PointerSize width, PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim, float compressThreshold) {
        this.identifier = identifier;
        this.transactionSource = transactionSource;
        this.metadataArea = new OffHeapStorageArea(width, new MetadataOwner(), source, initialPageSize, maximalPageSize, thief, victim, compressThreshold);
        this.keyPortability = keyPortability;
        this.valuePortability = valuePortability;
        this.synchronous = synchronous;
    }

    @Override
    public Long writeMapping(K key, V value, int hash, int metadata) {
        ByteBuffer binaryValue;
        ByteBuffer binaryKey = this.keyPortability.encode(key);
        Long result = this.writePartialEntry(hash, binaryKey, binaryValue = this.valuePortability.encode(value));
        if (result == null) {
            return null;
        }
        this.holdingArea.put(result, new AbstractMap.SimpleImmutableEntry<ByteBuffer, ByteBuffer>(binaryKey, binaryValue));
        if (this.hasListeners()) {
            this.fireWritten(key, value, binaryKey.duplicate(), binaryValue.duplicate(), hash, metadata, result);
        }
        return result;
    }

    protected Long writePartialEntry(int hash, ByteBuffer binaryKey, ByteBuffer binaryValue) {
        int entrySize = this.getRequiredEntrySize(binaryKey, binaryValue);
        long encoding = this.metadataArea.allocate(entrySize);
        if (encoding >= 0L) {
            int size = binaryKey.remaining() + binaryValue.remaining();
            this.metadataArea.writeLong(encoding + 0L, Long.MIN_VALUE);
            this.metadataArea.writeLong(encoding + 16L, Long.MIN_VALUE);
            this.metadataArea.writeLong(encoding + 8L, Long.MIN_VALUE);
            this.metadataArea.writeInt(encoding + 24L, hash);
            this.metadataArea.writeInt(encoding + 28L, size);
            this.dataSize += (long)size;
            return encoding;
        }
        return null;
    }

    protected int getRequiredEntrySize(ByteBuffer binaryKey, ByteBuffer binaryValue) {
        return 32;
    }

    protected int getActualEntrySize(long encoding) {
        return 32;
    }

    @Override
    public void attachedMapping(long encoding, int hash, int metadata) {
        ByteBuffer frsBinaryKey = RestartableStorageEngine.encodeKey(this.readBinaryKey(encoding), hash);
        ByteBuffer frsBinaryValue = RestartableStorageEngine.encodeValue(this.readBinaryValue(encoding), encoding, metadata);
        try {
            this.transactionSource.beginTransaction(this.synchronous).put(this.identifier, frsBinaryKey, frsBinaryValue).commit();
        }
        catch (TransactionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void freeMapping(long encoding, int hash, boolean removal) {
        boolean listeners = this.hasListeners();
        ByteBuffer rawKey = null;
        if (listeners || removal) {
            rawKey = this.readBinaryKey(encoding);
        }
        this.unlinkNode(encoding);
        if (removal) {
            this.restartabilityRemove(rawKey.duplicate(), hash);
        }
        this.dataSize -= (long)this.metadataArea.readInt(encoding + 28L);
        this.metadataArea.free(encoding);
        this.holdingArea.remove(encoding);
        this.validChain();
        if (listeners) {
            this.fireFreed(encoding, hash, rawKey, removal);
        }
    }

    private void restartabilityRemove(ByteBuffer offheapBinaryKey, int hash) {
        ByteBuffer frsBinaryKey = RestartableStorageEngine.encodeKey(offheapBinaryKey, hash);
        try {
            this.transactionSource.beginTransaction(this.synchronous).remove(this.identifier, frsBinaryKey).commit();
        }
        catch (TransactionException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V readValue(long encoding) {
        try (Entry result = this.readEntry(encoding);){
            V v = this.valuePortability.decode(result.getValue());
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equalsValue(Object value, long encoding) {
        try (Entry result = this.readEntry(encoding);){
            boolean bl = this.valuePortability.equals(value, result.getValue());
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public K readKey(long encoding, int hashCode) {
        try (Entry result = this.readEntry(encoding);){
            K k = this.keyPortability.decode(result.getKey());
            return k;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equalsKey(Object key, long encoding) {
        try (Entry result = this.readEntry(encoding);){
            boolean bl = this.keyPortability.equals(key, result.getKey());
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equalsBinaryKey(ByteBuffer offheapBinaryKey, long encoding) {
        try (Entry result = this.readEntry(encoding);){
            boolean bl = this.equalsBinaryKey(offheapBinaryKey, result.getKey());
            return bl;
        }
    }

    protected final boolean equalsBinaryKey(ByteBuffer probe, ByteBuffer stored) {
        return probe.equals(stored.duplicate()) || this.keyPortability.equals(this.keyPortability.decode(probe.duplicate()), stored.duplicate());
    }

    @Override
    public void clear() {
        this.lsnFirst = Long.MIN_VALUE;
        this.lsnLast = Long.MIN_VALUE;
        this.dataSize = 0L;
        this.restartabilityDelete();
        this.metadataArea.clear();
        this.validChain();
        this.fireCleared();
    }

    private void restartabilityDelete() {
        try {
            this.transactionSource.beginTransaction(this.synchronous).delete(this.identifier).commit();
        }
        catch (TransactionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getAllocatedMemory() {
        return this.metadataArea.getAllocatedMemory();
    }

    @Override
    public long getOccupiedMemory() {
        return this.metadataArea.getOccupiedMemory();
    }

    @Override
    public long getVitalMemory() {
        return this.metadataArea.getAllocatedMemory();
    }

    @Override
    public long getDataSize() {
        return this.dataSize;
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public void bind(StorageEngine.Owner owner) {
        this.owner = owner;
    }

    @Override
    public void destroy() {
        this.metadataArea.destroy();
    }

    @Override
    public boolean shrink() {
        return this.metadataArea.shrink();
    }

    protected final void assignLsn(long encoding, long lsn) {
        this.unlinkNode(encoding);
        this.linkNodeExpectingLast(encoding, lsn);
        this.metadataArea.writeLong(encoding + 0L, lsn);
        this.holdingArea.remove(encoding);
        this.validChain();
    }

    protected final void unlinkNode(long encoding) {
        long next = this.metadataArea.readLong(encoding + 16L);
        long prev = this.metadataArea.readLong(encoding + 8L);
        if (this.lsnLast == encoding) {
            this.lsnLast = prev;
        }
        if (this.lsnFirst == encoding) {
            this.lsnFirst = next;
        }
        if (next != Long.MIN_VALUE) {
            this.metadataArea.writeLong(next + 8L, prev);
        }
        if (prev != Long.MIN_VALUE) {
            this.metadataArea.writeLong(prev + 16L, next);
        }
        this.metadataArea.writeLong(encoding + 16L, Long.MIN_VALUE);
        this.metadataArea.writeLong(encoding + 8L, Long.MIN_VALUE);
    }

    protected final void linkNodeExpectingLast(long node, long lsn) {
        long next;
        if (lsn < 0L) {
            throw new AssertionError((Object)("Received illegal lsn " + lsn));
        }
        if (this.lsnLast == Long.MIN_VALUE) {
            Validation.validate(!VALIDATING || this.lsnFirst == Long.MIN_VALUE);
            this.lsnLast = node;
            this.lsnFirst = node;
            return;
        }
        long previous = this.lsnLast;
        while (true) {
            if (this.metadataArea.readLong(previous + 0L) < lsn) {
                next = this.metadataArea.readLong(previous + 16L);
                break;
            }
            if (this.metadataArea.readLong(previous + 8L) == Long.MIN_VALUE) {
                next = previous;
                previous = Long.MIN_VALUE;
                break;
            }
            previous = this.metadataArea.readLong(previous + 8L);
        }
        if (next == Long.MIN_VALUE) {
            Validation.validate(!VALIDATING || previous == this.lsnLast);
            this.lsnLast = node;
            this.metadataArea.writeLong(node + 8L, previous);
            this.metadataArea.writeLong(previous + 16L, node);
        } else if (previous == Long.MIN_VALUE) {
            Validation.validate(!VALIDATING || next == this.lsnFirst);
            this.lsnFirst = node;
            this.metadataArea.writeLong(node + 16L, next);
            this.metadataArea.writeLong(next + 8L, node);
        } else {
            this.metadataArea.writeLong(node + 16L, next);
            this.metadataArea.writeLong(node + 8L, previous);
            this.metadataArea.writeLong(previous + 16L, node);
            this.metadataArea.writeLong(next + 8L, node);
        }
    }

    protected final void linkNodeExpectingFirst(long node, long lsn) {
        long previous;
        if (lsn < 0L) {
            throw new AssertionError((Object)("Received illegal lsn " + lsn));
        }
        if (this.lsnLast == Long.MIN_VALUE) {
            Validation.validate(!VALIDATING || this.lsnFirst == Long.MIN_VALUE);
            this.lsnLast = node;
            this.lsnFirst = node;
            return;
        }
        long next = this.lsnFirst;
        while (true) {
            if (this.metadataArea.readLong(next + 0L) > lsn) {
                previous = this.metadataArea.readLong(next + 8L);
                break;
            }
            if (this.metadataArea.readLong(next + 16L) == Long.MIN_VALUE) {
                previous = next;
                next = Long.MIN_VALUE;
                break;
            }
            next = this.metadataArea.readLong(next + 16L);
        }
        if (previous == Long.MIN_VALUE) {
            Validation.validate(!VALIDATING || next == this.lsnFirst);
            this.lsnFirst = node;
            this.metadataArea.writeLong(node + 16L, next);
            this.metadataArea.writeLong(next + 8L, node);
        } else if (next == Long.MIN_VALUE) {
            Validation.validate(!VALIDATING || previous == this.lsnLast);
            this.lsnLast = node;
            this.metadataArea.writeLong(node + 8L, previous);
            this.metadataArea.writeLong(previous + 16L, node);
        } else {
            this.metadataArea.writeLong(node + 8L, previous);
            this.metadataArea.writeLong(node + 16L, next);
            this.metadataArea.writeLong(next + 8L, node);
            this.metadataArea.writeLong(previous + 16L, node);
        }
    }

    protected final void validChain() {
        if (VALIDATING) {
            long previous = Long.MIN_VALUE;
            long current = this.lsnFirst;
            while (true) {
                if (current == Long.MIN_VALUE) {
                    Validation.validate(this.lsnLast == previous);
                    break;
                }
                Validation.validate(!VALIDATING || this.metadataArea.readLong(current + 8L) == previous);
                if (previous != Long.MIN_VALUE) {
                    Validation.validate(this.metadataArea.readLong(previous + 16L) == current);
                }
                previous = current;
                current = this.metadataArea.readLong(previous + 16L);
            }
        }
    }

    protected long firstEncoding() {
        return this.lsnFirst;
    }

    protected long lastEncoding() {
        return this.lsnLast;
    }

    @Override
    public long size() {
        return this.owner.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getLowestLsn() {
        Lock l = this.owner.readLock();
        l.lock();
        try {
            long lowest = this.firstEncoding();
            if (lowest == Long.MIN_VALUE) {
                Long l2 = null;
                return l2;
            }
            Long l3 = this.metadataArea.readLong(lowest + 0L);
            return l3;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getLsn(int pojoHash, ByteBuffer frsBinaryKey) {
        ByteBuffer offheapBinaryKey = RestartableStorageEngine.decodeKey(frsBinaryKey);
        Lock l = this.owner.readLock();
        l.lock();
        try {
            Long encoding = this.lookupEncoding(pojoHash, offheapBinaryKey);
            if (encoding == null) {
                Long l2 = null;
                return l2;
            }
            Long l3 = this.metadataArea.readLong(encoding + 0L);
            return l3;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(int pojoHash, ByteBuffer frsBinaryKey, ByteBuffer frsBinaryValue, long lsn) {
        long encoding = RestartableStorageEngine.extractEncoding(frsBinaryValue);
        Lock l = this.owner.writeLock();
        l.lock();
        try {
            this.assignLsn(encoding, lsn);
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public void remove(int pojoHash, ByteBuffer frsBinaryKey) {
        Validation.validate(!VALIDATING || this.lookupEncoding(pojoHash, RestartableStorageEngine.decodeKey(frsBinaryKey)) != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replayPut(int pojoHash, ByteBuffer frsBinaryKey, ByteBuffer frsBinaryValue, long lsn) {
        int metadata = RestartableStorageEngine.extractMetadata(frsBinaryValue);
        final ByteBuffer offheapBinaryKey = RestartableStorageEngine.decodeKey(frsBinaryKey);
        final ByteBuffer offheapBinaryValue = RestartableStorageEngine.decodeValue(frsBinaryValue);
        Lock l = this.owner.writeLock();
        l.lock();
        try {
            long encoding = this.owner.installMappingForHashAndEncoding(pojoHash, offheapBinaryKey, offheapBinaryValue, metadata);
            this.linkNodeExpectingFirst(encoding, lsn);
            this.metadataArea.writeLong(encoding + 0L, lsn);
            this.validChain();
            if (this.hasRecoveryListeners()) {
                final Thread caller = Thread.currentThread();
                this.fireRecovered(new Callable<K>(){

                    @Override
                    public K call() throws Exception {
                        if (caller == Thread.currentThread()) {
                            return RestartableMinimalStorageEngine.this.keyPortability.decode(offheapBinaryKey.duplicate());
                        }
                        throw new IllegalStateException();
                    }
                }, new Callable<V>(){

                    @Override
                    public V call() throws Exception {
                        if (caller == Thread.currentThread()) {
                            return RestartableMinimalStorageEngine.this.valuePortability.decode(offheapBinaryValue.duplicate());
                        }
                        throw new IllegalStateException();
                    }
                }, offheapBinaryKey.duplicate(), offheapBinaryValue.duplicate(), pojoHash, metadata, encoding);
            }
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public Long writeBinaryMapping(ByteBuffer binaryKey, ByteBuffer binaryValue, int pojoHash, int metadata) {
        return this.writePartialEntry(pojoHash, binaryKey, binaryValue);
    }

    @Override
    public Long writeBinaryMapping(ByteBuffer[] binaryKey, ByteBuffer[] binaryValue, int pojoHash, int metadata) {
        return this.writePartialEntry(pojoHash, ByteBufferUtils.aggregate(binaryKey), ByteBufferUtils.aggregate(binaryValue));
    }

    @Override
    public int readKeyHash(long encoding) {
        return this.metadataArea.readInt(encoding + 24L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer readBinaryKey(long encoding) {
        try (Entry result = this.readEntry(encoding);){
            ByteBuffer byteBuffer = RestartableMinimalStorageEngine.detach(result.getKey());
            return byteBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer readBinaryValue(long encoding) {
        try (Entry result = this.readEntry(encoding);){
            ByteBuffer byteBuffer = RestartableMinimalStorageEngine.detach(result.getValue());
            return byteBuffer;
        }
    }

    protected static ByteBuffer detach(ByteBuffer attached) {
        ByteBuffer detached = ByteBuffer.allocate(attached.remaining());
        detached.put(attached).flip();
        return detached;
    }

    protected Entry readEntry(long encoding) {
        Map.Entry<ByteBuffer, ByteBuffer> e = this.holdingArea.get(encoding);
        if (e != null) {
            return new DetachedEntry(e.getKey().duplicate(), e.getValue().duplicate());
        }
        long lsn = this.metadataArea.readLong(encoding + 0L);
        Tuple<I, ByteBuffer, ByteBuffer> result = this.transactionSource.get(lsn);
        return new DecodedEntry(result);
    }

    @Override
    public ObjectManagerEntry<I, ByteBuffer, ByteBuffer> acquireCompactionEntry(long ceilingLsn) {
        Lock l = this.owner.writeLock();
        l.lock();
        long encoding = this.firstEncoding();
        if (encoding == Long.MIN_VALUE) {
            l.unlock();
            return null;
        }
        try {
            long lsn = this.metadataArea.readLong(encoding + 0L);
            if (lsn >= ceilingLsn) {
                l.unlock();
                return null;
            }
            this.compactingEntry = new SimpleObjectManagerEntry<I, ByteBuffer, ByteBuffer>(this.identifier, RestartableStorageEngine.encodeKey(this.readBinaryKey(encoding), this.readKeyHash(encoding)), RestartableStorageEngine.encodeValue(this.readBinaryValue(encoding), encoding, this.deriveMetadata(encoding)), lsn);
            return this.compactingEntry;
        }
        catch (RuntimeException e) {
            l.unlock();
            throw e;
        }
        catch (Error e) {
            l.unlock();
            throw e;
        }
        catch (Throwable e) {
            l.unlock();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void releaseCompactionEntry(ObjectManagerEntry<I, ByteBuffer, ByteBuffer> entry) {
        if (entry == null) {
            throw new NullPointerException("Tried to release a null entry.");
        }
        if (entry != this.compactingEntry) {
            throw new IllegalArgumentException("Released entry is not the same as acquired entry.");
        }
        this.compactingEntry = null;
        this.owner.writeLock().unlock();
    }

    @Override
    public void updateLsn(int pojoHash, ObjectManagerEntry<I, ByteBuffer, ByteBuffer> entry, long newLsn) {
        if (entry != this.compactingEntry) {
            throw new IllegalArgumentException("Tried to update the LSN on an entry that was not acquired.");
        }
        long encoding = RestartableStorageEngine.extractEncoding(entry.getValue());
        Validation.validate(!VALIDATING || this.metadataArea.readLong(encoding + 0L) == entry.getLsn());
        this.assignLsn(encoding, newLsn);
    }

    private Long lookupEncoding(int hash, ByteBuffer offHeapBinaryKey) {
        return this.owner.getEncodingForHashAndBinary(hash, offHeapBinaryKey);
    }

    protected int deriveMetadata(long encoding) {
        return 0;
    }

    @Override
    public long sizeInBytes() {
        return this.metadataArea.getOccupiedMemory();
    }

    class MetadataOwner
    implements OffHeapStorageArea.Owner {
        MetadataOwner() {
        }

        @Override
        public Collection<Long> evictAtAddress(long address, boolean shrink) {
            int hash = RestartableMinimalStorageEngine.this.readKeyHash(address);
            int slot = RestartableMinimalStorageEngine.this.owner.getSlotForHashAndEncoding(hash, address, -1L);
            if (RestartableMinimalStorageEngine.this.owner.evict(slot, shrink)) {
                return Collections.singleton(address);
            }
            return Collections.emptyList();
        }

        @Override
        public Lock writeLock() {
            return RestartableMinimalStorageEngine.this.owner.writeLock();
        }

        @Override
        public boolean isThief() {
            return RestartableMinimalStorageEngine.this.owner.isThiefForTableAllocations();
        }

        @Override
        public boolean moved(long from, long to) {
            if (RestartableMinimalStorageEngine.this.owner.updateEncoding(RestartableMinimalStorageEngine.this.readKeyHash(to), from, to, -1L)) {
                long prev;
                long next;
                if (RestartableMinimalStorageEngine.this.lsnLast == from) {
                    RestartableMinimalStorageEngine.this.lsnLast = to;
                }
                if (RestartableMinimalStorageEngine.this.lsnFirst == from) {
                    RestartableMinimalStorageEngine.this.lsnFirst = to;
                }
                if ((next = RestartableMinimalStorageEngine.this.metadataArea.readLong(to + 16L)) != Long.MIN_VALUE) {
                    RestartableMinimalStorageEngine.this.metadataArea.writeLong(next + 8L, to);
                }
                if ((prev = RestartableMinimalStorageEngine.this.metadataArea.readLong(to + 8L)) != Long.MIN_VALUE) {
                    RestartableMinimalStorageEngine.this.metadataArea.writeLong(prev + 16L, to);
                }
                RestartableMinimalStorageEngine.this.validChain();
                return true;
            }
            return false;
        }

        @Override
        public int sizeOf(long address) {
            return RestartableMinimalStorageEngine.this.getActualEntrySize(address);
        }
    }

    private static class DecodedEntry
    implements Entry {
        private final Tuple<?, ?, ?> encoded;
        private final ByteBuffer key;
        private final ByteBuffer value;

        public DecodedEntry(Tuple<?, ByteBuffer, ByteBuffer> encoded) {
            this.encoded = encoded;
            this.key = RestartableStorageEngine.decodeKey(encoded.getKey());
            this.value = RestartableStorageEngine.decodeValue(encoded.getValue());
        }

        @Override
        public ByteBuffer getKey() {
            return this.key;
        }

        @Override
        public ByteBuffer getValue() {
            return this.value;
        }

        @Override
        public void close() {
            if (this.encoded instanceof Disposable) {
                ((Disposable)((Object)this.encoded)).dispose();
            }
        }
    }

    private static class DetachedEntry
    implements Entry {
        private final ByteBuffer key;
        private final ByteBuffer value;

        public DetachedEntry(ByteBuffer key, ByteBuffer value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public ByteBuffer getKey() {
            return this.key;
        }

        @Override
        public ByteBuffer getValue() {
            return this.value;
        }

        @Override
        public void close() {
        }
    }

    protected static interface Entry
    extends Closeable {
        public ByteBuffer getKey();

        public ByteBuffer getValue();

        @Override
        public void close();
    }
}

