/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.log;

import com.terracottatech.frs.log.CommitList;
import com.terracottatech.frs.log.LogRecord;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class StackingCommitList
implements CommitList {
    private final LogRecord[] regions;
    private long baseLsn;
    private volatile boolean syncing = false;
    private long endLsn;
    private boolean closed = false;
    private boolean written = false;
    private Exception error;
    private int count = 0;
    private final Object guard = new Object();
    private volatile CommitList next;
    private int wait;

    public StackingCommitList(long startLsn, int maxSize, int wait) {
        this.baseLsn = startLsn;
        this.endLsn = startLsn - 1L;
        this.regions = new LogRecord[maxSize];
        this.wait = wait;
    }

    @Override
    public boolean append(LogRecord record, boolean sync) {
        assert (record.getLsn() >= this.baseLsn);
        if (record.getLsn() >= (long)this.regions.length + this.baseLsn) {
            return false;
        }
        this.regions[(int)(record.getLsn() - this.baseLsn)] = record;
        if (!this.countRecord(record.getLsn(), sync)) {
            this.regions[(int)(record.getLsn() - this.baseLsn)] = null;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommitList next() {
        if (this.next == null) {
            StackingCommitList stackingCommitList = this;
            synchronized (stackingCommitList) {
                if (!this.closed) {
                    this.closed = true;
                }
                if (this.next == null) {
                    this.next = this.create(this.endLsn + 1L);
                }
            }
        }
        return this.next;
    }

    @Override
    public CommitList create(long nextLsn) {
        return new StackingCommitList(nextLsn, this.regions.length, this.wait);
    }

    @Override
    public boolean isEmpty() {
        return this.endLsn < this.baseLsn;
    }

    @Override
    public long getBaseLsn() {
        return this.baseLsn;
    }

    @Override
    public long getEndLsn() {
        return this.endLsn;
    }

    private synchronized boolean countRecord(long lsn, boolean sync) {
        if (this.closed) {
            if (lsn > this.endLsn) {
                return false;
            }
        } else if (lsn > this.endLsn) {
            this.endLsn = lsn;
        }
        if ((long)this.count++ == this.endLsn - this.baseLsn) {
            this.notify();
        }
        if (sync) {
            this.syncing = true;
            this.notify();
        }
        return true;
    }

    @Override
    public synchronized boolean close(long lsn) {
        if (lsn <= this.endLsn) {
            this.closed = true;
            this.notify();
        }
        return this.closed;
    }

    @Override
    public boolean isSyncRequested() {
        return this.syncing;
    }

    private void waitForWrite() throws InterruptedException, ExecutionException {
        this.waitForWrite(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForWrite(long millis) throws InterruptedException, ExecutionException {
        long span = System.currentTimeMillis();
        Object object = this.guard;
        synchronized (object) {
            while (!this.written) {
                if (this.error != null) {
                    throw new ExecutionException(this.error);
                }
                if (millis != 0L && System.currentTimeMillis() - span > millis) {
                    return;
                }
                this.guard.wait(millis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWritten() {
        Object object = this.guard;
        synchronized (object) {
            return this.written;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void written() {
        Object object = this.guard;
        synchronized (object) {
            this.written = true;
            this.guard.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionThrown(Exception exp) {
        CommitList chain = null;
        Object object = this.guard;
        synchronized (object) {
            this.error = exp;
            this.guard.notifyAll();
            if (this.next != null) {
                chain = this.next;
            }
        }
        if (chain != null) {
            chain.exceptionThrown(exp);
        }
    }

    @Override
    public synchronized void waitForContiguous() throws InterruptedException {
        boolean timedout = false;
        if (this.count > 0 && !this.closed) {
            this.close(this.baseLsn + (long)this.count - 1L);
        }
        while (!this.closed && this.count != this.regions.length || this.closed && (long)this.count != this.endLsn - this.baseLsn + 1L) {
            this.wait(this.wait);
            if (timedout) {
                if (this.count <= 0) continue;
                this.close(this.baseLsn + (long)this.count - 1L);
                timedout = false;
                continue;
            }
            timedout = true;
        }
        if (this.count != this.regions.length && (long)this.count != this.endLsn - this.baseLsn + 1L) {
            throw new AssertionError();
        }
    }

    @Override
    public boolean cancel(boolean bln) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private synchronized void checkForClose() {
        if (!this.closed) {
            this.closed = true;
            this.notify();
        }
    }

    @Override
    public Void get() throws InterruptedException, ExecutionException {
        this.checkForClose();
        this.waitForWrite();
        return null;
    }

    @Override
    public Void get(long l, TimeUnit tu) throws InterruptedException, ExecutionException, TimeoutException {
        this.checkForClose();
        this.waitForWrite(tu.convert(l, TimeUnit.MILLISECONDS));
        return null;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.isWritten();
    }

    @Override
    public Iterator<LogRecord> iterator() {
        return new Iterator<LogRecord>(){
            int current = 0;

            @Override
            public boolean hasNext() {
                return this.current < StackingCommitList.this.count;
            }

            @Override
            public LogRecord next() {
                return StackingCommitList.this.regions[this.current++];
            }

            @Override
            public void remove() {
            }
        };
    }
}

