/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.log;

import com.terracottatech.frs.log.CommitList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CommitListFuture
implements Future<Void> {
    private final CommitList origin;
    private final long lsn;

    public CommitListFuture(long lsn, CommitList origin) {
        this.origin = origin;
        this.lsn = lsn;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        CommitList target = this.origin;
        while (target.isDone()) {
            if (target.getEndLsn() >= this.lsn) {
                return true;
            }
            target = target.next();
        }
        return false;
    }

    @Override
    public Void get() throws InterruptedException, ExecutionException {
        CommitList target = this.origin;
        target.get();
        while (target.getEndLsn() < this.lsn) {
            target = target.next();
            target.get();
        }
        return null;
    }

    @Override
    public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        CommitList target = this.origin;
        long to = unit.toNanos(timeout) + System.nanoTime();
        target.get(timeout, unit);
        while (target.getEndLsn() < this.lsn) {
            target = target.next();
            long ct = System.nanoTime();
            if (ct > to) {
                throw new TimeoutException();
            }
            target.get(to - ct, TimeUnit.NANOSECONDS);
        }
        return null;
    }
}

