/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.SnapshotRequest;
import com.terracottatech.frs.io.BufferBuilder;
import com.terracottatech.frs.io.BufferSource;
import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.Direction;
import com.terracottatech.frs.io.FileBuffer;
import com.terracottatech.frs.io.HeapBufferSource;
import com.terracottatech.frs.io.IOManager;
import com.terracottatech.frs.io.Stream;
import com.terracottatech.frs.io.nio.HeaderException;
import com.terracottatech.frs.io.nio.NIOAccessMethod;
import com.terracottatech.frs.io.nio.NIORandomAccess;
import com.terracottatech.frs.io.nio.NIOSegment;
import com.terracottatech.frs.io.nio.NIOSegmentList;
import com.terracottatech.frs.io.nio.ReadOnlySegment;
import com.terracottatech.frs.io.nio.WritingSegment;
import com.terracottatech.frs.util.Log2LatencyBins;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NIOStreamImpl
implements Stream {
    private static final Integer REPORT_FSYNC_LATENCIES = Integer.getInteger("com.terracottatech.frs.ReportFsyncLatenciesInSecs", (int)TimeUnit.SECONDS.convert(5L, TimeUnit.MINUTES));
    private final NIOSegmentList segments;
    private final Log2LatencyBins fsyncLatencyBin;
    private final Thread reporterThread;
    private volatile NIORandomAccess randomAccess;
    static final String BAD_STREAM_ID = "mis-aligned streams";
    private final File directory;
    private final long segmentSize;
    private boolean syncDisabled = false;
    private UUID streamId;
    private volatile long lowestMarker = 99L;
    private volatile long lowestMarkerOnDisk = 0L;
    private volatile long fsyncdMarker = 0L;
    private volatile long currentMarker = 99L;
    private int markerWaiters = 0;
    private WritingSegment writeHead;
    private ReadOnlySegment readHead;
    private long offset = 0L;
    private final BufferSource filePool;
    private BufferSource replayPool;
    private FSyncer syncer;
    private volatile boolean closed = false;
    private BufferBuilder createBuffer;
    private final NIOAccessMethod method;
    private HashMap<String, Integer> strategies;
    private static final Logger LOGGER = LoggerFactory.getLogger(NIOStreamImpl.class);
    private AtomicBoolean reporterShutdown = new AtomicBoolean(false);

    NIOStreamImpl(File filePath, long recommendedSize) throws IOException {
        this(filePath, NIOAccessMethod.getDefault(), recommendedSize, new HeapBufferSource(0x20000000L), null);
    }

    NIOStreamImpl(File filePath, NIOAccessMethod method, long recommendedSize, BufferSource writeBuffers, BufferSource recoveryBuffers) throws IOException {
        this.directory = filePath;
        this.fsyncLatencyBin = new Log2LatencyBins("FRS Sync: " + this.directory);
        this.filePool = writeBuffers;
        this.replayPool = recoveryBuffers;
        if (this.replayPool == null) {
            this.replayPool = this.filePool;
        }
        if (LOGGER.isDebugEnabled()) {
            this.strategies = new HashMap();
        }
        this.segmentSize = recommendedSize;
        LOGGER.debug("==CONFIG(nio)==" + filePath.getAbsolutePath() + " using a segment size of " + this.segmentSize / 0x100000L);
        this.segments = new NIOSegmentList(this.directory);
        if (this.segments.isEmpty()) {
            this.streamId = UUID.randomUUID();
        } else {
            try {
                NIOSegment seg = new NIOSegment(this, this.segments.getBeginningFile());
                seg.openForHeader();
                this.streamId = seg.getStreamId();
            }
            catch (HeaderException header) {
                this.streamId = UUID.randomUUID();
            }
            catch (IOException ioe) {
                this.streamId = UUID.randomUUID();
            }
        }
        this.method = method;
        if (REPORT_FSYNC_LATENCIES != null && REPORT_FSYNC_LATENCIES > 0) {
            LOGGER.info("Reporting fsync latencies every " + REPORT_FSYNC_LATENCIES + " seconds");
            this.reporterThread = this.fsyncLatencyBin.reporterThread(NIOStreamImpl.makeReporterShutdownSupplier(this.reporterShutdown), REPORT_FSYNC_LATENCIES.intValue(), TimeUnit.SECONDS, 0L, NIOStreamImpl.makeLatencyConsumer(this.fsyncLatencyBin));
            this.reporterThread.start();
        } else {
            this.reporterThread = null;
        }
    }

    private static BooleanSupplier makeReporterShutdownSupplier(AtomicBoolean signal) {
        return () -> !signal.get();
    }

    private static Consumer<Log2LatencyBins> makeLatencyConsumer(Log2LatencyBins fsyncLatencyBin) {
        return b -> {
            LOGGER.info(b.toString(Log2LatencyBins.ToString.NO_RANGES_AND_ZEROS, b.binCounts(), b.count()));
            fsyncLatencyBin.sloppyReset();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NIORandomAccess createRandomAccess(BufferSource src) {
        if (this.randomAccess == null) {
            NIOStreamImpl nIOStreamImpl = this;
            synchronized (nIOStreamImpl) {
                if (this.randomAccess == null) {
                    this.randomAccess = new NIORandomAccess(this, this.segments, src);
                }
            }
        }
        return this.randomAccess;
    }

    void disableSync(boolean disabled) {
        this.syncDisabled = disabled;
    }

    private void hintRandomAccess(long marker, int segmentId) {
        if (this.randomAccess != null) {
            this.randomAccess.hint(marker, segmentId);
        }
    }

    NIOAccessMethod getAccessMethod() {
        return this.method;
    }

    public void setBufferBuilder(BufferBuilder builder) {
        this.createBuffer = builder;
    }

    FileBuffer createFileBuffer(FileChannel channel, int bufferSize) throws IOException {
        FileBuffer created = this.createBuffer != null ? this.createBuffer.createBuffer(channel, this.filePool, bufferSize) : new FileBuffer(channel, this.filePool, bufferSize);
        return created;
    }

    @Override
    public UUID getStreamId() {
        return this.streamId;
    }

    public void setMinimumMarker(long lowestMarker) {
        this.lowestMarker = lowestMarker;
    }

    public long getMarker() {
        return this.currentMarker;
    }

    public long getSyncdMarker() {
        return this.fsyncdMarker;
    }

    public long getMinimumMarker() {
        return this.lowestMarker;
    }

    boolean checkForCleanExit() throws IOException {
        if (this.segments.isEmpty()) {
            return true;
        }
        NIOSegment seg = new NIOSegment(this, this.segments.getEndFile());
        try {
            seg.openForHeader();
        }
        catch (HeaderException header) {
            return false;
        }
        if (!seg.getStreamId().equals(this.streamId)) {
            throw new IOException(BAD_STREAM_ID);
        }
        return seg.wasProperlyClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean open() throws IOException {
        if (this.segments.isEmpty()) {
            return false;
        }
        this.segments.setReadPosition(-1);
        if (!this.segments.isEmpty()) {
            ListIterator<File> files = this.segments.listIterator(this.segments.size());
            while (files.hasPrevious()) {
                File f = files.previous();
                try (WritingSegment seg = new WritingSegment(this, f);){
                    seg.open();
                    if (!seg.getStreamId().equals(this.streamId)) {
                        throw new IOException(BAD_STREAM_ID);
                    }
                    if (seg.last()) {
                        this.updateCurrentMarker(seg.getMaximumMarker());
                        this.updateSyncMarker(seg.getMaximumMarker());
                        this.lowestMarkerOnDisk = this.lowestMarker = seg.getMinimumMarker();
                        boolean bl = true;
                        return bl;
                    }
                }
                files.remove();
                if (!f.exists()) continue;
                throw new IOException("unable to make log stream consistent");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void limit(UUID streamId, int segment, long position) throws IOException {
        this.segments.setReadPosition(-1);
        File f = this.segments.nextReadFile(Direction.REVERSE);
        while (f != null) {
            try (WritingSegment seg = new WritingSegment(this, f);){
                seg.openForHeader();
                if (!seg.getStreamId().equals(streamId)) {
                    throw new IOException(BAD_STREAM_ID);
                }
                if (seg.getSegmentId() == segment) {
                    this.segments.removeFilesFromHead();
                    if (!this.segments.currentIsHead()) {
                        throw new IOException("unable to make log stream consistent");
                    }
                    seg.open();
                    seg.limit(position);
                    return;
                }
            }
            f = this.segments.nextReadFile(Direction.REVERSE);
        }
    }

    private boolean doubleCheck(File f) throws IOException {
        try (WritingSegment segment = new WritingSegment(this, f);){
            segment.open();
            if (segment.getBaseMarker() > this.lowestMarkerOnDisk) {
                boolean bl = false;
                return bl;
            }
            if (!segment.last()) {
                boolean bl = false;
                return bl;
            }
            if (segment.getMaximumMarker() > this.lowestMarkerOnDisk) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    long scanForEnd() throws IOException {
        File f;
        int count = this.segments.size();
        long size = 0L;
        for (int x = 0; x < count && (f = this.segments.get(x)) != null && f.exists(); ++x) {
            NIOSegment seg = new NIOSegment(this, f);
            try {
                seg.openForHeader();
            }
            catch (HeaderException header) {
                throw new IOException(header);
            }
            if (!seg.getStreamId().equals(this.streamId)) {
                throw new IOException(BAD_STREAM_ID);
            }
            if (seg.getBaseMarker() > this.lowestMarkerOnDisk || f.equals(this.segments.getEndFile())) break;
            size += seg.size();
        }
        return size;
    }

    long findLogTail() throws IOException {
        if (this.readHead != null) {
            throw new AssertionError((Object)"read head still active");
        }
        this.segments.setReadPosition(0);
        File f = this.segments.nextReadFile(Direction.FORWARD);
        long size = 0L;
        while (f != null) {
            NIOSegment seg = new NIOSegment(this, f);
            try {
                seg.openForHeader();
            }
            catch (HeaderException header) {
                throw new IOException(header);
            }
            if (!seg.getStreamId().equals(this.streamId)) {
                throw new IOException(BAD_STREAM_ID);
            }
            if (seg.getBaseMarker() > this.lowestMarkerOnDisk) {
                File last = this.segments.nextReadFile(Direction.REVERSE);
                size = last != null ? (size -= last.length()) : 0L;
                return size;
            }
            if (f.equals(this.segments.getEndFile())) {
                return size;
            }
            size += seg.size();
            f = this.segments.nextReadFile(Direction.FORWARD);
        }
        return size;
    }

    long trimLogTail(long timeout) throws IOException {
        if (this.findLogTail() != 0L) {
            File last = this.segments.getCurrentReadFile();
            assert (last != null);
            if (this.doubleCheck(last)) {
                if (this.randomAccess != null) {
                    this.randomAccess.closeToReadHead();
                }
                long size = this.segments.removeFilesFromTail();
                return size;
            }
        }
        return 0L;
    }

    @Override
    public long append(Chunk c, long marker) throws IOException {
        if (this.writeHead == null || this.writeHead.isClosed()) {
            File f = this.segments.appendFile();
            try {
                this.writeHead = new WritingSegment(this, f).open();
            }
            catch (HeaderException header) {
                throw new IOException(header);
            }
            this.writeHead.insertFileHeader(this.lowestMarker, this.currentMarker + 1L);
            this.hintRandomAccess(this.currentMarker + 1L, this.writeHead.getSegmentId());
        }
        long w = this.writeHead.append(c, marker);
        this.updateCurrentMarker(marker);
        if (this.writeHead.size() > this.segmentSize || c instanceof SnapshotRequest) {
            this.closeSegment(this.writeHead);
        }
        return w;
    }

    @Override
    public long sync() throws IOException {
        if (this.syncDisabled) {
            return -2L;
        }
        if (this.writeHead != null && !this.writeHead.isClosed()) {
            if (this.currentMarker == this.fsyncdMarker) {
                return this.writeHead.position();
            }
            if (this.syncer != null) {
                this.syncer.pivot(this.writeHead);
                WritingSegment check = this.syncer.pivot(null);
                assert (check == this.writeHead);
                return this.writeHead.position();
            }
            long pos = this.writeHead.fsync(false);
            this.updateSyncMarker(this.writeHead.getMaximumMarker());
            this.lowestMarkerOnDisk = this.writeHead.getMinimumMarker();
            return pos;
        }
        LOGGER.debug("no sync on a closed stream");
        return -1L;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.reporterShutdown.set(true);
        if (this.writeHead != null && !this.writeHead.isClosed()) {
            this.closeSegment(this.writeHead);
        }
        this.writeHead = null;
        if (this.readHead != null && !this.readHead.isClosed()) {
            this.readHead.close();
        }
        this.readHead = null;
        if (this.reporterThread != null) {
            this.reporterThread.interrupt();
        }
        if (this.syncer != null) {
            this.syncer.interrupt();
            try {
                this.syncer.join();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }
        if (this.randomAccess != null) {
            this.randomAccess.close();
        }
        this.randomAccess = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("==PERFORMANCE(memory)==" + this.filePool.toString());
            StringBuilder slist = new StringBuilder();
            for (Map.Entry<String, Integer> e : this.strategies.entrySet()) {
                slist.append(" ");
                slist.append(e.getKey());
                slist.append(":");
                slist.append(e.getValue());
            }
            LOGGER.debug("==PERFORMANCE(strategies)==" + slist.toString());
        }
        this.filePool.reclaim();
    }

    @Override
    public Chunk read(Direction dir) throws IOException {
        while (this.readHead == null || !this.readHead.hasMore(dir)) {
            Chunk scanned;
            if (this.readHead != null) {
                this.readHead.close();
            }
            try {
                File f = this.segments.nextReadFile(dir);
                if (f == null) {
                    this.readHead = null;
                    return null;
                }
                ReadOnlySegment nextHead = new ReadOnlySegment(this, this.method, f, dir);
                nextHead.load(this.replayPool);
                this.hintRandomAccess(nextHead.getBaseMarker(), nextHead.getSegmentId());
                if (this.readHead != null) {
                    int expected = this.readHead.getSegmentId() + (dir == Direction.REVERSE ? -1 : 1);
                    if (nextHead.getSegmentId() != expected) {
                        throw new IOException("broken stream during readback expected:" + expected + " segment:" + this.segments.getSegmentPosition() + " actual:" + nextHead.getSegmentId() + " file:" + nextHead.getFile() + " list:" + this.segments.toString());
                    }
                }
                this.readHead = nextHead;
            }
            catch (HeaderException header) {
                throw new IOException(header);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            this.checkStreamId(this.readHead);
            if (dir != Direction.RANDOM || (scanned = this.readHead.scan(this.offset)) == null) continue;
            return scanned;
        }
        return this.readHead.next(dir);
    }

    private synchronized void updateSyncMarker(long marker) {
        this.fsyncdMarker = marker;
        if (this.currentMarker != this.fsyncdMarker) {
            throw new AssertionError((Object)"IO race");
        }
        if (this.markerWaiters > 0) {
            this.notifyAll();
        }
    }

    synchronized void waitForSyncdMarker(long lsn) throws InterruptedException {
        ++this.markerWaiters;
        try {
            while (lsn > this.fsyncdMarker) {
                this.wait();
            }
        }
        finally {
            --this.markerWaiters;
        }
    }

    private synchronized boolean requiresFsync() {
        return this.markerWaiters > 0;
    }

    private void updateCurrentMarker(long lsn) throws IOException {
        if (lsn < this.currentMarker) {
            throw new IllegalArgumentException("markers must always be increasing");
        }
        this.currentMarker = lsn;
        if (this.requiresFsync()) {
            this.writeHead.fsync(false);
            this.updateSyncMarker(this.writeHead.getMaximumMarker());
        }
    }

    void checkStreamId(NIOSegment segment) throws IOException {
        if (!this.streamId.equals(segment.getStreamId())) {
            throw new IOException(BAD_STREAM_ID);
        }
    }

    @Override
    public void seek(long loc) throws IOException {
        int segmentId;
        if (loc == IOManager.Seek.BEGINNING.getValue()) {
            this.replayPool = null;
        }
        if (loc > 0L) {
            NIORandomAccess ra = this.createRandomAccess(this.filePool);
            try {
                this.waitForSyncdMarker(loc);
                ReadOnlySegment ro = ra.seek(loc);
                if (ro == null) {
                    throw new IOException("bad seek");
                }
                segmentId = ro.getSegmentId();
                this.offset = loc;
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException();
            }
        } else {
            this.offset = -1L;
            segmentId = (int)loc;
        }
        if (this.readHead != null && (this.offset < 0L || segmentId != this.segments.getSegmentPosition())) {
            this.readHead.close();
            this.readHead = null;
        }
        this.segments.setReadPosition(segmentId);
    }

    int getSegmentId() {
        return this.readHead.getSegmentId();
    }

    long getTotalSize() {
        return this.segments.getTotalSize();
    }

    int getSegmentCount() {
        return this.segments.getCount();
    }

    @Override
    public Iterator<Chunk> iterator() {
        return new Iterator<Chunk>(){
            Chunk next;

            @Override
            public boolean hasNext() {
                try {
                    if (this.next != null) {
                        return true;
                    }
                    this.next = NIOStreamImpl.this.read(Direction.getDefault());
                    return this.next != null;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            @Override
            public Chunk next() {
                if (!this.hasNext()) {
                    throw new IndexOutOfBoundsException();
                }
                return this.next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    List<File> fileList() {
        return Collections.unmodifiableList(this.segments.copyList());
    }

    private void closeSegment(WritingSegment nio) throws IOException {
        nio.prepareForClose();
        if (this.syncer != null) {
            this.syncer.pivot(nio);
        } else {
            nio.close();
            this.currentMarker = nio.getMaximumMarker();
            this.updateSyncMarker(this.currentMarker);
            this.lowestMarkerOnDisk = nio.getMinimumMarker();
        }
    }

    public void recordFsyncLatency(long ns) {
        if (this.fsyncLatencyBin != null) {
            this.fsyncLatencyBin.record(ns);
        }
    }

    class FSyncer
    extends Thread {
        private Exchanger<WritingSegment> pivot = new Exchanger();

        public FSyncer() {
            this.setName("fsync helper");
            this.setDaemon(true);
        }

        WritingSegment pivot(WritingSegment target) {
            try {
                return this.pivot.exchange(target);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }

        @Override
        public void run() {
            try {
                WritingSegment seg = null;
                seg = this.pivot.exchange(seg);
                while (!Thread.interrupted()) {
                    if (seg != null) {
                        if (seg.isClosed()) {
                            seg.close();
                        } else {
                            seg.fsync(false);
                        }
                    }
                    NIOStreamImpl.this.updateSyncMarker(seg.getMaximumMarker());
                    NIOStreamImpl.this.lowestMarkerOnDisk = seg.getMinimumMarker();
                    seg = this.pivot.exchange(seg);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

