/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.nio.ChannelOpener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileChannelReadOpener
implements ChannelOpener {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileChannelReadOpener.class);
    private final File fileToOpen;
    private FileInputStream currentStream;
    private volatile boolean closed;

    FileChannelReadOpener(File fileToOpen) {
        this.fileToOpen = fileToOpen;
        this.currentStream = null;
        this.closed = false;
    }

    synchronized FileChannel open() throws IOException {
        this.closed = false;
        this.currentStream = new FileInputStream(this.fileToOpen);
        return this.currentStream.getChannel();
    }

    @Override
    public synchronized FileChannel reopen() throws IOException {
        if (this.closed) {
            throw new IOException("Channel for file " + this.fileToOpen.getName() + " cannot be reopened");
        }
        if (this.currentStream != null) {
            try {
                this.currentStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.currentStream = new FileInputStream(this.fileToOpen);
        return this.currentStream.getChannel();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void close() throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Close invoked from ", (Throwable)new Exception());
            StringBuilder stackTrace = new StringBuilder();
            stackTrace.append("DUMPING ENTIRE STACK").append(System.lineSeparator());
            Thread.getAllStackTraces().entrySet().stream().map(v -> {
                stackTrace.append("Thread ID: ").append(((Thread)v.getKey()).getName()).append(" STATE: ").append((Object)((Thread)v.getKey()).getState()).append(System.lineSeparator());
                return Arrays.asList((Object[])v.getValue());
            }).forEach(l -> l.stream().map(StackTraceElement::toString).forEach(s -> stackTrace.append((String)s).append(System.lineSeparator())));
            LOGGER.trace(stackTrace.toString());
        }
        this.closed = true;
        if (this.currentStream != null) {
            try {
                this.currentStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.currentStream = null;
    }
}

