/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.terracotta.shaded.lucene.index.AtomicReaderContext;
import org.terracotta.shaded.lucene.index.CoalescedUpdates;
import org.terracotta.shaded.lucene.index.DocsEnum;
import org.terracotta.shaded.lucene.index.Fields;
import org.terracotta.shaded.lucene.index.FrozenBufferedUpdates;
import org.terracotta.shaded.lucene.index.IndexWriter;
import org.terracotta.shaded.lucene.index.NumericFieldUpdates;
import org.terracotta.shaded.lucene.index.NumericUpdate;
import org.terracotta.shaded.lucene.index.ReadersAndUpdates;
import org.terracotta.shaded.lucene.index.SegmentCommitInfo;
import org.terracotta.shaded.lucene.index.SegmentInfos;
import org.terracotta.shaded.lucene.index.SegmentReader;
import org.terracotta.shaded.lucene.index.Term;
import org.terracotta.shaded.lucene.index.Terms;
import org.terracotta.shaded.lucene.index.TermsEnum;
import org.terracotta.shaded.lucene.search.DocIdSet;
import org.terracotta.shaded.lucene.search.DocIdSetIterator;
import org.terracotta.shaded.lucene.search.Query;
import org.terracotta.shaded.lucene.search.QueryWrapperFilter;
import org.terracotta.shaded.lucene.store.IOContext;
import org.terracotta.shaded.lucene.util.BytesRef;
import org.terracotta.shaded.lucene.util.InfoStream;

class BufferedUpdatesStream {
    private final List<FrozenBufferedUpdates> updates = new ArrayList<FrozenBufferedUpdates>();
    private long nextGen = 1L;
    private Term lastDeleteTerm;
    private final InfoStream infoStream;
    private final AtomicLong bytesUsed = new AtomicLong();
    private final AtomicInteger numTerms = new AtomicInteger();
    private static final Comparator<SegmentCommitInfo> sortSegInfoByDelGen = new Comparator<SegmentCommitInfo>(){

        @Override
        public int compare(SegmentCommitInfo si1, SegmentCommitInfo si2) {
            long cmp = si1.getBufferedDeletesGen() - si2.getBufferedDeletesGen();
            if (cmp > 0L) {
                return 1;
            }
            if (cmp < 0L) {
                return -1;
            }
            return 0;
        }
    };

    public BufferedUpdatesStream(InfoStream infoStream) {
        this.infoStream = infoStream;
    }

    public synchronized long push(FrozenBufferedUpdates packet) {
        packet.setDelGen(this.nextGen++);
        assert (packet.any());
        assert (this.checkDeleteStats());
        assert (packet.delGen() < this.nextGen);
        assert (this.updates.isEmpty() || this.updates.get(this.updates.size() - 1).delGen() < packet.delGen()) : "Delete packets must be in order";
        this.updates.add(packet);
        this.numTerms.addAndGet(packet.numTermDeletes);
        this.bytesUsed.addAndGet(packet.bytesUsed);
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "push deletes " + packet + " delGen=" + packet.delGen() + " packetCount=" + this.updates.size() + " totBytesUsed=" + this.bytesUsed.get());
        }
        assert (this.checkDeleteStats());
        return packet.delGen();
    }

    public synchronized void clear() {
        this.updates.clear();
        this.nextGen = 1L;
        this.numTerms.set(0);
        this.bytesUsed.set(0L);
    }

    public boolean any() {
        return this.bytesUsed.get() != 0L;
    }

    public int numTerms() {
        return this.numTerms.get();
    }

    public long bytesUsed() {
        return this.bytesUsed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ApplyDeletesResult applyDeletesAndUpdates(IndexWriter.ReaderPool readerPool, List<SegmentCommitInfo> infos) throws IOException {
        long t0 = System.currentTimeMillis();
        if (infos.size() == 0) {
            return new ApplyDeletesResult(false, this.nextGen++, null);
        }
        assert (this.checkDeleteStats());
        if (!this.any()) {
            if (this.infoStream.isEnabled("BD")) {
                this.infoStream.message("BD", "applyDeletes: no deletes; skipping");
            }
            return new ApplyDeletesResult(false, this.nextGen++, null);
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "applyDeletes: infos=" + infos + " packetCount=" + this.updates.size());
        }
        long gen = this.nextGen++;
        ArrayList<SegmentCommitInfo> infos2 = new ArrayList<SegmentCommitInfo>();
        infos2.addAll(infos);
        Collections.sort(infos2, sortSegInfoByDelGen);
        CoalescedUpdates coalescedUpdates = null;
        boolean anyNewDeletes = false;
        int infosIDX = infos2.size() - 1;
        int delIDX = this.updates.size() - 1;
        ArrayList<SegmentCommitInfo> allDeleted = null;
        while (infosIDX >= 0) {
            boolean segAllDeletes;
            int fullDelCount;
            Map<String, NumericFieldUpdates> fieldUpdates;
            int delCount;
            SegmentReader reader;
            ReadersAndUpdates rld;
            FrozenBufferedUpdates packet = delIDX >= 0 ? this.updates.get(delIDX) : null;
            SegmentCommitInfo info = (SegmentCommitInfo)infos2.get(infosIDX);
            long segGen = info.getBufferedDeletesGen();
            if (packet != null && segGen < packet.delGen()) {
                if (coalescedUpdates == null) {
                    coalescedUpdates = new CoalescedUpdates();
                }
                if (!packet.isSegmentPrivate) {
                    coalescedUpdates.update(packet);
                }
                --delIDX;
                continue;
            }
            if (packet != null && segGen == packet.delGen()) {
                assert (packet.isSegmentPrivate) : "Packet and Segments deletegen can only match on a segment private del packet gen=" + segGen;
                assert (readerPool.infoIsLive(info));
                rld = readerPool.get(info, true);
                reader = rld.getReader(IOContext.READ);
                delCount = 0;
                try {
                    fieldUpdates = null;
                    if (coalescedUpdates != null) {
                        delCount = (int)((long)delCount + this.applyTermDeletes(coalescedUpdates.termsIterable(), rld, reader));
                        delCount = (int)((long)delCount + BufferedUpdatesStream.applyQueryDeletes(coalescedUpdates.queriesIterable(), rld, reader));
                        fieldUpdates = this.applyNumericDocValuesUpdates(coalescedUpdates.numericDVUpdates, rld, reader, fieldUpdates);
                    }
                    delCount = (int)((long)delCount + BufferedUpdatesStream.applyQueryDeletes(packet.queriesIterable(), rld, reader));
                    fieldUpdates = this.applyNumericDocValuesUpdates(Arrays.asList(packet.updates), rld, reader, fieldUpdates);
                    if (!fieldUpdates.isEmpty()) {
                        rld.writeFieldUpdates(info.info.dir, fieldUpdates);
                    }
                    fullDelCount = rld.info.getDelCount() + rld.getPendingDeleteCount();
                    assert (fullDelCount <= rld.info.info.getDocCount());
                    segAllDeletes = fullDelCount == rld.info.info.getDocCount();
                }
                finally {
                    rld.release(reader);
                    readerPool.release(rld);
                }
                anyNewDeletes |= delCount > 0;
                if (segAllDeletes) {
                    if (allDeleted == null) {
                        allDeleted = new ArrayList<SegmentCommitInfo>();
                    }
                    allDeleted.add(info);
                }
                if (this.infoStream.isEnabled("BD")) {
                    this.infoStream.message("BD", "seg=" + info + " segGen=" + segGen + " segDeletes=[" + packet + "]; coalesced deletes=[" + (coalescedUpdates == null ? "null" : coalescedUpdates) + "] newDelCount=" + delCount + (segAllDeletes ? " 100% deleted" : ""));
                }
                if (coalescedUpdates == null) {
                    coalescedUpdates = new CoalescedUpdates();
                }
                --delIDX;
                --infosIDX;
                info.setBufferedDeletesGen(gen);
                continue;
            }
            if (coalescedUpdates != null) {
                assert (readerPool.infoIsLive(info));
                rld = readerPool.get(info, true);
                reader = rld.getReader(IOContext.READ);
                delCount = 0;
                try {
                    delCount = (int)((long)delCount + this.applyTermDeletes(coalescedUpdates.termsIterable(), rld, reader));
                    delCount = (int)((long)delCount + BufferedUpdatesStream.applyQueryDeletes(coalescedUpdates.queriesIterable(), rld, reader));
                    fieldUpdates = this.applyNumericDocValuesUpdates(coalescedUpdates.numericDVUpdates, rld, reader, null);
                    if (!fieldUpdates.isEmpty()) {
                        rld.writeFieldUpdates(info.info.dir, fieldUpdates);
                    }
                    fullDelCount = rld.info.getDelCount() + rld.getPendingDeleteCount();
                    assert (fullDelCount <= rld.info.info.getDocCount());
                    segAllDeletes = fullDelCount == rld.info.info.getDocCount();
                }
                finally {
                    rld.release(reader);
                    readerPool.release(rld);
                }
                anyNewDeletes |= delCount > 0;
                if (segAllDeletes) {
                    if (allDeleted == null) {
                        allDeleted = new ArrayList();
                    }
                    allDeleted.add(info);
                }
                if (this.infoStream.isEnabled("BD")) {
                    this.infoStream.message("BD", "seg=" + info + " segGen=" + segGen + " coalesced deletes=[" + coalescedUpdates + "] newDelCount=" + delCount + (segAllDeletes ? " 100% deleted" : ""));
                }
            }
            info.setBufferedDeletesGen(gen);
            --infosIDX;
        }
        assert (this.checkDeleteStats());
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "applyDeletes took " + (System.currentTimeMillis() - t0) + " msec");
        }
        return new ApplyDeletesResult(anyNewDeletes, gen, allDeleted);
    }

    synchronized long getNextGen() {
        return this.nextGen++;
    }

    public synchronized void prune(SegmentInfos segmentInfos) {
        assert (this.checkDeleteStats());
        long minGen = Long.MAX_VALUE;
        for (SegmentCommitInfo info : segmentInfos) {
            minGen = Math.min(info.getBufferedDeletesGen(), minGen);
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "prune sis=" + segmentInfos + " minGen=" + minGen + " packetCount=" + this.updates.size());
        }
        int limit = this.updates.size();
        for (int delIDX = 0; delIDX < limit; ++delIDX) {
            if (this.updates.get(delIDX).delGen() < minGen) continue;
            this.prune(delIDX);
            assert (this.checkDeleteStats());
            return;
        }
        this.prune(limit);
        assert (!this.any());
        assert (this.checkDeleteStats());
    }

    private synchronized void prune(int count) {
        if (count > 0) {
            if (this.infoStream.isEnabled("BD")) {
                this.infoStream.message("BD", "pruneDeletes: prune " + count + " packets; " + (this.updates.size() - count) + " packets remain");
            }
            for (int delIDX = 0; delIDX < count; ++delIDX) {
                FrozenBufferedUpdates packet = this.updates.get(delIDX);
                this.numTerms.addAndGet(-packet.numTermDeletes);
                assert (this.numTerms.get() >= 0);
                this.bytesUsed.addAndGet(-packet.bytesUsed);
                assert (this.bytesUsed.get() >= 0L);
            }
            this.updates.subList(0, count).clear();
        }
    }

    private synchronized long applyTermDeletes(Iterable<Term> termsIter, ReadersAndUpdates rld, SegmentReader reader) throws IOException {
        long delCount = 0L;
        Fields fields = reader.fields();
        if (fields == null) {
            return 0L;
        }
        TermsEnum termsEnum = null;
        String currentField = null;
        DocsEnum docs = null;
        assert (this.checkDeleteTerm(null));
        boolean any = false;
        for (Term term : termsIter) {
            int docID;
            DocsEnum docsEnum;
            if (!term.field().equals(currentField)) {
                assert (currentField == null || currentField.compareTo(term.field()) < 0);
                currentField = term.field();
                Terms terms = fields.terms(currentField);
                termsEnum = terms != null ? terms.iterator(termsEnum) : null;
            }
            if (termsEnum == null) continue;
            assert (this.checkDeleteTerm(term));
            if (!termsEnum.seekExact(term.bytes()) || (docsEnum = termsEnum.docs(rld.getLiveDocs(), docs, 0)) == null) continue;
            while ((docID = docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                if (!any) {
                    rld.initWritableLiveDocs();
                    any = true;
                }
                if (!rld.delete(docID)) continue;
                ++delCount;
            }
        }
        return delCount;
    }

    private synchronized Map<String, NumericFieldUpdates> applyNumericDocValuesUpdates(Iterable<NumericUpdate> updates, ReadersAndUpdates rld, SegmentReader reader, Map<String, NumericFieldUpdates> otherFieldUpdates) throws IOException {
        Fields fields = reader.fields();
        if (fields == null) {
            return Collections.emptyMap();
        }
        String currentField = null;
        TermsEnum termsEnum = null;
        DocsEnum docs = null;
        HashMap<String, NumericFieldUpdates> result = otherFieldUpdates == null ? new HashMap<String, NumericFieldUpdates>() : otherFieldUpdates;
        for (NumericUpdate update : updates) {
            int doc;
            Term term = update.term;
            int limit = update.docIDUpto;
            if (!term.field().equals(currentField)) {
                currentField = term.field();
                Terms terms = fields.terms(currentField);
                if (terms != null) {
                    termsEnum = terms.iterator(termsEnum);
                } else {
                    termsEnum = null;
                    continue;
                }
            }
            if (termsEnum == null || !termsEnum.seekExact(term.bytes())) continue;
            DocsEnum docsEnum = termsEnum.docs(rld.getLiveDocs(), docs, 0);
            NumericFieldUpdates fieldUpdates = (NumericFieldUpdates)result.get(update.field);
            if (fieldUpdates == null) {
                fieldUpdates = new NumericFieldUpdates.PackedNumericFieldUpdates(reader.maxDoc());
                result.put(update.field, fieldUpdates);
            }
            while ((doc = docsEnum.nextDoc()) != Integer.MAX_VALUE && doc < limit) {
                fieldUpdates.add(doc, update.value);
            }
        }
        return result;
    }

    private static long applyQueryDeletes(Iterable<QueryAndLimit> queriesIter, ReadersAndUpdates rld, SegmentReader reader) throws IOException {
        long delCount = 0L;
        AtomicReaderContext readerContext = reader.getContext();
        boolean any = false;
        for (QueryAndLimit ent : queriesIter) {
            int doc;
            DocIdSetIterator it;
            Query query = ent.query;
            int limit = ent.limit;
            DocIdSet docs = new QueryWrapperFilter(query).getDocIdSet(readerContext, reader.getLiveDocs());
            if (docs == null || (it = docs.iterator()) == null) continue;
            while ((doc = it.nextDoc()) < limit) {
                if (!any) {
                    rld.initWritableLiveDocs();
                    any = true;
                }
                if (!rld.delete(doc)) continue;
                ++delCount;
            }
        }
        return delCount;
    }

    private boolean checkDeleteTerm(Term term) {
        if (term != null) assert (this.lastDeleteTerm == null || term.compareTo(this.lastDeleteTerm) > 0) : "lastTerm=" + this.lastDeleteTerm + " vs term=" + term;
        this.lastDeleteTerm = term == null ? null : new Term(term.field(), BytesRef.deepCopyOf(term.bytes));
        return true;
    }

    private boolean checkDeleteStats() {
        int numTerms2 = 0;
        long bytesUsed2 = 0L;
        for (FrozenBufferedUpdates packet : this.updates) {
            numTerms2 += packet.numTermDeletes;
            bytesUsed2 += (long)packet.bytesUsed;
        }
        assert (numTerms2 == this.numTerms.get()) : "numTerms2=" + numTerms2 + " vs " + this.numTerms.get();
        assert (bytesUsed2 == this.bytesUsed.get()) : "bytesUsed2=" + bytesUsed2 + " vs " + this.bytesUsed;
        return true;
    }

    public static class QueryAndLimit {
        public final Query query;
        public final int limit;

        public QueryAndLimit(Query query, int limit) {
            this.query = query;
            this.limit = limit;
        }
    }

    public static class ApplyDeletesResult {
        public final boolean anyDeletes;
        public final long gen;
        public final List<SegmentCommitInfo> allDeleted;

        ApplyDeletesResult(boolean anyDeletes, long gen, List<SegmentCommitInfo> allDeleted) {
            this.anyDeletes = anyDeletes;
            this.gen = gen;
            this.allDeleted = allDeleted;
        }
    }
}

