/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.terracotta.security;

import java.util.concurrent.atomic.AtomicReference;
import org.terracotta.toolkit.SecretProvider;

public class SingletonSecretProviderWrapper
implements SecretProvider {
    private static final AtomicReference<SecretProvider> delegate = new AtomicReference();

    public static void useAsDelegate(String secretProviderClassname) {
        Class<?> c = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                c = loader.loadClass(secretProviderClassname);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        try {
            if (c == null) {
                c = SingletonSecretProviderWrapper.class.getClassLoader().loadClass(secretProviderClassname);
            }
            delegate.set((SecretProvider)c.newInstance());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("SecretProvider initialization problem: Check the value of property \"%s\" (currently set to \"%s\"), the class it matches or your classpath", "com.terracotta.express.SecretProvider", secretProviderClassname), e);
        }
        delegate.get().fetchSecret();
    }

    public void fetchSecret() {
    }

    public byte[] getSecret() {
        return delegate.get().getSecret();
    }
}

