/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search.store;

import com.terracottatech.offheapstore.filesystem.Directory;
import com.terracottatech.offheapstore.filesystem.File;
import com.terracottatech.offheapstore.filesystem.FileSystem;
import com.terracottatech.search.store.ConcurrentLockFactory;
import com.terracottatech.search.store.OffHeapIndexInputStream;
import com.terracottatech.search.store.OffHeapIndexOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.terracotta.shaded.lucene.store.BaseDirectory;
import org.terracotta.shaded.lucene.store.IOContext;
import org.terracotta.shaded.lucene.store.IndexInput;
import org.terracotta.shaded.lucene.store.IndexOutput;

public class OffHeapDirectory
extends BaseDirectory
implements Serializable {
    private final Directory directory;

    public OffHeapDirectory(FileSystem fileSystem, String name) throws IOException {
        if (fileSystem.directoryExists(name)) {
            fileSystem.deleteDirectory(name);
        }
        this.directory = fileSystem.getOrCreateDirectory(name);
        this.setLockFactory(new ConcurrentLockFactory());
    }

    @Override
    public synchronized String[] listAll() throws IOException {
        return this.directory.listFiles().toArray(new String[0]);
    }

    @Override
    public boolean fileExists(String name) {
        return this.directory.fileExists(name);
    }

    @Override
    public void deleteFile(String name) throws IOException {
        if (!this.fileExists(name)) {
            throw new FileNotFoundException(name);
        }
        this.directory.deleteFile(name);
    }

    @Override
    public long fileLength(String name) throws IOException {
        return this.directory.getOrCreateFile(name).length();
    }

    @Override
    public IndexOutput createOutput(String name, IOContext ctxt) throws IOException {
        return new OffHeapIndexOutputStream(this.directory.getOrCreateFile(name));
    }

    @Override
    public IndexInput openInput(String name, IOContext ctxt) throws IOException {
        return new OffHeapIndexInputStream(this.directory.getOrCreateFile(name));
    }

    @Override
    public synchronized void close() throws IOException {
        this.directory.deleteAllFiles();
        this.isOpen = false;
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        Set<String> knownFiles = this.directory.listFiles();
        for (String fileName : names) {
            if (!knownFiles.contains(fileName)) continue;
            File f = this.directory.getOrCreateFile(fileName);
            f.getOutputStream().flush();
        }
    }
}

